/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;

public class DataAPIUtilities {
    public static final int[] EMPTY_ROWS = new int[0];

    public static int getTableIndex(VisInterface visInterface, Object object) {
        Data[] dataArray = visInterface.getData();
        if (BasicFactory.isNumber(object)) {
            int n = ((Number)object).intValue();
            if (n >= 0 && n < dataArray.length) {
                return n;
            }
            return -1;
        }
        if (BasicFactory.isString(object)) {
            IdentifiableItem identifiableItem = visInterface.getByID((String)object);
            if (identifiableItem instanceof Data) {
                return ((Data)identifiableItem).getIndex();
            }
            if (identifiableItem instanceof Field) {
                return ((Field)identifiableItem).getDataIndex();
            }
        }
        return -1;
    }

    public static int getUniqueValidRow(VisInterface visInterface, int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        Data[] dataArray = visInterface.getData();
        if (n < 0 || n >= dataArray.length) {
            return -1;
        }
        int n2 = dataArray[n].rows.length;
        int n3 = -1;
        for (int n4 : nArray) {
            if (n4 < 0 || n4 >= n2) continue;
            if (n3 != -1 && n3 != n4) {
                return -1;
            }
            n3 = n4;
        }
        return n3;
    }

    public static int[] getRowsInTable(VisInterface visInterface, int n, int[] nArray, int n2, int n3) {
        int[] nArray2;
        int n4;
        int n5;
        if (nArray == null) {
            return EMPTY_ROWS;
        }
        int n6 = DataAPIUtilities.checkTablesAndGetPosition(visInterface, n, n3);
        if (n6 < 0) {
            return EMPTY_ROWS;
        }
        Data[] dataArray = visInterface.getData();
        IntPrimitiveArrayList intPrimitiveArrayList = DataAPIUtilities.getUniqueValidRows(nArray, dataArray[n].rows.length);
        if (intPrimitiveArrayList.size() == 0) {
            return EMPTY_ROWS;
        }
        int n7 = n2 >= 0 && intPrimitiveArrayList.contains(n2) ? n2 : -1;
        int[] nArray3 = dataArray[n].getDataIndexes();
        for (n5 = 0; n5 < n6; ++n5) {
            int n8 = nArray3[n5];
            Row[] rowArray = dataArray[n8].rows;
            if (n7 >= 0) {
                n7 = rowArray[n7].getPrimaryRow();
            }
            IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
            n4 = intPrimitiveArrayList.size();
            for (int i = 0; i < n4; ++i) {
                rowArray[intPrimitiveArrayList.get(i)].addOriginalRows(intPrimitiveArrayList2, true);
            }
            intPrimitiveArrayList = intPrimitiveArrayList2;
        }
        n5 = intPrimitiveArrayList.size();
        if (n7 >= 0) {
            nArray2 = new int[n5];
            int n9 = 0;
            nArray2[n9++] = n7;
            for (int i = 0; i < n5; ++i) {
                n4 = intPrimitiveArrayList.get(i);
                if (n4 == n7) continue;
                nArray2[n9++] = n4;
            }
        } else {
            nArray2 = intPrimitiveArrayList.toArray();
        }
        return nArray2;
    }

    public static int getPrimaryRowInTable(VisInterface visInterface, int n, int n2, int n3) {
        int n4 = DataAPIUtilities.checkTablesAndGetPosition(visInterface, n, n3);
        if (n4 < 0) {
            return -1;
        }
        Data[] dataArray = visInterface.getData();
        Data data = dataArray[n];
        if (n2 < 0 || n2 >= data.rows.length) {
            return -1;
        }
        int n5 = n2;
        int[] nArray = dataArray[n].getDataIndexes();
        for (int i = 0; n5 >= 0 && i < n4; ++i) {
            n5 = dataArray[nArray[i]].rows[n5].getPrimaryRow();
        }
        return n5;
    }

    public static int checkTablesAndGetPosition(VisInterface visInterface, int n, int n2) {
        Data[] dataArray = visInterface.getData();
        if (n < 0 || n >= dataArray.length || n2 < 0 || n2 >= dataArray.length) {
            return -1;
        }
        int[] nArray = dataArray[n].getDataIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    private static IntPrimitiveArrayList getUniqueValidRows(int[] nArray, int n) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (int n2 : nArray) {
            if (n2 < 0 || n2 >= n || intPrimitiveArrayList.contains(n2)) continue;
            intPrimitiveArrayList.add(n2);
        }
        return intPrimitiveArrayList;
    }
}

