/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.data.DataDescriptor;
import com.ibm.vis.engine.data.FieldDescriptor;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.DataAPIUtilities;
import com.ibm.vis.engine.internal.data.FieldDescriptorImpl;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;

public class DataDescriptorImpl
implements DataDescriptor {
    private final Data data;

    public DataDescriptorImpl(Data data) {
        this.data = data;
    }

    @Override
    public int getIndex() {
        return this.data.getIndex();
    }

    @Override
    public int[] getDataIndexes() {
        return this.data.getDataIndexes();
    }

    @Override
    public String getId() {
        return this.data.id;
    }

    @Override
    public FieldDescriptor[] getFieldDescriptors() {
        int n = this.data.fields.length;
        FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[n];
        for (int i = 0; i < n; ++i) {
            fieldDescriptorArray[i] = new FieldDescriptorImpl(this.data.fields[i]);
        }
        return fieldDescriptorArray;
    }

    @Override
    public int getFieldIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.data.fields.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.data.fields[i].id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Number[][] getRows() {
        int n = this.data.rows.length;
        Number[][] numberArray = new Number[n][];
        for (int i = 0; i < n; ++i) {
            numberArray[i] = this.makeRow(i);
        }
        return numberArray;
    }

    @Override
    public int getRowCount() {
        return this.data.rows.length;
    }

    @Override
    public Number[] getRow(int n) {
        if (n < 0 || n >= this.data.rows.length) {
            return new Number[0];
        }
        return this.makeRow(n);
    }

    private Number[] makeRow(int n) {
        int n2 = this.data.fields.length;
        double[] dArray = this.data.rows[n].data;
        Number[] numberArray = new Number[n2];
        for (int i = 0; i < n2; ++i) {
            double d = dArray[i];
            numberArray[i] = Double.isNaN(d) ? null : Double.valueOf(d);
        }
        return numberArray;
    }

    @Override
    public int[] getRowsWithoutAugmentedRows(int[] nArray) {
        return this.data.getRowsWithoutAugmentedRows(nArray);
    }

    @Override
    public int getSourceTable() {
        return this.data.getSource() == null ? -1 : this.data.getSource().getIndex();
    }

    @Override
    public String getTransformType() {
        return this.data.getTransformType();
    }

    @Override
    public boolean hasPrimaryRows() {
        return this.data.hasPrimaryRows();
    }

    @Override
    public int[] getOriginalRows(int n) {
        if (this.data.getSource() == null) {
            return DataAPIUtilities.EMPTY_ROWS;
        }
        return this.getRowsInTable(new int[]{n}, this.data.getSource().getIndex());
    }

    @Override
    public int[] getRowsInTable(int[] nArray, Object object) {
        if (nArray == null) {
            return DataAPIUtilities.EMPTY_ROWS;
        }
        VisInterface visInterface = this.data.visContext.getParentVis();
        int n = object == null ? this.data.getIndex() : DataAPIUtilities.getTableIndex(visInterface, object);
        int n2 = DataAPIUtilities.getUniqueValidRow(visInterface, this.data.getIndex(), nArray);
        return DataAPIUtilities.getRowsInTable(visInterface, this.data.getIndex(), nArray, n2, n);
    }

    @Override
    public int getPrimaryRow(int n) {
        if (this.data.getSource() == null || n < 0 || n >= this.data.rows.length) {
            return -1;
        }
        return this.data.rows[n].getPrimaryRow();
    }

    @Override
    public int getPrimaryRowInTable(int n, Object object) {
        VisInterface visInterface = this.data.visContext.getParentVis();
        int n2 = object == null ? this.data.getIndex() : DataAPIUtilities.getTableIndex(visInterface, object);
        return DataAPIUtilities.getPrimaryRowInTable(visInterface, this.data.getIndex(), n, n2);
    }

    @Override
    public JSONObject makeJSONSpec() {
        int n;
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "id", this.data.id);
        int n2 = this.data.fields.length;
        JSONArray jSONArray = BasicFactory.createSizedJSONArray(n2);
        for (n = 0; n < n2; ++n) {
            BasicFactory.addAt(jSONArray, FieldDescriptorImpl.makeJSONSpecForField(this.data.fields[n]), n);
        }
        BasicFactory.put(jSONObject, "fields", jSONArray);
        n = this.data.rows.length;
        JSONArray jSONArray2 = BasicFactory.createSizedJSONArray(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.data.rows[i].data;
            JSONArray jSONArray3 = BasicFactory.createSizedJSONArray(n2);
            for (int j = 0; j < n2; ++j) {
                BasicFactory.addAt(jSONArray3, Double.isNaN(dArray[j]) ? null : Double.valueOf(dArray[j]), j);
            }
            BasicFactory.addAt(jSONArray2, jSONArray3, i);
        }
        BasicFactory.put(jSONObject, "rows", jSONArray2);
        return jSONObject;
    }
}

