/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Grouping;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class DerivedData {
    private final Grouping grouping;
    private final Transform transform;

    public DerivedData(Grouping grouping, Transform transform) {
        this.grouping = grouping;
        this.transform = transform;
    }

    public final Grouping getGrouping() {
        return this.grouping;
    }

    public Row[] calculate(Row[] rowArray) {
        int n;
        int n2 = this.grouping.getOutputFieldCount() + this.transform.getOutputFieldCount();
        Group[] groupArray = this.grouping.makeGroupings();
        Row[] rowArray2 = new Row[this.transform.getTotalOutputCount(groupArray, rowArray)];
        for (n = 0; n < rowArray2.length; ++n) {
            rowArray2[n] = Row.createEmptyRow(n2, n);
        }
        n = 0;
        double d = this.transform.getMultiplier();
        double d2 = this.getSumOfWeights(rowArray, null);
        for (Group group : groupArray) {
            IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
            int n3 = this.transform.getOutputCount(intPrimitiveArrayList);
            double d3 = d2 == 0.0 ? (double)intPrimitiveArrayList.size() / (double)rowArray.length : this.getSumOfWeights(rowArray, intPrimitiveArrayList) / d2;
            this.grouping.setRowValues(intPrimitiveArrayList, rowArray2, n, n3);
            this.transform.setMultiplier(d * d3);
            this.transform.setValues(rowArray, group, rowArray2, n, n3);
            n += n3;
        }
        return rowArray2;
    }

    private double getSumOfWeights(Row[] rowArray, IntPrimitiveArrayList intPrimitiveArrayList) {
        double d = 0.0;
        if (intPrimitiveArrayList != null) {
            for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                d += this.transform.getWeight(rowArray[intPrimitiveArrayList.get(i)]);
            }
        } else {
            for (Row row : rowArray) {
                d += this.transform.getWeight(row);
            }
        }
        return d;
    }

    public Transform getTransform() {
        return this.transform;
    }
}

