/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FormatSpec;
import java.util.Arrays;

public final class Field
extends IdentifiableItem {
    public final Data data;
    private int index;
    public String[] categories;
    public int[] order;
    public String label;
    public Unit unit;
    public Range range;
    private Range rangeIgnoringZeros;
    public Double granularity;
    public boolean isKey;
    private String sourceField;
    private String sourceOperation;
    public final FieldSpec spec;
    private final RAVEFormatter specifiedFormatter;
    private int[] usedCategories;
    public final String timeZone;
    private RAVEFormatter localFormatter;
    private LocalFormatterType localFormatterType;

    public static Field createSimpleField(VisInterface visInterface, FieldSpec fieldSpec, Data data, int n, Unit unit) {
        Range range;
        if (unit == null) {
            unit = fieldSpec.categories == null ? Unit.RATIO : Unit.CATEGORICAL;
        }
        Unit unit2 = Unit.get(fieldSpec.unit, unit);
        Number number = fieldSpec.min;
        Number number2 = fieldSpec.max;
        double d = number == null ? Double.NaN : number.doubleValue();
        double d2 = number2 == null ? Double.NaN : number2.doubleValue();
        VisContext visContext = visInterface != null ? visInterface.getVisContext() : null;
        RAVEFormatter rAVEFormatter = RAVEFormatter.makeFromSpec(fieldSpec.format, visContext != null ? visContext.getLocale() : null);
        String[] stringArray = null;
        int[] nArray = null;
        if (fieldSpec.categories != null) {
            stringArray = new String[fieldSpec.categories.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = fieldSpec.categories[i];
            }
            range = new Range(-0.5, (double)fieldSpec.categories.length - 0.5);
            if (fieldSpec.order != null) {
                nArray = Field.computeCategoriesOrder(fieldSpec.categories, fieldSpec.order);
            }
        } else {
            range = new Range(d, d2);
        }
        return new Field(fieldSpec.id, visInterface, fieldSpec, data, n, fieldSpec.label, unit2, range, stringArray, nArray, rAVEFormatter);
    }

    public static int[] computeCategoriesOrder(String[] stringArray, Number[] numberArray) {
        int n;
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
        }
        int n3 = 0;
        for (n = 0; n < numberArray.length; ++n) {
            if (Math.floor(numberArray[n].doubleValue()) < numberArray[n].doubleValue()) {
                throw new SpecException("Double value given for category index: integer expected.", ErrorCode.DATA_CONVERSION, null);
            }
            int n4 = numberArray[n].intValue();
            if (n4 >= n2 || blArray[n4]) continue;
            nArray[n3++] = n4;
            blArray[n4] = true;
        }
        if (n2 > n3) {
            int n5 = 0;
            for (n = n3; n < n2; ++n) {
                while (blArray[n5]) {
                    ++n5;
                }
                nArray[n] = n5++;
            }
        }
        return nArray;
    }

    public static double[] getValuesAsZeroOne(Row row, Field[] fieldArray) {
        if (fieldArray == null) {
            return null;
        }
        double[] dArray = new double[fieldArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = row.data[fieldArray[i].index];
            dArray[i] = fieldArray[i].range.toZeroOne(d);
        }
        return dArray;
    }

    protected Field(String string, VisInterface visInterface, FieldSpec fieldSpec, Data data, int n, String string2, Unit unit, Range range, String[] stringArray, int[] nArray, RAVEFormatter rAVEFormatter) {
        super(string, visInterface);
        Number number;
        this.data = data;
        this.index = n;
        this.label = string2 == null ? string : string2;
        this.range = range;
        this.rangeIgnoringZeros = null;
        this.categories = stringArray;
        this.order = nArray;
        this.spec = fieldSpec;
        this.sourceField = null;
        this.sourceOperation = null;
        this.isKey = fieldSpec != null && fieldSpec.key != null ? fieldSpec.key : false;
        this.specifiedFormatter = rAVEFormatter;
        this.unit = unit == null ? (this.categories == null ? Unit.RATIO : Unit.CATEGORICAL) : unit;
        Number number2 = number = fieldSpec != null ? (Number)fieldSpec.granularity : (Number)null;
        if (number != null) {
            this.granularity = number.doubleValue();
        } else if (this.unit.measure.categorical) {
            this.granularity = 1.0;
        }
        this.usedCategories = null;
        this.timeZone = fieldSpec != null && fieldSpec.timeZone != null && fieldSpec.timeZone.length() > 0 ? fieldSpec.timeZone : "GMT";
    }

    public FieldSpec getFieldSpec() {
        FieldSpec fieldSpec = new FieldSpec();
        fieldSpec.categories = this.categories == null ? null : Arrays.copyOf(this.categories, this.categories.length);
        fieldSpec.format = RAVEFormatter.makeFormatSpecFromRAVEFormatter(this.specifiedFormatter);
        fieldSpec.granularity = this.granularity;
        fieldSpec.id = this.id;
        fieldSpec.key = this.isKey;
        fieldSpec.label = this.label;
        if (this.categories == null) {
            double d = this.range.getMax();
            double d2 = this.range.getMin();
            fieldSpec.max = Double.isNaN(d) ? null : Double.valueOf(d);
            Number number = fieldSpec.min = Double.isNaN(d2) ? null : Double.valueOf(d2);
        }
        if (this.order == null) {
            fieldSpec.order = null;
        } else {
            fieldSpec.order = new Number[this.order.length];
            for (int i = 0; i < this.order.length; ++i) {
                fieldSpec.order[i] = this.order[i];
            }
        }
        fieldSpec.unit = this.unit == null ? null : this.unit.name;
        fieldSpec.timeZone = this.timeZone;
        return fieldSpec;
    }

    public Range getRangeIgnoringZeros() {
        if (this.rangeIgnoringZeros == null) {
            if (this.unit.measure == Measure.CATEGORY || this.unit.measure == Measure.DATETIME) {
                this.rangeIgnoringZeros = this.range;
            } else {
                double d = Double.NaN;
                double d2 = Double.NaN;
                if (this.data != null && this.data.rows != null) {
                    for (Row row : this.data.rows) {
                        double d3 = row.data[this.index];
                        if (Double.isNaN(d3) || d3 == 0.0) continue;
                        if (Double.isNaN(d)) {
                            d = d3;
                            d2 = d3;
                            continue;
                        }
                        if (d3 < d) {
                            d = d3;
                        }
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                    }
                }
                this.rangeIgnoringZeros = new Range(d, d2);
            }
        }
        return this.rangeIgnoringZeros;
    }

    final String getSourceField() {
        return this.sourceField;
    }

    public final void setSourceField(String string) {
        this.sourceField = string;
    }

    public final String getSourceOperation() {
        return this.sourceOperation;
    }

    public final void setSourceOperation(String string) {
        this.sourceOperation = string;
    }

    public int[] getUsedCategories() {
        if (this.usedCategories == null) {
            this.usedCategories = this.findUsedCategories();
        }
        return this.usedCategories;
    }

    private int[] findUsedCategories() {
        int n;
        if (this.categories == null || this.data == null || this.data.rows == null || this.categories.length == 0) {
            return null;
        }
        int n2 = this.categories.length;
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            blArray[i] = false;
        }
        Row[] rowArray = this.data.rows;
        int n3 = rowArray.length;
        for (n = 0; n < n3; ++n) {
            Row row = rowArray[n];
            double d = row.data[this.index];
            if (Double.isNaN(d)) continue;
            blArray[(int)d] = true;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (!blArray[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        int[] nArray = new int[n4];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public void copyDerivedInfo(Field field) {
        if (this.categories == null && field.categories != null) {
            this.categories = field.categories;
            this.usedCategories = field.usedCategories;
            this.range = field.range;
        }
        if (this.label == null || this.label.equals(this.id)) {
            this.label = field.label;
        }
        if (this.unit == null) {
            this.unit = field.unit;
        }
    }

    public void copyRange(Field field) {
        this.range = field.range;
    }

    public String getUnformattedStringValue(Row row, boolean bl) {
        double d = row.data[this.index];
        if (Double.isNaN(d)) {
            return null;
        }
        if (this.categories != null) {
            int n = (int)Math.round(d);
            if (bl) {
                return this.categories[n];
            }
            String string = n + "";
            return string;
        }
        return BasicFactory.unformattedNumber(d);
    }

    public String getFormattedValue(Number number) {
        int n = (int)Math.round(number.doubleValue());
        return this.getFormattedStringValue(this.getRowValue(n), n, null);
    }

    public double getRowValue(int n) {
        Row row = this.data.rows[n];
        return row.data[this.index];
    }

    public String getFormattedStringValue(double d, int n, FormatSpec formatSpec) {
        if (this.categories == null) {
            if (Unit.isTime(this.unit)) {
                Object object = null;
                if (!Double.isNaN(d)) {
                    object = DateUtil.INSTANCE.toDate(d, this.unit, this.timeZone);
                }
                if (formatSpec != null) {
                    return this.data.visContext.formatContext.formatDate(object, RAVEFormatter.makeFromSpec(formatSpec, this.data.visContext.getLocale()), n, this.id, this.unit, this.timeZone);
                }
                return this.data.visContext.formatContext.formatDate(object, this.specifiedFormatter, n, this.id, this.unit, this.timeZone);
            }
            if (formatSpec != null) {
                return this.data.visContext.formatContext.formatNumber(d, RAVEFormatter.makeFromSpec(formatSpec, this.data.visContext.getLocale()), n, this.id, this.range, this.unit);
            }
            return this.data.visContext.formatContext.formatNumber(d, this.specifiedFormatter, n, this.id, this.range, this.unit);
        }
        String string = null;
        if (!Double.isNaN(d)) {
            int n2 = (int)Math.round(d);
            string = this.categories[n2];
        }
        if (formatSpec != null) {
            return this.data.visContext.formatContext.formatString(string, RAVEFormatter.makeFromSpec(formatSpec, this.data.visContext.getLocale()), n, this.id);
        }
        return this.data.visContext.formatContext.formatString(string, this.specifiedFormatter, n, this.id);
    }

    public FormatInfo getFormatInfo(Number number, int n, FormatSpec formatSpec) {
        FormatInfo formatInfo = new FormatInfo();
        if (this.categories == null) {
            formatInfo.setDataValue(number);
            formatInfo.setSpecifiedFormatter(this.specifiedFormatter);
            if (formatSpec != null) {
                formatInfo.setSpecifiedFormatter(RAVEFormatter.makeFromSpec(formatSpec, null));
            }
            formatInfo.setRowIx(n);
            formatInfo.setId(this.id);
            formatInfo.setRange(this.range);
            formatInfo.setUnit(this.unit);
            formatInfo.setNumeric(true);
        } else {
            int n2;
            String string = null;
            if (!Double.isNaN(number.doubleValue()) && (n2 = (int)Math.round(number.doubleValue())) < this.categories.length) {
                string = this.categories[n2];
            }
            formatInfo.setDataValue(string);
            formatInfo.setSpecifiedFormatter(this.specifiedFormatter);
            formatInfo.setRowIx(n);
            formatInfo.setId(this.id);
        }
        return formatInfo;
    }

    public boolean isCategorical() {
        return this.unit.measure.categorical;
    }

    public int getNearestMatchingRowIndex(double d) {
        int n = -1;
        double d2 = Double.MAX_VALUE;
        int n2 = this.data.rows.length;
        for (int i = 0; i < n2; ++i) {
            double d3 = this.data.rows[i].data[this.index];
            double d4 = Math.abs(d3 - d);
            if (d4 == 0.0) {
                return i;
            }
            if (!(d4 < d2)) continue;
            d2 = d4;
            n = i;
        }
        return n;
    }

    public Range getDataRange() {
        Range range = Range.EMPTY;
        for (Row row : this.data.rows) {
            double d = row.data[this.index];
            range = range.unionValue(d);
        }
        return range;
    }

    public Double getMinimalDataDiff() {
        if (this.data == null || this.data.rows == null) {
            return null;
        }
        double d = this.getDataRange().range;
        for (int i = 0; i < this.data.rows.length; ++i) {
            double d2 = this.data.rows[i].data[this.index];
            if (Double.isNaN(d2)) continue;
            for (int j = i + 1; j < this.data.rows.length; ++j) {
                double d3 = this.data.rows[j].data[this.index];
                if (Double.isNaN(d3) || d3 == d2) continue;
                d = Math.min(d, Math.abs(d2 - d3));
            }
        }
        return d;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDataIndex() {
        return this.data == null ? -1 : this.data.getIndex();
    }

    public RAVEFormatter getSpecifiedFormatter() {
        return this.specifiedFormatter;
    }

    public void setLocalFormatter(RAVEFormatter rAVEFormatter, LocalFormatterType localFormatterType) {
        this.localFormatter = rAVEFormatter;
        this.localFormatterType = localFormatterType;
    }

    public RAVEFormatter getLocalFormatter() {
        return this.localFormatter;
    }

    public LocalFormatterType getLocalFormatterType() {
        return this.localFormatterType;
    }

    public static enum LocalFormatterType {
        POSITION,
        AESTHETICS,
        COMPONENT;

    }
}

