/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.data.FieldDescriptor;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;

public class FieldDescriptorImpl
implements FieldDescriptor {
    private final Field field;
    private final double min;
    private final double max;
    private final String[] categories;

    public FieldDescriptorImpl(Field field) {
        this.field = field;
        if (field.categories == null) {
            this.min = field.range.getMin();
            this.max = field.range.getMax();
            this.categories = null;
        } else {
            int n = field.categories.length;
            this.min = 0.0;
            this.max = n - 1;
            this.categories = new String[n];
            for (int i = 0; i < n; ++i) {
                this.categories[i] = field.categories[i];
            }
        }
    }

    @Override
    public int getIndex() {
        return this.field.getIndex();
    }

    @Override
    public int getDataIndex() {
        return this.field.getDataIndex();
    }

    @Override
    public String getId() {
        return this.field.id;
    }

    @Override
    public String getLabel() {
        return this.field.label;
    }

    @Override
    public String getUnit() {
        return this.field.unit.name;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public String[] getCategories() {
        return this.categories;
    }

    @Override
    public String getSourceField() {
        return this.field.getSourceField();
    }

    @Override
    public String getSourceOperation() {
        return this.field.getSourceOperation();
    }

    @Override
    public JSONObject makeJSONSpec() {
        return FieldDescriptorImpl.makeJSONSpecForField(this.field);
    }

    static JSONObject makeJSONSpecForField(Field field) {
        JSONObject jSONObject = field.spec.toJSON();
        if (field.categories != null) {
            int n = field.categories.length;
            JSONArray jSONArray = BasicFactory.createSizedJSONArray(n);
            for (int i = 0; i < n; ++i) {
                BasicFactory.addAt(jSONArray, field.categories[i], i);
            }
            BasicFactory.put(jSONObject, "categories", jSONArray);
        }
        BasicFactory.put(jSONObject, "unit", field.unit.name);
        return jSONObject;
    }
}

