/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Range {
    protected double min;
    protected double delta = -1.0;
    protected int precision = -1;
    protected double max;
    protected double range;
    public static final Range EMPTY = new Range(Double.NaN, Double.NaN);
    public static final Range ZERO_ONE = new Range(0.0, 1.0);
    public static final Range ZERO = new Range(0.0, 0.0);

    public Range(double d, double d2) {
        if (d > d2) {
            this.min = d2;
            this.max = d;
        } else {
            this.min = d;
            this.max = d2;
        }
        this.range = this.max - this.min;
    }

    public double fromZeroOne(double d) {
        return this.min + this.range * d;
    }

    public double toZeroOne(double d) {
        if (this.range == 0.0) {
            return d == this.min ? 0.5 : -1.0;
        }
        return (d - this.min) / this.range;
    }

    public Range unionValue(double d) {
        if (d >= this.min && d <= this.max || d != d) {
            return this;
        }
        double d2 = this.min;
        double d3 = this.max;
        if (d2 != d2) {
            d2 = d;
        }
        if (d3 != d3) {
            d3 = d;
        }
        if (d2 > d3) {
            double d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        if (d < d2) {
            d2 = d;
        } else if (d > d3) {
            d3 = d;
        }
        return this.createTargetRange(d2, d3);
    }

    protected Range createTargetRange(double d, double d2) {
        return new Range(d, d2);
    }

    public boolean contains(double d) {
        return this.min <= d && this.max >= d;
    }

    public boolean containsTolerantly(double d, double d2) {
        assert (d2 >= 0.0);
        return d >= this.min - d2 && d <= this.max + d2;
    }

    public boolean isEmpty() {
        return Double.isNaN(this.min) && Double.isNaN(this.max);
    }

    public Range complete(Range range) {
        if (!this.isComplete()) {
            double d = Double.isNaN(this.min) ? range.min : this.min;
            double d2 = Double.isNaN(this.max) ? range.max : this.max;
            return new Range(d, d2);
        }
        return this;
    }

    public boolean isComplete() {
        return !Double.isNaN(this.range);
    }

    public double clamp(double d) {
        if (d > this.max) {
            return this.max;
        }
        if (d < this.min) {
            return this.min;
        }
        return d;
    }

    public Range expandedBy(double d, double d2) {
        return new Range(this.min - d, this.max + d2);
    }

    public Range expand(double d) {
        assert (this.isComplete());
        if (Double.isNaN(d) || d == 0.0) {
            return this;
        }
        if (d < 0.0 && this.range <= -2.0 * d) {
            double d2 = this.min + this.range / 2.0;
            return new Range(d2, d2);
        }
        return this.expandedBy(d, d);
    }

    public double mid() {
        return (this.min + this.max) / 2.0;
    }

    public int getFormattingPrecision() {
        double d;
        double d2 = 0.0;
        double d3 = d = this.max > 100000.0 || Math.abs(this.max) < 1.0E-5 ? this.range / this.max : this.range;
        if (d > 0.0 && d < 1.0) {
            d2 = 0.0 - Math.floor(Math.log(d) / Math.log(10.0)) + 2.0;
        }
        return (int)Math.round(d2);
    }

    public boolean containsRange(Range range) {
        return this.contains(range.min) && this.contains(range.max);
    }

    public boolean overlaps(Range range) {
        return this.max > range.min && this.min < range.max;
    }

    public double getOverlap(Range range) {
        if (!this.overlaps(range)) {
            return 0.0;
        }
        double d = Math.max(this.min, range.min);
        double d2 = Math.min(this.max, range.max);
        return d2 - d;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + ']';
    }

    public int hashCode() {
        return (int)Math.round(this.min) + (int)Math.round(this.max);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            Range range = (Range)object;
            if (this.isEmpty() && range.isEmpty()) {
                return true;
            }
            if (this.max != range.max) {
                return false;
            }
            if (this.min != range.min) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Range createUnion(Range range) {
        double d = Double.isNaN(range.min) ? this.min : (Double.isNaN(this.min) ? range.min : Math.min(range.min, this.min));
        double d2 = Double.isNaN(range.max) ? this.max : (Double.isNaN(this.max) ? range.max : Math.max(range.max, this.max));
        return new Range(d, d2);
    }

    public Range intersect(Range range) {
        double d = range.min;
        double d2 = range.max;
        if (range.contains(this.min)) {
            d = this.min;
        }
        if (range.contains(this.max)) {
            d2 = this.max;
        }
        return new Range(d, d2);
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getRange() {
        return this.range;
    }

    public double getDelta() {
        return this.delta;
    }

    public void calculateDeltaAndPrecision(double d) {
        if (Double.isNaN(this.max)) {
            this.delta = -1.0;
        }
        double d2 = 0.0;
        int n = 0;
        double d3 = this.range / d;
        while (d3 - Math.floor(d3) != 0.0) {
            d3 *= 10.0;
            d2 = ++n;
        }
        this.precision = (int)Math.round(d2);
        this.delta = d;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setMin(double d) {
        this.min = d;
        this.range = this.max - d;
    }

    public void setMax(double d) {
        this.max = d;
        this.range = d - this.min;
    }

    public Range remap(Range range) {
        if (range == null || range == ZERO_ONE) {
            return this.copy();
        }
        double d = this.range * range.range;
        double d2 = range.min + d * this.min / this.range;
        return new Range(d2, d2 + d);
    }

    public Range copy() {
        return new Range(this.min, this.max);
    }

    public static Range makeInverse(double d, double d2) {
        double d3 = d2 - d;
        double d4 = 1.0 / d3;
        double d5 = -d / d3;
        return new Range(d5, d5 + d4);
    }

    public static Range makeTransposeInverse(double d, double d2) {
        double d3 = 1.0 - d;
        double d4 = 1.0 - d2;
        double d5 = d3 - d4;
        double d6 = 1.0 / d5;
        double d7 = -d4 / d5;
        double d8 = d7 + d6;
        return new Range(d7, d8);
    }
}

