/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Row {
    public final int index;
    public final double[] data;
    private int singleOriginalRow;
    private IntPrimitiveArrayList originalRows;
    private int originalRowLength;
    private int primaryRow;

    private Row(double[] dArray, int n) {
        this.data = dArray;
        this.index = n;
        this.singleOriginalRow = -1;
        this.originalRows = null;
        this.originalRowLength = -1;
        this.primaryRow = -1;
    }

    public static Row createRow(double[] dArray, int n) {
        assert (dArray != null);
        return new Row(dArray, n);
    }

    public static Row createEmptyRow(int n, int n2) {
        assert (n >= 0);
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.NaN;
        }
        return Row.createRow(dArray, n2);
    }

    public void shareOriginalRows(Row row) {
        this.singleOriginalRow = -1;
        this.originalRows = null;
        this.originalRowLength = -1;
        if (row.singleOriginalRow != -1) {
            this.singleOriginalRow = row.singleOriginalRow;
        } else if (row.originalRows != null) {
            this.originalRows = row.originalRows;
            this.originalRowLength = row.originalRowLength;
        }
        this.primaryRow = row.primaryRow;
    }

    public final void setSingleOriginalRow(int n) {
        this.singleOriginalRow = n < 0 ? -1 : n;
        this.originalRows = null;
    }

    public final void setOriginalRows(IntPrimitiveArrayList intPrimitiveArrayList) {
        this.singleOriginalRow = -1;
        if (intPrimitiveArrayList == null || intPrimitiveArrayList.size() == 0) {
            this.originalRows = null;
            this.originalRowLength = -1;
        } else {
            this.originalRows = intPrimitiveArrayList;
            this.originalRowLength = intPrimitiveArrayList.size();
        }
    }

    public final void addOriginalRows(IntPrimitiveArrayList intPrimitiveArrayList, boolean bl) {
        if (this.singleOriginalRow >= 0) {
            if (!bl || !intPrimitiveArrayList.contains(this.singleOriginalRow)) {
                intPrimitiveArrayList.add(this.singleOriginalRow);
            }
        } else if (this.originalRows != null) {
            for (int i = 0; i < this.originalRowLength; ++i) {
                int n = this.originalRows.get(i);
                if (bl && intPrimitiveArrayList.contains(n)) continue;
                intPrimitiveArrayList.add(n);
            }
        }
    }

    public final void setPrimaryRow(int n) {
        this.primaryRow = n < 0 ? -1 : n;
    }

    public final int getPrimaryRow() {
        return this.primaryRow;
    }
}

