/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.geo;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.geo.GeoMatcher;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.resource.ResourceService;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeNearShape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeoData {
    public static final double DEFAULT_THIN = 0.001;
    public static double[] dateLineLeftX = new double[]{-360.0, -180.0, -180.0, -169.0, -169.0, -180.0, -190.0, -180.0, -180.0, -159.65, -159.65, -161.85, -161.85, -155.95, -150.65, -150.65, -156.05, -156.05, -178.05, -172.75, -172.75, -180.0, -180.0, -360.0};
    public static double[] dateLineSharedY = new double[]{90.0, 90.0, 75.0, 68.0, 65.0, 60.0, 53.0, 48.0, -0.9, -0.9, 2.9, 2.9, 5.0, 5.0, -7.8, -10.0, -10.0, -7.8, -7.8, 15.0, -45.0, -51.182, -90.0, -90.0};
    private static final Poly leftOfDateLine;
    private static final Poly rightOfDateLine;
    final ArrayList<String> types;
    final ArrayList<JSONArray> coords;
    final ArrayList<JSONObject> properties;
    final Map<String, Map<String, Number>> catPropertyMap;
    Double absTol;
    private final double thinTolerance;
    private final int transformMethod;
    private static final int TRANSFORMMETHOD_NONE = 0;
    private static final int TRANSFORMMETHOD_DATELINE = 1;
    private final VisContext context;
    private final double[] globalBounds;
    private boolean includeInRange;
    private boolean shiftedLeft = false;
    private boolean shifedRight = false;
    private int[] indices_left = null;
    private int[] indices_right = null;
    private int count_left = 0;
    private int count_right = 0;

    public static final GeoData read(Number number, String string, Boolean bl, GeoMatcher geoMatcher, VisContext visContext) {
        double d = number.doubleValue();
        GeoData geoData = new GeoData(d, string, bl, visContext);
        int n = 0;
        for (int i = 0; i < geoMatcher.totalRowCount(); ++i) {
            JSONObject[] jSONObjectArray = geoMatcher.getFeatures(i);
            if (jSONObjectArray == null || jSONObjectArray.length == 0) {
                geoData.addMissingFeature();
                continue;
            }
            if (jSONObjectArray.length > 1 && visContext.getLogger().hasListeners()) {
                visContext.getLogger().warning(LogComponent.CommonGrammar, "Data row " + i + " with key '" + geoMatcher.getFeatureKey(i) + "' has multiple matches, using the first match to show the data");
            }
            Object object = BasicFactory.getItem(jSONObjectArray[0], "geometry");
            geoData.addFeature((String)BasicFactory.getItem(object, "type"), (JSONArray)BasicFactory.getItem(object, "coordinates"), (JSONObject)BasicFactory.getItem(jSONObjectArray[0], "properties"));
            ++n;
        }
        if (visContext.getLogger().hasListeners()) {
            visContext.getLogger().info(LogComponent.CommonGrammar, "Found features for " + n + " data rows");
        }
        return geoData;
    }

    public static JSONArray readFeatures(Object object, VisContext visContext, VisJSONSpec visJSONSpec) {
        JSONObject jSONObject = null;
        jSONObject = BasicFactory.isString(object) ? (JSONObject)ResourceService.getInstance().getResourceForAugmentedGeoData((String)object) : (JSONObject)ResourceService.getInstance().getResource((MappedJSONObject)object, visJSONSpec);
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, "features");
        if (jSONArray == null) {
            if (visContext.getLogger().hasListeners()) {
                visContext.getLogger().error(LogComponent.CommonGrammar, "No features in GeoJSON file");
            }
            throw new EngineException("No features found in GeoJSON file.", ErrorCode.ENGINE_EMPTY_GEO_JSON, null);
        }
        return jSONArray;
    }

    public final int size() {
        return this.types.size();
    }

    private void fixDateLine(JSONArray jSONArray) {
        int n = BasicFactory.size(jSONArray);
        if (n == 0) {
            return;
        }
        Object object = BasicFactory.getArrayItem(jSONArray, 0);
        if (BasicFactory.isNumber(object)) {
            if (n == 2) {
                double d = ((Number)BasicFactory.getArrayItem(jSONArray, 0)).doubleValue();
                double d2 = ((Number)BasicFactory.getArrayItem(jSONArray, 1)).doubleValue();
                double d3 = 0.0;
                if (rightOfDateLine.containsPt(d, d2)) {
                    if (!this.shiftedLeft) {
                        d3 = -360.0;
                        this.shifedRight = true;
                    }
                } else if (leftOfDateLine.containsPt(d, d2) && !this.shifedRight) {
                    d3 = 360.0;
                    this.shiftedLeft = true;
                }
                if (d3 != 0.0) {
                    BasicFactory.setAt(jSONArray, d + d3, 0);
                }
            }
            return;
        }
        if (BasicFactory.size((JSONArray)object) == 2 && BasicFactory.isNumber(BasicFactory.getArrayItem((JSONArray)object, 0))) {
            double d;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                JSONArray jSONArray2 = (JSONArray)BasicFactory.getArrayItem(jSONArray, i);
                double d4 = ((Number)BasicFactory.getArrayItem(jSONArray2, 0)).doubleValue();
                if (rightOfDateLine.containsPt(d4, d = ((Number)BasicFactory.getArrayItem(jSONArray2, 1)).doubleValue())) {
                    ++n3;
                    continue;
                }
                if (leftOfDateLine.containsPt(d4, d)) {
                    ++n2;
                    continue;
                }
                ++n4;
            }
            double d5 = 0.0;
            if (n3 > n2 && n3 > n4) {
                if (!this.shiftedLeft) {
                    d5 = -360.0;
                    this.shifedRight = true;
                }
            } else if (n2 > n4 && !this.shifedRight) {
                d5 = 360.0;
                this.shiftedLeft = true;
            }
            if (d5 != 0.0) {
                for (int i = 0; i < n; ++i) {
                    JSONArray jSONArray3 = (JSONArray)BasicFactory.getArrayItem(jSONArray, i);
                    d = ((Number)BasicFactory.getArrayItem(jSONArray3, 0)).doubleValue() + d5;
                    BasicFactory.setAt(jSONArray3, d, 0);
                }
            }
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.fixDateLine((JSONArray)BasicFactory.getArrayItem(jSONArray, i));
        }
    }

    private void addFeature(String string, JSONArray jSONArray, JSONObject jSONObject) {
        if (this.transformMethod == 1) {
            this.fixDateLine(jSONArray);
        }
        this.types.add(string);
        this.coords.add(jSONArray);
        this.properties.add(jSONObject);
        this.increaseBounds(this.globalBounds, jSONArray);
    }

    private void addMissingFeature() {
        this.types.add(null);
        this.coords.add(null);
        this.properties.add(null);
    }

    private GeoData(double d, String string, Boolean bl, VisContext visContext) {
        this.context = visContext;
        this.thinTolerance = d;
        this.includeInRange = bl;
        int n = 1;
        if (string != null) {
            if (string.equals("none")) {
                n = 0;
            } else if (string.equals("dateline")) {
                n = 1;
            }
        }
        this.transformMethod = n;
        this.globalBounds = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        this.coords = new ArrayList();
        this.types = new ArrayList();
        this.properties = new ArrayList();
        this.catPropertyMap = new HashMap<String, Map<String, Number>>();
    }

    public Point featureCenter(int n) {
        Rect rect = this.interiorBounds(n);
        return rect == null ? null : rect.getCenter();
    }

    public PolyShape[] featurePolygons(int n) {
        if (this.absTol == null) {
            this.absTol = Math.min(this.globalBounds[1] - this.globalBounds[0], this.globalBounds[3] - this.globalBounds[2]) * this.thinTolerance;
        }
        String string = this.types.get(n);
        JSONArray jSONArray = this.coords.get(n);
        if (jSONArray != null && this.context.getLogger().isTracing() && this.context.getLogger().hasListeners()) {
            this.context.getLogger().trace(LogComponent.CommonGrammar, "Feature " + n + " of type '" + string + "' contains " + BasicFactory.size(jSONArray) + " parts");
        }
        if (jSONArray == null) {
            return null;
        }
        if (string.equals("LineString")) {
            PolyShape[] polyShapeArray;
            PolyShape polyShape = this.makeSimplePolyShape(jSONArray, false);
            if (polyShape == null) {
                polyShapeArray = null;
            } else {
                PolyShape[] polyShapeArray2 = new PolyShape[1];
                polyShapeArray = polyShapeArray2;
                polyShapeArray2[0] = polyShape;
            }
            return polyShapeArray;
        }
        if (string.equals("MultiLineString")) {
            PolyShape[] polyShapeArray;
            PolyShape polyShape = this.combineMultiplePolysIntoOne(jSONArray, false);
            if (polyShape == null) {
                polyShapeArray = null;
            } else {
                PolyShape[] polyShapeArray3 = new PolyShape[1];
                polyShapeArray = polyShapeArray3;
                polyShapeArray3[0] = polyShape;
            }
            return polyShapeArray;
        }
        if (string.equals("Polygon")) {
            PolyShape[] polyShapeArray;
            PolyShape polyShape = this.combineMultiplePolysIntoOne(jSONArray, true);
            if (polyShape == null) {
                polyShapeArray = null;
            } else {
                PolyShape[] polyShapeArray4 = new PolyShape[1];
                polyShapeArray = polyShapeArray4;
                polyShapeArray4[0] = polyShape;
            }
            return polyShapeArray;
        }
        if (string.equals("MultiPolygon")) {
            int n2 = BasicFactory.size(jSONArray);
            ArrayList<PolyShape> arrayList = new ArrayList<PolyShape>();
            for (int i = 0; i < n2; ++i) {
                JSONArray jSONArray2 = (JSONArray)BasicFactory.getArrayItem(jSONArray, i);
                PolyShape polyShape = this.combineMultiplePolysIntoOne(jSONArray2, true);
                if (polyShape == null) continue;
                arrayList.add(polyShape);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            this.antimeridianMerge(arrayList);
            PolyShape[] polyShapeArray = new PolyShape[arrayList.size()];
            for (int i = 0; i < polyShapeArray.length; ++i) {
                polyShapeArray[i] = arrayList.get(i);
            }
            return polyShapeArray;
        }
        return null;
    }

    protected double getAbsoluteTolerance() {
        if (this.absTol == null) {
            this.absTol = Math.min(this.globalBounds[1] - this.globalBounds[0], this.globalBounds[3] - this.globalBounds[2]) * this.thinTolerance;
        }
        return this.absTol;
    }

    public ArrayList<Point> featurePoints(int n) {
        JSONArray jSONArray = this.coords.get(n);
        if (jSONArray == null) {
            return null;
        }
        String string = this.types.get(n);
        if (jSONArray != null && this.context.getLogger().isTracing() && this.context.getLogger().hasListeners()) {
            this.context.getLogger().trace(LogComponent.CommonGrammar, "Feature " + n + " of type '" + string + "' contains " + BasicFactory.size(jSONArray) + " parts");
        }
        if (string.equals("MultiPoint")) {
            return this.getPoints(jSONArray, false);
        }
        Point point = this.featureCenter(n);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(point);
        return arrayList;
    }

    final int getCountLeft() {
        return this.count_left;
    }

    final int getCountRight() {
        return this.count_right;
    }

    final int[] getIndicesLeft() {
        return this.indices_left;
    }

    final int[] getIndicesRight() {
        return this.indices_right;
    }

    protected void antimeridianMerge(ArrayList<PolyShape> arrayList) {
        int n;
        if (!this.createAntimeridianPolyList(arrayList)) {
            return;
        }
        block0: for (n = 0; n < this.count_left; ++n) {
            PolyShape polyShape = arrayList.get(this.indices_left[n]);
            Rect rect = polyShape.getBounds();
            for (int i = 0; i < this.count_right; ++i) {
                PolyShape polyShape2 = arrayList.get(this.indices_right[i]);
                if (polyShape2 == null) continue;
                Rect rect2 = polyShape2.getBounds();
                if (rect.getY() > rect2.getY2() || rect.getY2() < rect2.getY()) continue;
                PolyShape polyShape3 = this.mergePolys(polyShape, polyShape2);
                arrayList.set(this.indices_left[n], polyShape3);
                arrayList.set(this.indices_right[i], null);
                continue block0;
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) != null) continue;
            arrayList.remove(n);
        }
        this.indices_left = null;
        this.indices_right = null;
    }

    protected PolyShape mergePolys(PolyShape polyShape, PolyShape polyShape2) {
        int n;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < polyShape.getXArray().length && Math.abs(polyShape.getXArray()[n2] - 180.0) < 1.0E-6; ++n2) {
        }
        while (n2 < polyShape.getXArray().length && Math.abs(polyShape.getXArray()[n2] - 180.0) > 1.0E-6) {
            arrayList.add(new Point(polyShape.getXArray()[n2], polyShape.getYArray()[n2]));
            ++n2;
        }
        n4 = n2 - 1;
        if (n2 == polyShape.getXArray().length) {
            n2 = 0;
            n4 = 0;
        }
        while (n2 < polyShape.getXArray().length && Math.abs(polyShape.getXArray()[n2] - 180.0) < 1.0E-6) {
            ++n2;
        }
        n5 = n2;
        for (n3 = 0; n3 < polyShape2.getXArray().length && (Math.abs(polyShape2.getXArray()[n3] - 180.0) > 1.0E-6 || Math.abs(polyShape2.getYArray()[n3] - polyShape.getYArray()[n4]) > 1.0E-6); ++n3) {
        }
        n6 = n3 - 1;
        if (n3 == polyShape2.getXArray().length) {
            n3 = 0;
            n6 = 0;
        }
        while (n3 < polyShape2.getXArray().length && Math.abs(polyShape2.getXArray()[n3] - 180.0) > 1.0E-6) {
            arrayList.add(new Point(polyShape2.getXArray()[n3], polyShape2.getYArray()[n3]));
            ++n3;
        }
        for (n3 = 0; n3 < n6 && Math.abs(polyShape2.getXArray()[n3] - 180.0) > 1.0E-6; ++n3) {
            arrayList.add(new Point(polyShape2.getXArray()[n3], polyShape2.getYArray()[n3]));
        }
        if (n4 != 0) {
            for (n2 = n5; n2 < polyShape.getXArray().length && Math.abs(polyShape.getXArray()[n2] - 180.0) > 1.0E-6; ++n2) {
                arrayList.add(new Point(polyShape.getXArray()[n2], polyShape.getYArray()[n2]));
            }
        }
        if ((n = arrayList.size()) <= 2) {
            return null;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            Point point = (Point)arrayList.get(n2);
            dArray[n2] = point.getX();
            dArray2[n2] = point.getY();
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    protected boolean createAntimeridianPolyList(ArrayList<PolyShape> arrayList) {
        this.indices_left = new int[arrayList.size()];
        this.indices_right = new int[arrayList.size()];
        this.count_left = 0;
        this.count_right = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PolyShape polyShape = arrayList.get(i);
            Rect rect = polyShape.getBounds();
            if (Math.abs(rect.getX2() - 180.0) < 1.0E-6) {
                this.indices_left[this.count_left++] = i;
                continue;
            }
            if (!(Math.abs(rect.getX() - 180.0) < 1.0E-6)) continue;
            this.indices_right[this.count_right++] = i;
        }
        return this.count_left != 0 || this.count_right != 0;
    }

    private PolyShape combineMultiplePolysIntoOne(JSONArray jSONArray, boolean bl) {
        Object object2;
        int n;
        ArrayList<PolyShape> arrayList = new ArrayList<PolyShape>();
        int n2 = BasicFactory.size(jSONArray);
        for (n = 0; n < n2; ++n) {
            object2 = (JSONArray)BasicFactory.getArrayItem(jSONArray, n);
            PolyShape object3 = this.makeSimplePolyShape((JSONArray)object2, bl);
            if (n2 == 1) {
                return object3;
            }
            if (object3 == null) continue;
            arrayList.add(object3);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        n = bl ? arrayList.size() : 0;
        for (PolyShape polyShape : arrayList) {
            n += polyShape.length();
        }
        object2 = new double[n];
        double[] dArray = new double[n];
        char[] cArray = new char[n];
        int n3 = 0;
        for (PolyShape polyShape : arrayList) {
            int n4 = 0;
            while (n4 < polyShape.length()) {
                object2[n3] = (JSONArray)polyShape.getXArray()[n4];
                dArray[n3] = polyShape.getYArray()[n4];
                cArray[n3] = n4 == 0 ? 77 : 76;
                ++n4;
                ++n3;
            }
            if (!bl) continue;
            object2[n3] = object2[0];
            dArray[n3] = dArray[0];
            cArray[n3++] = 90;
        }
        return new Path((double[])object2, dArray, bl, cArray);
    }

    protected ArrayList<Point> getPoints(JSONArray jSONArray, boolean bl) {
        int n = BasicFactory.size(jSONArray);
        if (bl) {
            --n;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point point = new Point(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < n; ++i) {
            JSONArray jSONArray2 = (JSONArray)BasicFactory.getArrayItem(jSONArray, i);
            Point point2 = new Point(((Number)BasicFactory.getArrayItem(jSONArray2, 0)).doubleValue(), ((Number)BasicFactory.getArrayItem(jSONArray2, 1)).doubleValue());
            if (!(point2.distance(point) > this.getAbsoluteTolerance())) continue;
            arrayList.add(point2);
            point = point2;
        }
        return arrayList;
    }

    private PolyShape makeSimplePolyShape(JSONArray jSONArray, boolean bl) {
        ArrayList<Point> arrayList = this.getPoints(jSONArray, bl);
        int n = arrayList.size();
        if (n < 2 || n == 2 && bl) {
            return null;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            Point point = arrayList.get(i);
            dArray[i] = point.getX();
            dArray2[i] = point.getY();
        }
        return new ShapePoly(dArray, dArray2, bl, null);
    }

    public Rect featureBounds(int n, boolean bl) {
        return bl ? this.interiorBounds(n) : this.exteriorBounds(n);
    }

    private Rect interiorBounds(int n) {
        PolyShape polyShape = null;
        PolyShape[] polyShapeArray = this.featurePolygons(n);
        if (polyShapeArray != null) {
            double d = 0.0;
            for (PolyShape polyShape2 : polyShapeArray) {
                double d2 = polyShape2.area();
                if (!(d2 > d)) continue;
                polyShape = polyShape2;
                d = d2;
            }
        }
        if (polyShape == null) {
            return this.exteriorBounds(n);
        }
        Shape shape = ShapeNearShape.makeShapeInsidePoly(polyShape, false);
        return shape.getBounds();
    }

    private Rect exteriorBounds(int n) {
        JSONArray jSONArray = this.coords.get(n);
        if (jSONArray == null) {
            return null;
        }
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        this.increaseBounds(dArray, jSONArray);
        return new Rect(dArray[0], dArray[2], dArray[1] - dArray[0], dArray[3] - dArray[2]);
    }

    private void increaseBounds(double[] dArray, JSONArray jSONArray) {
        if (jSONArray == null) {
            return;
        }
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            Object object = BasicFactory.getArrayItem(jSONArray, i);
            if (BasicFactory.isNumber(object)) {
                assert (n == 2);
                double d = ((Number)object).doubleValue();
                if (i == 0) {
                    dArray[0] = Math.min(dArray[0], d);
                    dArray[1] = Math.max(dArray[1], d);
                    continue;
                }
                dArray[2] = Math.min(dArray[2], d);
                dArray[3] = Math.max(dArray[3], d);
                continue;
            }
            this.increaseBounds(dArray, (JSONArray)object);
        }
    }

    public Rect getGlobalBounds() {
        return new Rect(this.globalBounds[0], this.globalBounds[2], this.globalBounds[1] - this.globalBounds[0], this.globalBounds[3] - this.globalBounds[2]);
    }

    public Object getProperty(int n, String string) {
        JSONObject jSONObject = this.properties.get(n);
        return jSONObject == null ? null : BasicFactory.getItem(jSONObject, string);
    }

    public String[] propertyCategories(String string) {
        Object object;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        for (JSONObject jSONObject : this.properties) {
            if (jSONObject == null || (object = BasicFactory.getItem(jSONObject, string)) == null) continue;
            bl = true;
            if (!BasicFactory.isString(object)) continue;
            hashMap.put((String)object, object);
        }
        if (!bl) {
            if (this.context.getLogger().hasListeners()) {
                this.context.getLogger().log(LogLevel.Error, LogComponent.CommonGrammar, "Could not find property in Geo Data", "property", string);
            }
            throw new EngineException("Geo augment failed to find property for key \"" + string + "\".", ErrorCode.ENGINE_UNMATCHED_PROPERTY_IN_GEO_AUGMENT, null);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[hashMap.size()];
        int n = 0;
        for (String string2 : hashMap.keySet()) {
            objectArray[n++] = string2;
        }
        BasicFactory.sortArray(objectArray);
        object = new HashMap();
        for (int i = 0; i < objectArray.length; ++i) {
            object.put(objectArray[i], i);
        }
        this.catPropertyMap.put(string, (Map<String, Number>)object);
        return objectArray;
    }

    public Number getPropertyAsNumber(int n, String string) {
        Object object = this.getProperty(n, string);
        if (object == null) {
            return null;
        }
        if (BasicFactory.isNumber(object)) {
            return (Number)object;
        }
        Map<String, Number> map = this.catPropertyMap.get(string);
        if (map == null) {
            this.propertyCategories(string);
            map = this.catPropertyMap.get(string);
        }
        return map.get(object);
    }

    public boolean getIncludeInRange() {
        return this.includeInRange;
    }

    static {
        assert (dateLineLeftX.length == dateLineSharedY.length);
        int n = dateLineLeftX.length;
        double[] dArray = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            dArray[i] = dateLineLeftX[i] + 360.0;
        }
        dArray[0] = 360.0;
        dArray[n - 1] = 360.0;
        leftOfDateLine = new Poly(dateLineLeftX, dateLineSharedY, true);
        rightOfDateLine = new Poly(dArray, dateLineSharedY, true);
    }
}

