/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.geo;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.geo.GeoMatcher;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import java.util.ArrayList;
import java.util.HashMap;

public class GeoPropertiesMatcher
implements GeoMatcher {
    private final JSONObject[][] output;
    private final String[] dataKeys;
    private final String[] sourceKeys;
    private final int[] dataKeyIndices;
    private final boolean includeAllSource;
    private final VisContext context;
    private final double[][] rows;
    private final FieldSpec[] fields;

    public GeoPropertiesMatcher(DataSpec dataSpec, String[] stringArray, FieldRefSpec[] fieldRefSpecArray, boolean bl, JSONArray jSONArray, VisContext visContext) {
        this.sourceKeys = stringArray;
        this.includeAllSource = bl;
        this.context = visContext;
        this.rows = dataSpec.rows;
        this.fields = dataSpec.fields;
        this.dataKeyIndices = new int[fieldRefSpecArray.length];
        for (int i = 0; i < fieldRefSpecArray.length; ++i) {
            String string = fieldRefSpecArray[i].$ref;
            this.dataKeyIndices[i] = -1;
            for (int j = 0; j < dataSpec.fields.length; ++j) {
                if (!dataSpec.fields[j].id.equals(string)) continue;
                this.dataKeyIndices[i] = j;
            }
            if (this.dataKeyIndices[i] != -1) continue;
            if (visContext.getLogger().hasListeners()) {
                visContext.getLogger().error(LogComponent.CommonGrammar, "Could not find field for augmentation");
            }
            throw new EngineException("Augmentation requested a non-existent field.", ErrorCode.ENGINE_UNMATCHED_KEY_IN_GEO_AUGMENT, null);
        }
        this.dataKeys = new String[this.rows == null ? 0 : this.rows.length];
        ArrayList<IntPrimitiveArrayList> arrayList = this.makeMatches(jSONArray);
        this.output = new JSONObject[arrayList.size()][];
        for (int i = 0; i < this.output.length; ++i) {
            IntPrimitiveArrayList intPrimitiveArrayList = arrayList.get(i);
            if (intPrimitiveArrayList == null) continue;
            this.output[i] = new JSONObject[intPrimitiveArrayList.size()];
            for (int j = 0; j < intPrimitiveArrayList.size(); ++j) {
                this.output[i][j] = (JSONObject)BasicFactory.getArrayItem(jSONArray, intPrimitiveArrayList.get(j));
            }
        }
    }

    private ArrayList<IntPrimitiveArrayList> makeMatches(JSONArray jSONArray) {
        ArrayList<IntPrimitiveArrayList> arrayList = new ArrayList<IntPrimitiveArrayList>();
        int n = BasicFactory.size(jSONArray);
        boolean[] blArray = new boolean[n];
        if (this.context.getLogger().hasListeners()) {
            this.context.getLogger().log(LogLevel.Detail, LogComponent.CommonGrammar, "Read GeoJSON", "featureCount", n);
        }
        if (this.rows != null && this.rows.length > 0) {
            IntPrimitiveArrayList intPrimitiveArrayList;
            String string;
            int n2;
            HashMap<String, IntPrimitiveArrayList> hashMap = new HashMap<String, IntPrimitiveArrayList>(this.rows.length);
            for (n2 = 0; n2 < n; ++n2) {
                string = this.makeSourceKey(BasicFactory.getArrayItem(jSONArray, n2));
                if (string == null) continue;
                intPrimitiveArrayList = (IntPrimitiveArrayList)hashMap.get(string);
                if (intPrimitiveArrayList == null) {
                    intPrimitiveArrayList = new IntPrimitiveArrayList(1);
                    hashMap.put(string, intPrimitiveArrayList);
                }
                intPrimitiveArrayList.add(n2);
            }
            if (hashMap.size() == 0) {
                if (this.context.getLogger().hasListeners()) {
                    this.context.getLogger().error(LogComponent.CommonGrammar, "Could not find any matches for the source keys in the augmentation");
                }
                throw new EngineException("Failed to match property in GeoJSON.", ErrorCode.ENGINE_UNMATCHED_PROPERTY_IN_GEO_AUGMENT, null);
            }
            for (n2 = 0; n2 < this.rows.length; ++n2) {
                this.dataKeys[n2] = string = this.makeDataKey(this.rows[n2]);
                intPrimitiveArrayList = (IntPrimitiveArrayList)hashMap.get(string);
                if (intPrimitiveArrayList != null && this.includeAllSource) {
                    for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                        blArray[intPrimitiveArrayList.get((int)i)] = true;
                    }
                }
                arrayList.add(intPrimitiveArrayList);
            }
        }
        if (this.includeAllSource) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList(1);
                intPrimitiveArrayList.add(i);
                arrayList.add(intPrimitiveArrayList);
            }
        }
        return arrayList;
    }

    private String makeDataKey(double[] dArray) {
        String string = null;
        for (int n : this.dataKeyIndices) {
            double d = dArray[n];
            if (Double.isNaN(d)) {
                return null;
            }
            String[] stringArray = this.fields[n].categories;
            String string2 = stringArray == null ? BasicFactory.unformattedNumber(d) : stringArray[(int)d].toLowerCase();
            string = string == null ? string2 : string + "|" + string2;
        }
        return string;
    }

    private String makeSourceKey(Object object) {
        JSONObject jSONObject = (JSONObject)BasicFactory.getItem(object, "properties");
        String string = null;
        for (String string2 : this.sourceKeys) {
            Object object2 = BasicFactory.getItem(jSONObject, string2);
            if (object2 == null) {
                return null;
            }
            String string3 = BasicFactory.isNumber(object2) ? BasicFactory.unformattedNumber((Number)object2) : ((String)object2).toLowerCase();
            string = string == null ? string3 : string + "|" + string3;
        }
        return string;
    }

    @Override
    public int totalRowCount() {
        return this.output.length;
    }

    @Override
    public JSONObject[] getFeatures(int n) {
        return this.output[n];
    }

    @Override
    public String getFeatureKey(int n) {
        return n < this.dataKeys.length ? this.dataKeys[n] : null;
    }
}

