/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractSummaryOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.StatisticalSummaryData;
import com.ibm.vis.engine.internal.data.transform.Summary;
import com.ibm.vis.engine.internal.data.transform.WeightedValue;
import com.ibm.vis.engine.internal.data.transform.WeightedValueComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStatisticsOperation
extends AbstractSummaryOperation {
    public static final String PRECALCULATION_KEY = "STATISTICAL_OPERATION";

    @Override
    protected String getOperationFamily() {
        return PRECALCULATION_KEY;
    }

    @Override
    protected Object precomputeData(Summary summary, DerivedField derivedField, Group group, Row[] rowArray) {
        return AbstractStatisticsOperation.calculateDataDetails(summary, derivedField, group.getRows(), rowArray);
    }

    @Override
    protected Number doCompute(Summary summary, DerivedField derivedField, Group group, Row[] rowArray, Object object) {
        StatisticalSummaryData statisticalSummaryData = (StatisticalSummaryData)object;
        if (statisticalSummaryData.getTotalWeight() > 0.0) {
            return this.doCalculations(statisticalSummaryData, derivedField, group.getRows(), rowArray);
        }
        return null;
    }

    protected abstract Number doCalculations(StatisticalSummaryData var1, DerivedField var2, IntPrimitiveArrayList var3, Row[] var4);

    public static StatisticalSummaryData calculateDataDetails(Summary summary, DerivedField derivedField, IntPrimitiveArrayList intPrimitiveArrayList, Row[] rowArray) {
        ArrayList<WeightedValue> arrayList = new ArrayList<WeightedValue>(intPrimitiveArrayList.size());
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            int n = intPrimitiveArrayList.get(i);
            double d3 = summary.getWeight(rowArray[n]);
            double d4 = rowArray[n].data[derivedField.inputIndex];
            if (!(d3 > 0.0) || Double.isNaN(d4)) continue;
            d2 = Math.min(d3, d2);
            d += d3;
            arrayList.add(new WeightedValue(d4, d3, 0.0));
        }
        StatisticalSummaryData statisticalSummaryData = new StatisticalSummaryData(arrayList, d);
        if (d > 0.0) {
            BasicFactory.sortList(arrayList, new WeightedValueComparator());
            AbstractStatisticsOperation.computeCumulativeWeights(statisticalSummaryData, arrayList, d2);
        }
        return statisticalSummaryData;
    }

    private static void computeCumulativeWeights(StatisticalSummaryData statisticalSummaryData, List<WeightedValue> list, double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        if (d < 1.0) {
            d3 = 1.0 / d;
        }
        statisticalSummaryData.setTotalWeight(statisticalSummaryData.getTotalWeight() * d3);
        for (WeightedValue weightedValue : list) {
            weightedValue.setCumulative_weight(d2 += weightedValue.getWeight() * d3);
        }
    }

    protected static double interpolatePercentileValue(StatisticalSummaryData statisticalSummaryData, float f) {
        float f2 = Math.min(100.0f, Math.max(0.0f, f));
        float f3 = f2 / 100.0f * ((float)statisticalSummaryData.getTotalWeight() + 1.0f);
        int n = AbstractStatisticsOperation.computeCumulativeWeightIndex(statisticalSummaryData, f3);
        if (AbstractStatisticsOperation.getCumulativeWeight(statisticalSummaryData, n) >= (double)f3 || n == statisticalSummaryData.getWeightedValues().size() - 1) {
            return AbstractStatisticsOperation.getValue(statisticalSummaryData, n);
        }
        double d = (double)f3 - AbstractStatisticsOperation.getCumulativeWeight(statisticalSummaryData, n);
        if (d >= 1.0) {
            return AbstractStatisticsOperation.getValue(statisticalSummaryData, n + 1);
        }
        return AbstractStatisticsOperation.getValue(statisticalSummaryData, n) + d * (AbstractStatisticsOperation.getValue(statisticalSummaryData, n + 1) - AbstractStatisticsOperation.getValue(statisticalSummaryData, n));
    }

    protected static int computeCumulativeWeightIndex(StatisticalSummaryData statisticalSummaryData, float f) {
        int n = 0;
        int n2 = statisticalSummaryData.getWeightedValues().size();
        while (n < n2 - 1) {
            int n3 = (int)Math.floor((n + n2) / 2);
            if (statisticalSummaryData.getWeightedValues().get(n3).getCumulative_weight() == (double)f) {
                n = n3;
                break;
            }
            if (statisticalSummaryData.getWeightedValues().get(n3).getCumulative_weight() < (double)f) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n;
    }

    static double getValue(StatisticalSummaryData statisticalSummaryData, int n) {
        int n2 = Math.min(Math.max(n, 0), statisticalSummaryData.getWeightedValues().size() - 1);
        return statisticalSummaryData.getWeightedValues().get(n2).getValue();
    }

    protected static double getCumulativeWeight(StatisticalSummaryData statisticalSummaryData, int n) {
        int n2 = Math.min(Math.max(n, 0), statisticalSummaryData.getWeightedValues().size() - 1);
        return statisticalSummaryData.getWeightedValues().get(n2).getCumulative_weight();
    }

    protected int computeValueIndex(StatisticalSummaryData statisticalSummaryData, double d) {
        int n = 0;
        int n2 = statisticalSummaryData.getWeightedValues().size();
        while (n < n2 - 1) {
            int n3 = (int)Math.floor((n + n2) / 2);
            if (statisticalSummaryData.getWeightedValues().get(n3).getValue() == d) {
                n = n3;
                break;
            }
            if (statisticalSummaryData.getWeightedValues().get(n3).getValue() < d) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return n;
    }
}

