/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractAggregateOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class BasicAggregateOperation
extends AbstractAggregateOperation {
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String MEAN = "mean";
    public static final String SUM = "sum";
    private final String func;

    public BasicAggregateOperation(String string) {
        this.func = string;
    }

    @Override
    protected Double getInitialAggregateValue(DerivedField derivedField) {
        if (SUM.equals(this.func) || MEAN.equals(this.func)) {
            return 0.0;
        }
        if (MIN.equals(this.func)) {
            return Double.POSITIVE_INFINITY;
        }
        if (MAX.equals(this.func)) {
            return Double.NEGATIVE_INFINITY;
        }
        return null;
    }

    @Override
    protected Double doAggregate(double d, DerivedField derivedField, double d2, Double d3, double d4, int n, Object object) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (SUM.equals(this.func) || MEAN.equals(this.func)) {
            return d3 + d * d2;
        }
        if (MIN.equals(this.func)) {
            return Math.min(d3, d2);
        }
        if (MAX.equals(this.func)) {
            return Math.max(d3, d2);
        }
        throw new UnsupportedOperationException("Unsupported summary: " + this.func);
    }

    @Override
    protected Number computeFinalResult(Double d, double d2, int n, DerivedField derivedField, Row[] rowArray, Object object) {
        if (MEAN.equals(this.func)) {
            return d2 == 0.0 || d == null ? null : Double.valueOf(d / d2);
        }
        return d;
    }
}

