/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractAggregateOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Summary;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CountOperation
extends AbstractAggregateOperation {
    public static final String COUNT = "count";
    public static final String PERCENT_OF_COUNT = "percentOfCount";
    private final String func;

    public CountOperation(String string) {
        this.func = string;
    }

    @Override
    protected Object precomputeData(Summary summary, DerivedField derivedField, Group group, Row[] rowArray) {
        if (PERCENT_OF_COUNT.equals(this.func)) {
            double d = 0.0;
            for (Row row : rowArray) {
                double d2 = summary.getWeight(row);
                if (d2 <= 0.0) continue;
                d += d2;
            }
            return d;
        }
        return null;
    }

    @Override
    protected Double getInitialAggregateValue(DerivedField derivedField) {
        return 0.0;
    }

    @Override
    protected Double doAggregate(double d, DerivedField derivedField, double d2, Double d3, double d4, int n, Object object) {
        if (derivedField.inputIndex == -1 || !Double.isNaN(d2)) {
            return d3 + d;
        }
        return d3;
    }

    @Override
    protected Number computeFinalResult(Double d, double d2, int n, DerivedField derivedField, Row[] rowArray, Object object) {
        if (PERCENT_OF_COUNT.equals(this.func)) {
            return d * 100.0 / (Double)object;
        }
        return d;
    }
}

