/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.KernelSmoothType;
import com.ibm.vis.engine.internal.data.transform.SmoothType;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Density
extends Transform {
    private final int xI = this.getInputIndex("x");
    private final SmoothType type = new KernelSmoothType();
    private Range range;

    public Density(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl) {
        super(arrayList, arrayList2, loggerImpl);
        for (DerivedField derivedField : arrayList) {
            if (derivedField.inputIndex != this.xI) continue;
            this.range = derivedField.inputRange;
            if (this.range.getRange() < 1.0E-15) {
                this.range = this.range.expand(this.range.getMin() / 4.0);
            }
            if (!(this.range.getRange() < 1.0E-15)) continue;
            this.range = this.range.expand(1.0);
        }
    }

    @Override
    protected int getFixedOutputCount() {
        return 41;
    }

    @Override
    public boolean isPdf() {
        return true;
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        this.setOverallData(rowArray, this.type, this.xI);
        int[] nArray = this.sortAndRemoveMissing(rowArray, this.xI, -1, group.getRows(), true);
        double[] dArray = this.calculateMoments(rowArray, this.xI, nArray);
        if (dArray[0] < 1.0E-12) {
            return;
        }
        this.type.setGroupMoments(dArray[0], dArray[1], 0.0, dArray[2], 0.0, 0.0);
        this.type.setGroupData(rowArray, this.xI, -1, this.weightIndex, nArray);
        Range range = this.range.expand(this.type.getWindowWidth());
        for (Object object : this.outputs) {
            if (!"x".equals(((DerivedField)object).role)) continue;
            ((DerivedField)object).outputGranularity = range.getRange() / (double)this.getFixedOutputCount();
            ((DerivedField)object).outputRange = this.range;
        }
        Range range2 = this.getRange(rowArray, group.getRows(), this.xI, this.range);
        range = range2.expand(this.type.getWindowWidth());
        for (DerivedField derivedField : this.outputs) {
            int n3 = this.getFixedOutputCount();
            for (int i = 0; i < n3; ++i) {
                double d = range.fromZeroOne((double)i / (double)(n3 - 1));
                if ("x".equals(derivedField.role)) {
                    rowArray2[n + i].data[derivedField.outputIndex] = d;
                    continue;
                }
                if (!"y".equals(derivedField.role)) continue;
                rowArray2[n + i].data[derivedField.outputIndex] = this.type.getDensity(d, this.getMultiplier());
            }
        }
    }

    private double[] calculateMoments(Row[] rowArray, int n, int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int n2 : nArray) {
            double d3 = this.getWeight(rowArray[n2]);
            d += d3;
            Double d4 = rowArray[n2].data[n];
            d2 += d3 * d4;
        }
        double d5 = d2 / d;
        double d6 = 0.0;
        for (int n3 : nArray) {
            double d7 = this.getWeight(rowArray[n3]);
            Double d8 = rowArray[n3].data[n];
            double d9 = d8;
            d6 += d7 * (d9 - d5) * (d9 - d5);
        }
        return new double[]{d, d5, d6 / d};
    }
}

