/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.DerivedParameterSpec;
import com.ibm.vis.spec.internal.FieldSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DerivedField {
    public final String role;
    public final int inputIndex;
    public final int outputIndex;
    public final String[] categories;
    public final Range inputRange;
    public final DerivedParameterSpec parameters;
    public final FieldSpec derivedField;
    public Double outputGranularity;
    public Range outputRange;

    private DerivedField(String string, int n, int n2, Range range, String[] stringArray, DerivedParameterSpec derivedParameterSpec, FieldSpec fieldSpec) {
        this.role = string;
        this.inputIndex = n;
        this.outputIndex = n2;
        this.categories = stringArray;
        this.inputRange = range;
        this.parameters = DerivedField.copyParameters(derivedParameterSpec);
        this.derivedField = DerivedField.copyFieldSpec(fieldSpec);
    }

    public static DerivedField createInputField(String string, int n, Range range, String[] stringArray, DerivedParameterSpec derivedParameterSpec, FieldSpec fieldSpec) {
        return new DerivedField(string, n, -1, range, stringArray, derivedParameterSpec, fieldSpec);
    }

    public static DerivedField createOutputField(String string, int n, DerivedParameterSpec derivedParameterSpec, FieldSpec fieldSpec) {
        return new DerivedField(string, -1, n, null, null, derivedParameterSpec, fieldSpec);
    }

    public static DerivedField createThroughputField(String string, int n, int n2, Range range, String[] stringArray, DerivedParameterSpec derivedParameterSpec, FieldSpec fieldSpec) {
        return new DerivedField(string, n, n2, range, stringArray, derivedParameterSpec, fieldSpec);
    }

    public final String getOperation() {
        if (this.parameters != null && this.parameters.summaryFunction != null) {
            return this.parameters.summaryFunction;
        }
        return this.role;
    }

    private static FieldSpec copyFieldSpec(FieldSpec fieldSpec) {
        FieldSpec fieldSpec2 = new FieldSpec();
        if (fieldSpec == null) {
            return fieldSpec2;
        }
        fieldSpec2.id = fieldSpec.id;
        fieldSpec2.categories = fieldSpec.categories;
        fieldSpec2.format = fieldSpec.format;
        fieldSpec2.granularity = fieldSpec.granularity;
        fieldSpec2.key = fieldSpec.key;
        fieldSpec2.label = fieldSpec.label;
        fieldSpec2.max = fieldSpec.max;
        fieldSpec2.min = fieldSpec.min;
        fieldSpec2.unit = fieldSpec.unit;
        fieldSpec2.order = fieldSpec.order;
        return fieldSpec2;
    }

    private static DerivedParameterSpec copyParameters(DerivedParameterSpec derivedParameterSpec) {
        DerivedParameterSpec derivedParameterSpec2 = new DerivedParameterSpec();
        if (derivedParameterSpec == null) {
            return derivedParameterSpec2;
        }
        derivedParameterSpec2.binStart = derivedParameterSpec.binStart;
        derivedParameterSpec2.summaryFunction = derivedParameterSpec.summaryFunction;
        derivedParameterSpec2.window = derivedParameterSpec.window;
        derivedParameterSpec2.addTotalCategory = derivedParameterSpec.addTotalCategory;
        derivedParameterSpec2.sortCategories = derivedParameterSpec.sortCategories;
        derivedParameterSpec2.replicate = derivedParameterSpec.replicate;
        derivedParameterSpec2.ascending = derivedParameterSpec.ascending;
        return derivedParameterSpec2;
    }
}

