/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.NormalDistributionType;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Distribution
extends Transform {
    private final int xInputIndex = this.getInputIndex("x");
    private Range xRange;
    private final NormalDistributionType type;

    public Distribution(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl, String string) {
        super(arrayList, arrayList2, loggerImpl);
        for (DerivedField derivedField : arrayList) {
            if (derivedField.inputIndex != this.xInputIndex) continue;
            this.xRange = derivedField.inputRange;
        }
        if (!"distribution.normal".equals(string)) {
            throw new IllegalArgumentException("Unknown distribution: " + string);
        }
        this.type = new NormalDistributionType();
    }

    @Override
    protected int getFixedOutputCount() {
        return 81;
    }

    @Override
    public boolean isPdf() {
        return true;
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        if (this.xInputIndex < 0) {
            if (this.getLogger() != null && this.getLogger().hasListeners()) {
                this.getLogger().error(LogComponent.JavaEngine, "Unable to calculate distribution. No 'x' input was specified.");
            }
            return;
        }
        int[] nArray = this.sortAndRemoveMissing(rowArray, this.xInputIndex, -1, group.getRows(), true);
        if (nArray.length < 2) {
            if (this.getLogger() != null && this.getLogger().hasListeners()) {
                this.getLogger().info(LogComponent.JavaEngine, "Unable to calculate distribution. At least 2 inputs are needed, we have " + nArray.length);
            }
            return;
        }
        this.setOverallData(rowArray, this.type, this.xInputIndex);
        double[] dArray = this.calculateMoments(rowArray, this.xInputIndex, nArray);
        this.type.setGroupMoments(dArray[0], dArray[1], dArray[2]);
        Range range = this.xRange.expand(this.type.getWindowWidth());
        for (Object object : this.outputs) {
            if (!"x".equals(((DerivedField)object).role)) continue;
            ((DerivedField)object).outputGranularity = range.getRange() / (double)this.getFixedOutputCount();
            ((DerivedField)object).outputRange = this.xRange;
        }
        Range range2 = this.getRange(rowArray, group.getRows(), this.xInputIndex, this.xRange);
        range = range2.expand(dArray[2] * 3.0);
        for (DerivedField derivedField : this.outputs) {
            int n3 = this.getFixedOutputCount();
            for (int i = 0; i < n3; ++i) {
                double d;
                double d2 = range.fromZeroOne((double)i / (double)(n3 - 1));
                if ("x".equals(derivedField.role)) {
                    rowArray2[n + i].data[derivedField.outputIndex] = d2;
                    continue;
                }
                if (!"y".equals(derivedField.role)) continue;
                rowArray2[n + i].data[derivedField.outputIndex] = d = this.type.getDensity(d2, this.getMultiplier());
            }
        }
    }

    private double[] calculateMoments(Row[] rowArray, int n, int[] nArray) {
        if (nArray.length == 0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int n2 : nArray) {
            double d3 = this.getWeight(rowArray[n2]);
            d += d3;
            Double d4 = rowArray[n2].data[n];
            d2 += d3 * d4;
        }
        double d5 = d2 / d;
        double d6 = 0.0;
        for (int n3 : nArray) {
            double d7 = this.getWeight(rowArray[n3]);
            Double d8 = rowArray[n3].data[n];
            double d9 = d8;
            d6 += d7 * (d9 - d5) * (d9 - d5);
        }
        double d10 = Math.sqrt(d6 / d);
        if (this.getLogger() != null && this.getLogger().hasListeners()) {
            this.getLogger().log(LogLevel.Info, LogComponent.JavaEngine, "Distribution calculation", "X Bar", d5);
            this.getLogger().log(LogLevel.Info, LogComponent.JavaEngine, "Distribution calculation", "Standard Deviation", d10);
        }
        return new double[]{d, d5, d10};
    }
}

