/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Grouping {
    private static final String KEY_SEPARATOR = "|";
    private final ArrayList<DerivedField> definitions;
    private Row[] input;
    private final int outputFieldCount;

    public Grouping(ArrayList<DerivedField> arrayList, Row[] rowArray) {
        this.definitions = arrayList;
        int n = 0;
        for (DerivedField derivedField : arrayList) {
            if (derivedField.outputIndex < 0) continue;
            ++n;
        }
        this.outputFieldCount = n;
        this.input = rowArray;
    }

    public Group[] makeGroupings() {
        Object object;
        HashMap<String, Group[]> hashMap = new HashMap<String, Group[]>();
        for (int i = 0; i < this.input.length; ++i) {
            String string = this.makeGroupKey(this.input[i].data, this.definitions);
            if (string == null) continue;
            object = (IntPrimitiveArrayList)hashMap.get(string);
            if (object == null) {
                object = new IntPrimitiveArrayList();
                hashMap.put(string, (Group[])object);
            }
            object.add(i);
        }
        Object[] objectArray = new String[hashMap.size()];
        int n = 0;
        for (Object[] objectArray2 : hashMap.keySet()) {
            objectArray[n++] = objectArray2;
        }
        BasicFactory.sortArray(objectArray);
        object = new Group[hashMap.size()];
        n = 0;
        for (Object object2 : objectArray) {
            Group group = new Group();
            group.setKey((String)object2);
            group.setRows((IntPrimitiveArrayList)hashMap.get(object2));
            object[n++] = group;
        }
        return object;
    }

    private String makeGroupKey(double[] dArray, ArrayList<DerivedField> arrayList) {
        String string = "";
        for (DerivedField derivedField : arrayList) {
            double d = Grouping.binIfNeeded(dArray[derivedField.inputIndex], derivedField);
            if (Double.isNaN(d)) {
                return null;
            }
            double d2 = d;
            if (d2 == (double)((int)d2)) {
                string = string + (int)d2 + KEY_SEPARATOR;
                continue;
            }
            string = string + d + KEY_SEPARATOR;
        }
        return string;
    }

    public static double binIfNeeded(double d, DerivedField derivedField) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        if (derivedField.parameters.binStart != null) {
            d2 = derivedField.parameters.binStart.doubleValue();
        }
        double d3 = Double.NaN;
        if (derivedField.derivedField.granularity != null) {
            d3 = derivedField.derivedField.granularity.doubleValue();
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return d;
        }
        double d4 = Math.floor((d - d2) / d3);
        return (d4 + 0.5) * d3 + d2;
    }

    public void setRowValues(IntPrimitiveArrayList intPrimitiveArrayList, Row[] rowArray, int n, int n2) {
        int n3 = intPrimitiveArrayList.get(0);
        for (DerivedField derivedField : this.definitions) {
            if (derivedField.outputIndex < 0) continue;
            Double d = Grouping.binIfNeeded(this.input[n3].data[derivedField.inputIndex], derivedField);
            for (int i = n; i < n + n2; ++i) {
                rowArray[i].data[derivedField.outputIndex] = d;
                rowArray[i].setOriginalRows(intPrimitiveArrayList);
            }
        }
    }

    public int getOutputFieldCount() {
        return this.outputFieldCount;
    }

    public final Row[] getInput() {
        return this.input;
    }

    public final void setInput(Row[] rowArray) {
        this.input = rowArray;
    }
}

