/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Integrate
extends Transform {
    public static final String ROLE_TYPE = "type";
    public static final String ROLE_FROM = "from";
    public static final String ROLE_Y0 = "y0";
    public static final String ROLE_Y1 = "y1";
    public static final String ROLE_YPERCENT = "yPercent";
    private static final String ERROR_MISSING_OUTPUT_ROLE = "Missing required output role: \"%s\".";
    private static final String ERROR_MISSING_INPUT_ROLE = "Missing required input role: \"%s\".";
    public static final int TYPE_ZERO = 0;
    public static final int TYPE_ADD = 1;
    public static final int TYPE_SUB = 2;
    public static final int TYPE_NET_ZERO = 3;
    public static final int TYPE_NET_ADD = 4;
    public static final int TYPE_NET_SUB = 5;
    private int totalCategory = -1;
    private String totalCategoryLabel = null;
    private boolean sortCategories = true;
    private final DerivedField inX;
    private final DerivedField inY;
    private final DerivedField inYPercent;
    private final DerivedField outX;
    private final DerivedField outY1;
    private final DerivedField outY0;
    private final DerivedField outY;
    private final DerivedField outYPercent;
    private final DerivedField outType;
    private final DerivedField outFrom;

    private final DerivedField getRequiredRole(ArrayList<DerivedField> arrayList, String string, String string2) {
        DerivedField derivedField = Integrate.getRole(arrayList, string);
        if (derivedField == null && this.getLogger() != null && this.getLogger().hasListeners()) {
            this.getLogger().error(LogComponent.JavaEngine, String.format(string2, string));
        }
        return derivedField;
    }

    private static final DerivedField getRole(ArrayList<DerivedField> arrayList, String string) {
        if (string != null) {
            for (DerivedField derivedField : arrayList) {
                if (!string.equals(derivedField.role)) continue;
                return derivedField;
            }
        }
        return null;
    }

    public Integrate(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl) {
        super(arrayList, arrayList2, loggerImpl);
        this.inY = this.getRequiredRole(arrayList, "y", ERROR_MISSING_INPUT_ROLE);
        this.inX = this.getRequiredRole(arrayList, "x", ERROR_MISSING_INPUT_ROLE);
        this.inYPercent = Integrate.getRole(arrayList, ROLE_YPERCENT);
        this.outX = this.getRequiredRole(arrayList2, "x", ERROR_MISSING_OUTPUT_ROLE);
        if (this.outX.parameters.addTotalCategory != null) {
            this.totalCategoryLabel = this.outX.parameters.addTotalCategory;
            this.totalCategory = this.inX.categories.length;
        }
        this.sortCategories = this.outX.parameters.sortCategories != null ? this.outX.parameters.sortCategories : true;
        this.outY = Integrate.getRole(arrayList2, "y");
        this.outY0 = Integrate.getRole(arrayList2, ROLE_Y0);
        this.outY1 = Integrate.getRole(arrayList2, ROLE_Y1);
        this.outYPercent = Integrate.getRole(arrayList2, ROLE_YPERCENT);
        this.outType = Integrate.getRole(arrayList2, ROLE_TYPE);
        this.outFrom = Integrate.getRole(arrayList2, ROLE_FROM);
    }

    @Override
    public final boolean hasPrimaryRows() {
        return true;
    }

    final boolean sortCategories() {
        return this.sortCategories;
    }

    private boolean hasTotalCategory() {
        return this.totalCategoryLabel != null;
    }

    @Override
    public int getMatchingInputField(DerivedField derivedField) {
        if (derivedField.role.equals(ROLE_Y0) || derivedField.role.equals(ROLE_Y1)) {
            return this.getInputIndex("y");
        }
        if (derivedField.role.equals(ROLE_FROM)) {
            return this.getInputIndex("x");
        }
        return this.getInputIndex(derivedField.role);
    }

    private String[] appendTotalCategory(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = this.totalCategoryLabel;
        assert (stringArray.length == this.totalCategory);
        return stringArray2;
    }

    @Override
    public void finishMatchedOutputField(DerivedField derivedField, Field field, Field[] fieldArray, Field[] fieldArray2) {
        super.finishMatchedOutputField(derivedField, field, fieldArray, fieldArray2);
        Field field2 = fieldArray2[derivedField.outputIndex];
        if (derivedField == this.outX) {
            if (this.hasTotalCategory()) {
                field2.categories = this.appendTotalCategory(field2.categories);
            }
        } else if (field == null) {
            assert (derivedField.role.equals(ROLE_TYPE));
            field2.unit = Unit.CATEGORICAL;
        }
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        double d;
        int[] nArray = this.sortAndRemoveMissing(rowArray, this.inX.inputIndex, -1, group.getRows(), this.sortCategories);
        int n3 = n;
        double d2 = d = 0.0;
        double[] dArray = null;
        double d3 = Double.NaN;
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        int n4 = this.outputs.size();
        for (int n5 : nArray) {
            double[] dArray2 = rowArray[n5].data;
            double d4 = Integrate.get(dArray2, this.inX);
            double d5 = Integrate.get(dArray2, this.inY);
            double d6 = Integrate.get(dArray2, this.inYPercent);
            if (!Double.isNaN(d4)) {
                Row row = rowArray2[n3];
                double[] dArray3 = row.data;
                Integrate.set(dArray3, this.outX, d4);
                Integrate.set(dArray3, this.outY, d5);
                double d7 = Double.NaN;
                if (!Double.isNaN(d5) && dArray != null && !Double.isNaN(d3)) {
                    d7 = dArray[this.outX.outputIndex];
                }
                if (!Double.isNaN(d5)) {
                    Integrate.set(dArray3, this.outY0, d2);
                    if (!Double.isNaN(d6)) {
                        double d8 = d2 + d6 * d5;
                        Integrate.set(dArray3, this.outYPercent, d8);
                    }
                    Integrate.set(dArray3, this.outY1, d2 += d5);
                } else if (this.getLogger() != null && this.getLogger().hasListeners()) {
                    this.getLogger().warning(LogComponent.JavaEngine, "Missing y value.");
                }
                Integrate.set(dArray3, this.outType, Integrate.getRowType(d5));
                Integrate.set(dArray3, this.outFrom, d7);
                for (int i = 0; i < n4; ++i) {
                    DerivedField derivedField = (DerivedField)this.outputs.get(i);
                    if (derivedField.role != null || derivedField.inputIndex < 0) continue;
                    Integrate.set(dArray3, derivedField, dArray2[derivedField.inputIndex]);
                }
                intPrimitiveArrayList.add(n5);
                row.setOriginalRows(intPrimitiveArrayList);
                row.setPrimaryRow(n5);
                this.traceOutput(n3, dArray3);
                dArray = dArray3;
                d3 = d5;
            } else if (this.getLogger() != null && this.getLogger().hasListeners()) {
                this.getLogger().warning(LogComponent.JavaEngine, "Missing x value.");
            }
            ++n3;
        }
        if (this.hasTotalCategory() && dArray != null) {
            Object object = rowArray2[n3++];
            double[] dArray4 = ((Row)object).data;
            Integrate.set(dArray4, this.outX, this.totalCategory);
            Integrate.set(dArray4, this.outY, d2);
            Integrate.set(dArray4, this.outY0, d2);
            Integrate.set(dArray4, this.outY1, d);
            Integrate.set(dArray4, this.outType, Integrate.getTotalType(d2));
            Integrate.set(dArray4, this.outFrom, !Double.isNaN(d3) ? dArray[this.outX.outputIndex] : 0.0);
            ((Row)object).setOriginalRows(intPrimitiveArrayList);
            this.traceOutput(n3, dArray4);
        }
    }

    private final void traceOutput(int n, double[] dArray) {
        if (this.getLogger() != null && this.getLogger().hasListeners()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (double d : dArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(d);
            }
            this.getLogger().info(LogComponent.JavaEngine, "output[" + n + "]=" + stringBuilder.toString());
        }
    }

    private static int getRowType(Number number) {
        if (number != null) {
            if (number.doubleValue() > 0.0) {
                return 1;
            }
            if (number.doubleValue() < 0.0) {
                return 2;
            }
        }
        return 0;
    }

    private static int getTotalType(Number number) {
        if (number != null) {
            if (number.doubleValue() > 0.0) {
                return 4;
            }
            if (number.doubleValue() < 0.0) {
                return 5;
            }
        }
        return 3;
    }

    @Override
    public int getTotalOutputCount(Group[] groupArray, Row[] rowArray) {
        return rowArray.length + this.getFixedOutputCount() * groupArray.length;
    }

    @Override
    public int getOutputCount(IntPrimitiveArrayList intPrimitiveArrayList) {
        return intPrimitiveArrayList.size() + this.getFixedOutputCount();
    }

    @Override
    protected int getFixedOutputCount() {
        return this.hasTotalCategory() ? 1 : 0;
    }
}

