/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.SmoothType;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class KernelSmoothType
extends SmoothType {
    private double h = -1.0;
    private double[] xData;
    private double[] yData;
    private double[] wData;
    private double xMean;
    private double yMean;

    @Override
    public int getRowsCreated() {
        return 21;
    }

    @Override
    public void setGroupMoments(double d, double d2, double d3, double d4, double d5, double d6) {
        this.xMean = d2;
        this.yMean = d3;
    }

    @Override
    public void setGroupData(Row[] rowArray, int n, int n2, int n3, int[] nArray) {
        this.xData = new double[nArray.length];
        this.yData = new double[nArray.length];
        this.wData = new double[nArray.length];
        int n4 = 0;
        for (int n5 : nArray) {
            Double d;
            Double d2 = rowArray[n5].data[n];
            this.xData[n4] = d2;
            if (n2 >= 0) {
                d = rowArray[n5].data[n2];
                this.yData[n4] = d;
            }
            if (n3 > 0) {
                d = rowArray[n5].data[n3];
                this.wData[n4] = d;
            } else {
                this.wData[n4] = 1.0;
            }
            ++n4;
        }
    }

    @Override
    public void setOverallDataDetails(Row[] rowArray, int n, int[] nArray) {
        this.xData = new double[nArray.length];
        int n2 = 0;
        for (int n3 : nArray) {
            Double d = rowArray[n3].data[n];
            this.xData[n2++] = d;
        }
        double d = this.xData.length < 4 ? (this.xData[n2 - 1] - this.xData[0]) / 2.0 : this.xData[(int)Math.round(3.0 * (double)(n2 - 1) / 4.0)] - this.xData[(int)Math.round((double)(n2 - 1) / 4.0)];
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d2 += this.xData[i];
        }
        d2 /= (double)this.xData.length;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = this.xData[i];
            d3 += (d4 - d2) * (d4 - d2);
        }
        d3 = Math.sqrt(d3 / (double)this.xData.length);
        double d5 = d > 0.0 ? Math.min(d / 1.34, d3) : d3;
        this.h = 2.34 * d5 * Math.pow(rowArray.length, -0.2);
        double d6 = this.xData[n2 - 1] - this.xData[0];
        if (this.h < d6 / 40.0) {
            this.h = d6 / 40.0;
        }
        if (this.h == 0.0) {
            this.h = d2 / 10.0;
        }
        if (this.h == 0.0) {
            this.h = 1.0;
        }
    }

    @Override
    public double getPrediction(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.xData.length; ++i) {
            double d7 = this.wData[i] * this.K((d - this.xData[i]) / this.h);
            if (!(d7 > 0.0)) continue;
            double d8 = this.xData[i] - this.xMean;
            double d9 = this.yData[i] - this.yMean;
            d2 += d7;
            d3 += d7 * d8;
            d4 += d7 * d9;
            d5 += d7 * d8 * d8;
            d6 += d7 * d8 * d9;
        }
        if (d2 <= 2.0) {
            return Double.NaN;
        }
        double d10 = d2 * d5 - d3 * d3;
        if (d10 <= 1.0E-8) {
            return this.yMean + d4 / d2;
        }
        double d11 = (d2 * d6 - d3 * d4) / d10;
        double d12 = (d4 - d11 * d3) / d2;
        return d12 + d11 * (d - this.xMean) + this.yMean;
    }

    @Override
    public double getDensity(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.xData.length; ++i) {
            d3 += this.wData[i] * this.K((d - this.xData[i]) / this.h);
            d4 += this.wData[i];
        }
        if (Double.isNaN(d2)) {
            d2 = d4;
        }
        return d2 * d3 / (this.h * d4);
    }

    @Override
    public double getWindowWidth() {
        return this.h;
    }

    private double K(double d) {
        if (d < -1.0 || d > 1.0) {
            return 0.0;
        }
        return 0.75 * (1.0 - d * d);
    }
}

