/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.TransformType;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NormalDistributionType
extends TransformType {
    private double sumOfWeights;
    private double xBar;
    private double standardDeviation;
    private double windowWidth = -1.0;
    private double[] xData;
    private static final double SQR_ROOT_TWO_PI = Math.sqrt(Math.PI * 2);
    public static final int EXPAND_LEVEL = 3;

    public void setGroupMoments(double d, double d2, double d3) {
        this.sumOfWeights = d;
        this.xBar = d2;
        this.standardDeviation = d3;
    }

    @Override
    public double getDensity(double d, double d2) {
        double d3 = d - this.xBar;
        double d4 = -(d3 * d3) / (2.0 * this.standardDeviation * this.standardDeviation);
        double d5 = SQR_ROOT_TWO_PI * this.standardDeviation;
        double d6 = Math.exp(d4) / d5;
        if (Double.isNaN(d2)) {
            d2 = this.sumOfWeights;
        }
        return d6 * d2;
    }

    @Override
    public void setOverallDataDetails(Row[] rowArray, int n, int[] nArray) {
        int n2;
        this.xData = new double[nArray.length];
        int n3 = 0;
        int[] nArray2 = nArray;
        int n4 = nArray2.length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = nArray2[n2];
            Double d = rowArray[n5].data[n];
            this.xData[n3++] = d;
        }
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d += this.xData[n2];
        }
        d /= (double)this.xData.length;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d3 = this.xData[i];
            d2 += (d3 - d) * (d3 - d);
        }
        d2 = Math.sqrt(d2 / (double)this.xData.length);
        this.windowWidth = d2 * 3.0;
    }

    @Override
    public double getWindowWidth() {
        return this.windowWidth;
    }
}

