/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.OrderTransformComparator;
import com.ibm.vis.engine.internal.data.transform.SortFieldComparator;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Order
extends Transform {
    private static final String SORT_ROLE = "sort";

    public Order(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl) {
        super(arrayList, arrayList2, loggerImpl);
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        int n3;
        List<DerivedField> list = Order.getSortFields(this.outputs);
        IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
        Row[] rowArray3 = new Row[intPrimitiveArrayList.size()];
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            n3 = intPrimitiveArrayList.get(i);
            rowArray3[i] = rowArray[n3];
        }
        OrderTransformComparator orderTransformComparator = new OrderTransformComparator(list);
        Arrays.sort(rowArray3, orderTransformComparator);
        for (n3 = 0; n3 < rowArray3.length; ++n3) {
            Row row = rowArray2[n + n3];
            double[] dArray = rowArray2[n + n3].data;
            for (DerivedField derivedField : this.outputs) {
                double d = Order.get(rowArray3[n3].data, derivedField);
                Order.set(dArray, derivedField, d);
            }
            int n4 = rowArray3[n3].index;
            row.setSingleOriginalRow(n4);
            row.setPrimaryRow(n4);
        }
    }

    @Override
    public boolean hasPrimaryRows() {
        return true;
    }

    @Override
    public int getTotalOutputCount(Group[] groupArray, Row[] rowArray) {
        int n = 0;
        for (int i = 0; i < groupArray.length; ++i) {
            n += this.getOutputCount(groupArray[i].getRows());
        }
        return n;
    }

    @Override
    public int getOutputCount(IntPrimitiveArrayList intPrimitiveArrayList) {
        return intPrimitiveArrayList.size();
    }

    private static final List<DerivedField> getSortFields(ArrayList<DerivedField> arrayList) {
        Number number;
        Object object;
        int n = arrayList.size();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = n - 1; i >= 0; --i) {
            DerivedField derivedField = arrayList.get(i);
            if (derivedField.role == null || derivedField.inputIndex == -1 || !derivedField.role.startsWith(SORT_ROLE)) continue;
            object = derivedField.role.substring(SORT_ROLE.length());
            int n2 = -1;
            if (((String)object).isEmpty()) {
                n2 = 0;
            } else {
                number = IntegerUtil.parseInt((String)object, 10);
                if (number != null) {
                    n2 = number.intValue();
                }
            }
            if (n2 == -1) continue;
            hashMap.put(i, n2);
        }
        Number[][] numberArray = new Number[hashMap.size()][2];
        int n3 = 0;
        for (Integer n4 : hashMap.keySet()) {
            number = (Integer)hashMap.get(n4);
            numberArray[n3][0] = n4;
            numberArray[n3++][1] = number;
        }
        object = new SortFieldComparator();
        Arrays.sort(numberArray, object);
        ArrayList<DerivedField> arrayList2 = new ArrayList<DerivedField>(hashMap.size());
        for (int i = 0; i < numberArray.length; ++i) {
            DerivedField derivedField = arrayList.get(numberArray[i][0].intValue());
            if (derivedField == null) continue;
            arrayList2.add(derivedField);
        }
        return arrayList2;
    }
}

