/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.Comparator;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class OrderTransformComparator
implements Comparator<Row> {
    private final List<DerivedField> sortFields;

    public OrderTransformComparator(List<DerivedField> list) {
        this.sortFields = list;
    }

    @Override
    public int compare(Row row, Row row2) {
        for (DerivedField derivedField : this.sortFields) {
            double d = row.data[derivedField.inputIndex];
            double d2 = row2.data[derivedField.inputIndex];
            if (Double.isNaN(d) && Double.isNaN(d2)) continue;
            int n = 0;
            if (Double.isNaN(d)) {
                n = -1;
            } else if (Double.isNaN(d2)) {
                n = 1;
            } else if (d != d2) {
                int n2 = n = d < d2 ? -1 : 1;
            }
            if (n == 0) continue;
            int n3 = OrderTransformComparator.getSortDirectionMultiplier(derivedField);
            return n3 * n;
        }
        return row.index < row2.index ? -1 : 1;
    }

    private static int getSortDirectionMultiplier(DerivedField derivedField) {
        Boolean bl = derivedField.parameters.ascending;
        return bl != false ? 1 : -1;
    }
}

