/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Percent
extends Transform {
    public Percent(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl) {
        super(arrayList, arrayList2, loggerImpl);
    }

    @Override
    public boolean hasPrimaryRows() {
        return true;
    }

    @Override
    public int getTotalOutputCount(Group[] groupArray, Row[] rowArray) {
        return rowArray.length;
    }

    @Override
    public int getOutputCount(IntPrimitiveArrayList intPrimitiveArrayList) {
        return intPrimitiveArrayList.size();
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
        for (DerivedField derivedField : this.outputs) {
            int n3;
            int n4;
            String string = derivedField.parameters.summaryFunction;
            if (string == null) {
                int n5 = n;
                for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                    n4 = intPrimitiveArrayList.get(i);
                    double d = rowArray[n4].data[derivedField.inputIndex];
                    Row row = rowArray2[n5++];
                    row.data[derivedField.outputIndex] = d;
                    row.setPrimaryRow(n4);
                }
                continue;
            }
            double d = 0.0;
            for (n4 = 0; n4 < intPrimitiveArrayList.size(); ++n4) {
                n3 = intPrimitiveArrayList.get(n4);
                double d2 = rowArray[n3].data[derivedField.inputIndex];
                if (Double.isNaN(d2)) continue;
                d += Math.abs(d2);
            }
            n4 = n;
            for (n3 = 0; n3 < intPrimitiveArrayList.size(); ++n3) {
                int n6 = intPrimitiveArrayList.get(n3);
                double d3 = rowArray[n6].data[derivedField.inputIndex];
                double d4 = Double.NaN;
                if (!Double.isNaN(d3)) {
                    double d5 = d3;
                    d4 = 100.0 * d5 / d;
                }
                Row row = rowArray2[n4++];
                row.data[derivedField.outputIndex] = d4;
                row.setPrimaryRow(n6);
            }
        }
    }

    @Override
    public void finishMatchedOutputField(DerivedField derivedField, Field field, Field[] fieldArray, Field[] fieldArray2) {
        super.finishMatchedOutputField(derivedField, field, fieldArray, fieldArray2);
        if (field == null) {
            Field field2 = fieldArray2[derivedField.outputIndex];
            field2.unit = Unit.RATIO;
        }
    }
}

