/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.KernelSmoothType;
import com.ibm.vis.engine.internal.data.transform.RegressionSmoothType;
import com.ibm.vis.engine.internal.data.transform.SmoothType;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.spec.internal.FieldSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Smooth
extends Transform {
    private final int xI = this.getInputIndex("x");
    private final int yI = this.getInputIndex("y");
    private final SmoothType type;

    public Smooth(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl, String string) {
        super(arrayList, arrayList2, loggerImpl);
        if ("smooth.regression".equals(string)) {
            this.type = new RegressionSmoothType();
        } else if ("smooth.kernel".equals(string)) {
            this.type = new KernelSmoothType();
        } else {
            throw new IllegalArgumentException("Unknown smooth: " + string);
        }
    }

    @Override
    protected int getFixedOutputCount() {
        int n = this.getOutputIndex("x");
        if (n >= 0) {
            FieldSpec fieldSpec = ((DerivedField)this.outputs.get((int)n)).derivedField;
            Unit unit = Unit.get(fieldSpec.unit, Unit.RATIO);
            if (unit.measure.categorical) {
                DerivedField derivedField = (DerivedField)this.inputs.get(this.xI);
                return (int)Math.round(derivedField.inputRange.getRange());
            }
        }
        return this.type.getRowsCreated();
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        this.setOverallData(rowArray, this.type, this.xI);
        int[] nArray = this.sortAndRemoveMissing(rowArray, this.xI, this.yI, group.getRows(), true);
        double[] dArray = this.calculateMoments1(rowArray, this.xI, this.yI, nArray);
        if (dArray[0] < 1.0E-12) {
            return;
        }
        double[] dArray2 = this.calculateSumSquares(rowArray, this.xI, this.yI, nArray, dArray);
        if (dArray2[0] < 1.0E-12) {
            return;
        }
        double d = rowArray[nArray[0]].data[this.xI];
        double d2 = rowArray[nArray[nArray.length - 1]].data[this.xI];
        double d3 = d;
        double d4 = d2;
        this.type.setGroupMoments(dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2]);
        this.type.setGroupData(rowArray, this.xI, this.yI, this.weightIndex, nArray);
        double d5 = this.calculateSSE(rowArray, this.xI, this.yI, nArray);
        for (DerivedField derivedField : this.outputs) {
            int n3 = this.getFixedOutputCount();
            for (int i = 0; i < n3; ++i) {
                double d6 = d3 + (d4 - d3) * (double)i / (double)(n3 - 1);
                if ("x".equals(derivedField.role)) {
                    rowArray2[n + i].data[derivedField.outputIndex] = d6;
                    continue;
                }
                if ("y".equals(derivedField.role)) {
                    rowArray2[n + i].data[derivedField.outputIndex] = this.type.getPrediction(d6);
                    continue;
                }
                if (!"accuracy".equals(derivedField.role)) continue;
                rowArray2[n + i].data[derivedField.outputIndex] = 1.0 - d5 / dArray2[2];
            }
        }
    }

    private double[] calculateMoments1(Row[] rowArray, int n, int n2, int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int n3 : nArray) {
            double d4 = this.getWeight(rowArray[n3]);
            d += d4;
            double d5 = rowArray[n3].data[n];
            double d6 = rowArray[n3].data[n2];
            d2 += d4 * d5;
            d3 += d4 * d6;
        }
        return new double[]{d, d2 / d, d3 / d};
    }

    private double calculateSSE(Row[] rowArray, int n, int n2, int[] nArray) {
        double d = 0.0;
        for (int n3 : nArray) {
            double d2;
            double d3 = this.getWeight(rowArray[n3]);
            double d4 = rowArray[n3].data[n];
            double d5 = d2 = rowArray[n3].data[n2];
            double d6 = this.type.getPrediction(d4);
            if (Double.isNaN(d6)) continue;
            d += d3 * (d6 - d5) * (d6 - d5);
        }
        return d;
    }

    private double[] calculateSumSquares(Row[] rowArray, int n, int n2, int[] nArray, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int n3 : nArray) {
            double d4 = this.getWeight(rowArray[n3]);
            double d5 = rowArray[n3].data[n];
            double d6 = rowArray[n3].data[n2];
            double d7 = d5;
            double d8 = d6;
            d += d4 * (d7 - dArray[1]) * (d7 - dArray[1]);
            d2 += d4 * (d8 - dArray[2]) * (d8 - dArray[2]);
            d3 += d4 * (d7 - dArray[1]) * (d8 - dArray[2]);
        }
        return new double[]{d, d3, d2};
    }
}

