/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.data.transform.SummaryFunction;
import com.ibm.vis.engine.data.transform.internal.SummaryFunctionServiceUtility;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractSummaryOperation;
import com.ibm.vis.engine.internal.data.transform.BasicAggregateOperation;
import com.ibm.vis.engine.internal.data.transform.CountOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.LowerFence;
import com.ibm.vis.engine.internal.data.transform.LowerHinge;
import com.ibm.vis.engine.internal.data.transform.Median;
import com.ibm.vis.engine.internal.data.transform.PercentOperation;
import com.ibm.vis.engine.internal.data.transform.SummaryFunctionAdapter;
import com.ibm.vis.engine.internal.data.transform.Transform;
import com.ibm.vis.engine.internal.data.transform.Unique;
import com.ibm.vis.engine.internal.data.transform.UpperFence;
import com.ibm.vis.engine.internal.data.transform.UpperHinge;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public class Summary
extends Transform {
    private final Data base;
    private Boolean replicate;
    private final Map<String, Object> cachMap = new HashMap<String, Object>();
    private static Map<String, AbstractSummaryOperation> operations = new HashMap<String, AbstractSummaryOperation>();

    public Summary(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl, Data data) {
        super(arrayList, arrayList2, loggerImpl);
        this.base = data;
        this.replicate = null;
    }

    public Data getBase() {
        return this.base;
    }

    public void addProperty(String string, Object object) {
        this.cachMap.put(string, object);
    }

    public Object getProperty(String string) {
        return this.cachMap.get(string);
    }

    private boolean isReplicate() {
        if (this.replicate == null) {
            int n = this.outputs.size();
            for (int i = 0; !(i >= n || this.replicate != null && this.replicate.booleanValue()); ++i) {
                DerivedField derivedField = (DerivedField)this.outputs.get(i);
                this.replicate = derivedField.parameters.replicate;
            }
            if (this.replicate == null) {
                this.replicate = false;
            }
        }
        return this.replicate;
    }

    @Override
    public int getTotalOutputCount(Group[] groupArray, Row[] rowArray) {
        return this.isReplicate() ? rowArray.length : super.getTotalOutputCount(groupArray, rowArray);
    }

    @Override
    public int getOutputCount(IntPrimitiveArrayList intPrimitiveArrayList) {
        return this.isReplicate() ? intPrimitiveArrayList.size() : this.getFixedOutputCount();
    }

    @Override
    protected int getFixedOutputCount() {
        return 1;
    }

    @Override
    public void setValues(Row[] rowArray, Group group, Row[] rowArray2, int n, int n2) {
        boolean bl = this.isReplicate();
        IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
        for (DerivedField derivedField : this.outputs) {
            Number number = this.makeValue(derivedField, group, rowArray);
            for (int i = n; i < n + n2; ++i) {
                double d;
                rowArray2[i].data[derivedField.outputIndex] = d = bl && derivedField.parameters.summaryFunction == null ? rowArray[intPrimitiveArrayList.get((int)(i - n))].data[derivedField.inputIndex] : (number == null ? Double.NaN : number.doubleValue());
            }
        }
    }

    private Number makeValue(DerivedField derivedField, Group group, Row[] rowArray) {
        AbstractSummaryOperation abstractSummaryOperation;
        String string = derivedField.parameters.summaryFunction;
        if (string == null) {
            string = "count";
        }
        if ((abstractSummaryOperation = operations.get(string)) != null) {
            return abstractSummaryOperation.compute(this, derivedField, group, rowArray);
        }
        SummaryFunction summaryFunction = SummaryFunctionServiceUtility.getInstance().getSummaryFunction(string);
        if (summaryFunction != null) {
            SummaryFunctionAdapter summaryFunctionAdapter = new SummaryFunctionAdapter(summaryFunction);
            return summaryFunctionAdapter.compute(this, derivedField, group, rowArray);
        }
        throw new UnsupportedOperationException("Unsupported summary: " + string);
    }

    @Override
    public void finishMatchedOutputField(DerivedField derivedField, Field field, Field[] fieldArray, Field[] fieldArray2) {
        super.finishMatchedOutputField(derivedField, field, fieldArray, fieldArray2);
        if (field == null) {
            Field field2 = fieldArray2[derivedField.outputIndex];
            field2.unit = Unit.COUNT;
        }
    }

    @Override
    public void finishOutputField(DerivedField derivedField, Field[] fieldArray, Field[] fieldArray2) {
        super.finishOutputField(derivedField, fieldArray, fieldArray2);
        AbstractSummaryOperation abstractSummaryOperation = operations.get(derivedField.parameters.summaryFunction);
        if (abstractSummaryOperation != null) {
            abstractSummaryOperation.finishOutputField(this, derivedField, fieldArray, fieldArray2);
        }
    }

    static {
        operations.put("median", new Median());
        operations.put("upperHinge", new UpperHinge());
        operations.put("lowerHinge", new LowerHinge());
        operations.put("lowerFence", new LowerFence());
        operations.put("upperFence", new UpperFence());
        operations.put("count", new CountOperation("count"));
        operations.put("percentOfCount", new CountOperation("percentOfCount"));
        operations.put("uniques", new Unique());
        operations.put("percent", new PercentOperation());
        operations.put("min", new BasicAggregateOperation("min"));
        operations.put("max", new BasicAggregateOperation("max"));
        operations.put("mean", new BasicAggregateOperation("mean"));
        operations.put("sum", new BasicAggregateOperation("sum"));
    }
}

