/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.data.transform.SummaryFunction;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractSummaryOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Summary;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SummaryFunctionAdapter
extends AbstractSummaryOperation {
    private final SummaryFunction summaryFunction;

    public SummaryFunctionAdapter(SummaryFunction summaryFunction) {
        this.summaryFunction = summaryFunction;
    }

    @Override
    protected String getOperationFamily() {
        return this.summaryFunction.getOperationFamily();
    }

    @Override
    protected Object precomputeData(Summary summary, DerivedField derivedField, Group group, Row[] rowArray) {
        Object[] objectArray = SummaryFunctionAdapter.getValuesAndWeights(summary, derivedField, group, rowArray);
        return this.summaryFunction.precomputeData((Number[])objectArray[0], (double[])objectArray[1]);
    }

    @Override
    protected Number doCompute(Summary summary, DerivedField derivedField, Group group, Row[] rowArray, Object object) {
        Object[] objectArray = SummaryFunctionAdapter.getValuesAndWeights(summary, derivedField, group, rowArray);
        return this.summaryFunction.compute((Number[])objectArray[0], (double[])objectArray[1], object);
    }

    private static Object[] getValuesAndWeights(Summary summary, DerivedField derivedField, Group group, Row[] rowArray) {
        IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
        int n = intPrimitiveArrayList.size();
        Number[] numberArray = new Number[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = intPrimitiveArrayList.get(i);
            numberArray[i] = derivedField.inputIndex < 0 ? null : Double.valueOf(rowArray[n2].data[derivedField.inputIndex]);
            dArray[i] = summary.getWeight(rowArray[n2]);
        }
        return new Object[]{numberArray, dArray};
    }
}

