/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.TransformType;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/dataTransformsLayer")
public abstract class Transform {
    public static final String ROLE_X = "x";
    public static final String ROLE_Y = "y";
    public static final String ROLE_ACCURACY = "accuracy";
    public static final String ROLE_WEIGHT = "weight";
    protected final ArrayList<DerivedField> inputs;
    protected final ArrayList<DerivedField> outputs;
    private final LoggerImpl logger;
    protected final int weightIndex;
    private double multiplier = Double.NaN;

    protected static final double get(double[] dArray, DerivedField derivedField) {
        return derivedField == null ? Double.NaN : dArray[derivedField.inputIndex];
    }

    protected static final void set(double[] dArray, DerivedField derivedField, double d) {
        if (derivedField != null) {
            dArray[derivedField.outputIndex] = d;
        }
    }

    protected Transform(ArrayList<DerivedField> arrayList, ArrayList<DerivedField> arrayList2, LoggerImpl loggerImpl) {
        this.inputs = arrayList;
        this.outputs = arrayList2;
        this.logger = loggerImpl;
        this.weightIndex = this.getInputIndex(ROLE_WEIGHT);
    }

    public int getTotalOutputCount(Group[] groupArray, Row[] rowArray) {
        return this.getFixedOutputCount() * groupArray.length;
    }

    public int getOutputCount(IntPrimitiveArrayList intPrimitiveArrayList) {
        return this.getFixedOutputCount();
    }

    protected int getFixedOutputCount() {
        return 0;
    }

    public abstract void setValues(Row[] var1, Group var2, Row[] var3, int var4, int var5);

    public boolean hasPrimaryRows() {
        return false;
    }

    protected int getInputIndex(String string) {
        if (string != null) {
            for (DerivedField derivedField : this.inputs) {
                if (!string.equals(derivedField.role)) continue;
                return derivedField.inputIndex;
            }
        }
        return -1;
    }

    public int getOutputIndex(String string) {
        if (string != null) {
            for (DerivedField derivedField : this.outputs) {
                if (!string.equals(derivedField.role)) continue;
                return derivedField.outputIndex;
            }
        }
        return -1;
    }

    public int getOutputFieldCount() {
        return this.outputs.size();
    }

    public int getMatchingInputField(DerivedField derivedField) {
        return this.getInputIndex(derivedField.role);
    }

    public double getWeight(Row row) {
        if (this.weightIndex < 0) {
            return 1.0;
        }
        Double d = row.data[this.weightIndex];
        if (d != null && d > 0.0) {
            return d;
        }
        return 0.0;
    }

    protected int[] sortAndRemoveMissing(Row[] rowArray, int n, int n2, IntPrimitiveArrayList intPrimitiveArrayList, boolean bl) {
        int[] nArray;
        int n3;
        double d;
        int n4;
        IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            n4 = intPrimitiveArrayList.get(i);
            double d2 = this.getWeight(rowArray[n4]);
            if (d2 <= 0.0 || Double.isNaN(d = rowArray[n4].data[n]) || n2 >= 0 && Double.isNaN(rowArray[n4].data[n2])) continue;
            intPrimitiveArrayList2.add(n4);
        }
        double[] dArray = new double[intPrimitiveArrayList2.size()];
        n4 = 0;
        for (int i = 0; i < intPrimitiveArrayList2.size(); ++i) {
            n3 = intPrimitiveArrayList2.get(i);
            d = rowArray[n3].data[n];
            dArray[n4++] = d;
        }
        if (bl) {
            nArray = BasicFactory.makeSortOrder(dArray);
        } else {
            nArray = new int[dArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = n3;
            }
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = intPrimitiveArrayList2.get(nArray[n3]);
        }
        return nArray;
    }

    protected void setOverallData(Row[] rowArray, TransformType transformType, int n) {
        if (transformType.getWindowWidth() <= 0.0) {
            IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
            for (int i = 0; i < rowArray.length; ++i) {
                intPrimitiveArrayList.add(i);
            }
            int[] nArray = this.sortAndRemoveMissing(rowArray, n, -1, intPrimitiveArrayList, true);
            transformType.setOverallDataDetails(rowArray, n, nArray);
        }
    }

    protected Range getRange(Row[] rowArray, IntPrimitiveArrayList intPrimitiveArrayList, int n, Range range) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            Row row = rowArray[intPrimitiveArrayList.get(i)];
            d = Math.min(d, row.data[n]);
            d2 = Math.max(d2, row.data[n]);
        }
        if (Double.isNaN(d)) {
            d = range.getMin();
        }
        if (Double.isNaN(d2)) {
            d2 = range.getMax();
        }
        return new Range(d, d2);
    }

    public void finishOutputField(DerivedField derivedField, Field[] fieldArray, Field[] fieldArray2) {
        int n = derivedField.inputIndex;
        if (n < 0) {
            n = this.getMatchingInputField(derivedField);
        }
        Field field = null;
        if (n >= 0) {
            field = fieldArray[n];
        }
        this.finishMatchedOutputField(derivedField, field, fieldArray, fieldArray2);
    }

    public void finishMatchedOutputField(DerivedField derivedField, Field field, Field[] fieldArray, Field[] fieldArray2) {
        Field field2 = fieldArray2[derivedField.outputIndex];
        if (field != null) {
            field2.copyDerivedInfo(field);
            field2.setSourceField(field.id);
        }
        field2.setSourceOperation(derivedField.getOperation());
        if (derivedField.outputRange != null) {
            field2.range = derivedField.outputRange;
        }
        field2.granularity = derivedField.outputGranularity;
    }

    public LoggerImpl getLogger() {
        return this.logger;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean isPdf() {
        return false;
    }
}

