/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.data.transform;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.data.transform.AbstractSummaryOperation;
import com.ibm.vis.engine.internal.data.transform.DerivedField;
import com.ibm.vis.engine.internal.data.transform.Group;
import com.ibm.vis.engine.internal.data.transform.Summary;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import java.util.HashMap;
import java.util.Map;

public class Unique
extends AbstractSummaryOperation {
    private static final String NEWLINE = "\n";
    private static final String COMMA = ", ";
    private static final String STRINGS_KEY = "STRINGS";
    public static final String TYPE = "uniques";

    @Override
    protected String getOperationFamily() {
        return STRINGS_KEY;
    }

    @Override
    protected Object precomputeData(Summary summary, DerivedField derivedField, Group group, Row[] rowArray) {
        return null;
    }

    @Override
    protected Number doCompute(Summary summary, DerivedField derivedField, Group group, Row[] rowArray, Object object) {
        IntPrimitiveArrayList intPrimitiveArrayList = group.getRows();
        return Unique.makeIndexedString(summary, derivedField, intPrimitiveArrayList, rowArray);
    }

    private static String getPreCalculationKey(DerivedField derivedField) {
        return derivedField.inputIndex + ":" + STRINGS_KEY;
    }

    @Override
    public void finishOutputField(Summary summary, DerivedField derivedField, Field[] fieldArray, Field[] fieldArray2) {
        Field field = fieldArray2[derivedField.outputIndex];
        Map map = (Map)summary.getProperty(Unique.getPreCalculationKey(derivedField));
        if (map != null) {
            field.categories = new String[map.size()];
            for (String string : map.keySet()) {
                int n = (Integer)map.get(string);
                field.categories[n] = string;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Number makeIndexedString(Summary summary, DerivedField derivedField, IntPrimitiveArrayList intPrimitiveArrayList, Row[] rowArray) {
        void var11_16;
        Object object;
        int n;
        Field field = summary.getBase().fields[derivedField.inputIndex];
        HashMap<Object, Integer> hashMap = (HashMap<Object, Integer>)summary.getProperty(Unique.getPreCalculationKey(derivedField));
        if (hashMap == null) {
            hashMap = new HashMap<Object, Integer>();
            summary.addProperty(Unique.getPreCalculationKey(derivedField), hashMap);
        }
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            n = intPrimitiveArrayList.get(i);
            object = rowArray[n].data[field.getIndex()];
            if (object == null) continue;
            hashMap2.put(object, object);
        }
        Object[] objectArray = new Integer[hashMap2.size()];
        n = 0;
        for (Number number : hashMap2.keySet()) {
            objectArray[n++] = (int)Math.round(number.doubleValue());
        }
        BasicFactory.sortArray(objectArray);
        object = null;
        int n2 = 0;
        for (Object object2 : objectArray) {
            String string = field.getFormattedStringValue(((Integer)object2).intValue(), (Integer)object2, null);
            if (object == null) {
                object = string;
                continue;
            }
            if (string == null) continue;
            object = (String)object + (n2++ % 4 == 0 ? NEWLINE : COMMA) + string;
        }
        if (object == null) {
            return null;
        }
        Integer n3 = (Integer)hashMap.get(object);
        if (n3 == null) {
            Integer n4 = hashMap.size();
            hashMap.put(object, n4);
        }
        return var11_16;
    }
}

