/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.common;

import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.internal.diagram.graph.common.Edge;
import com.ibm.vis.engine.internal.diagram.graph.common.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphDiagram
extends Diagram {
    public static final String ROUTING_STORE_KEY = "graph-layout-edges";
    public static final String DIRECTED_STORE_KEY = "graph-layout-vertical";
    private static final double EPSILON = 1.0E-6;
    private Geom[] shapes;
    protected Node[] nodes;
    protected int N;
    protected int E;

    protected GraphDiagram() {
    }

    private void addEdgesToNodes() {
        Double[] doubleArray;
        int n;
        this.E = 0;
        List[] listArray = new List[this.N];
        List[] listArray2 = new List[this.N];
        for (n = 0; n < this.N; ++n) {
            listArray[n] = new ArrayList();
            listArray2[n] = new ArrayList();
        }
        n = 0;
        while ((doubleArray = this.connector.row(n)) != null) {
            if (doubleArray[0] != null && doubleArray[1] != null) {
                Integer n2 = this.connector.getReferencedRow(doubleArray[0]);
                Integer n3 = this.connector.getReferencedRow(doubleArray[1]);
                if (n2 != null && n3 != null) {
                    double d = 1.0;
                    if (doubleArray.length > 2 && doubleArray[2] != null) {
                        d = doubleArray[2];
                    }
                    if (n2 != n3 && d > 0.0) {
                        Edge edge = new Edge(this.nodes[n2], this.nodes[n3], d, false);
                        listArray[n2].add(edge);
                        listArray2[n2].add(edge);
                        listArray2[n3].add(edge);
                        ++this.E;
                    }
                }
            }
            ++n;
        }
        for (n = 0; n < this.N; ++n) {
            this.nodes[n].edges = this.sortBySize(listArray2[n]);
            this.nodes[n].outgoing = this.sortBySize(listArray[n]);
        }
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
        this.makeNodes();
        this.addEdgesToNodes();
    }

    private void makeNodes() {
        this.shapes = this.connector.makeUnplacedShapes();
        this.N = this.shapes.length;
        this.nodes = new Node[this.N];
        for (int i = 0; i < this.N; ++i) {
            Rect rect = this.shapes[i].getBounds();
            this.nodes[i] = new Node(rect.getWidth(), rect.getHeight(), i);
        }
    }

    protected void outputShapesAtNodeLocations() {
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null) continue;
            Point point = this.shapes[i].getCenter();
            this.shapes[i].transform(1.0, this.nodes[i].cx - point.getX(), 1.0, this.nodes[i].cy - point.getY());
            this.connector.addElementShape(this.shapes[i], i, null);
        }
    }

    protected void scaleNodes(Dim dim, Node[] nodeArray, boolean bl) {
        double d;
        Rect rect = (Rect)nodeArray[0].getBounds().copy().expand(1.0E-6);
        Rect rect2 = new Rect(nodeArray[0].cx, nodeArray[0].cy, 1.0E-6, 1.0E-6);
        for (Node node : nodeArray) {
            rect.extendToRect(node.getBounds());
            rect2.extendToPoint(node.cx, node.cy);
        }
        double d2 = dim.getWidth() - (rect.getWidth() - rect2.getWidth());
        double d3 = dim.getHeight() - (rect.getHeight() - rect2.getHeight());
        double d4 = d2 / rect2.getWidth();
        double d5 = d3 / rect2.getHeight();
        if (bl) {
            d4 = d = Math.min(d4, d5);
            d5 = d;
        }
        d = rect2.getX() - rect.getX();
        double d6 = rect2.getY() - rect.getY();
        double d7 = d2 - d4 * rect2.getWidth();
        double d8 = d3 - d5 * rect2.getHeight();
        double d9 = d + d7 / 2.0 - rect2.getX() * d4;
        double d10 = d6 + d8 / 2.0 - rect2.getY() * d5;
        for (Node node : nodeArray) {
            node.placeAt(node.cx * d4 + d9, node.cy * d5 + d10);
        }
    }

    private Edge[] sortBySize(List<Edge> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -list.get((int)i).weight;
        }
        Edge[] edgeArray = new Edge[dArray.length];
        int[] nArray = BasicFactory.makeSortOrder(dArray);
        for (int i = 0; i < nArray.length; ++i) {
            edgeArray[i] = list.get(nArray[i]);
        }
        return edgeArray;
    }
}

