/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.common;

import com.ibm.vis.engine.internal.diagram.graph.common.Edge;
import com.ibm.vis.geom.Rect;

public class Node {
    public int mark;
    public final int index;
    public double cx;
    public double cy;
    public double width;
    public double height;
    private Rect bounds;
    double vx;
    double vy;
    public Edge[] edges;
    public Edge[] outgoing;
    public Edge[] incoming;

    public Node(double d, double d2, int n) {
        this.width = d;
        this.height = d2;
        this.index = n;
        this.mark = -1;
    }

    public void addDirectedEdge(Edge edge) {
        if (this.outgoing == null) {
            this.outgoing = new Edge[]{edge};
        } else {
            Edge[] edgeArray = new Edge[this.outgoing.length + 1];
            for (int i = 0; i < this.outgoing.length; ++i) {
                edgeArray[i] = this.outgoing[i];
            }
            edgeArray[this.outgoing.length] = edge;
            this.outgoing = edgeArray;
        }
    }

    public final void addVelocity(double d, double d2) {
        this.vx += d;
        this.vy += d2;
    }

    public final double area() {
        return this.width * this.height;
    }

    public double distance(Node node) {
        return this.getBounds().distance(node.getBounds());
    }

    public void flip() {
        double d = this.width;
        this.width = this.height;
        this.height = d;
        d = this.cx;
        this.cx = this.cy;
        this.cy = d;
        this.bounds = null;
    }

    public Rect getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rect(this.cx - this.width / 2.0, this.cy - this.height / 2.0, this.width, this.height);
        }
        return this.bounds;
    }

    public final boolean isDummy() {
        return this.index < 0;
    }

    public final double left() {
        return this.cx - this.width / 2.0;
    }

    public double move(double d) {
        double d2 = this.speed();
        double d3 = Math.min(d2, d);
        if (d3 < 1.0) {
            return 0.0;
        }
        this.placeAt(this.cx + d3 * this.vx / d2, this.cy + d3 * this.vy / d2);
        this.vx = 0.0;
        this.vy = 0.0;
        return d3;
    }

    public void placeAt(double d, double d2) {
        this.cx = d;
        this.cy = d2;
        this.bounds = null;
    }

    public void removeDirectedEdge(Edge edge) {
        Edge[] edgeArray = new Edge[this.outgoing.length - 1];
        int n = 0;
        for (Edge edge2 : this.outgoing) {
            if (edge2 == edge) continue;
            edgeArray[n++] = edge2;
        }
        this.outgoing = edgeArray;
    }

    public final double right() {
        return this.cx + this.width / 2.0;
    }

    public final double speed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }
}

