/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.directed;

import com.ibm.vis.engine.internal.diagram.graph.common.Edge;
import com.ibm.vis.engine.internal.diagram.graph.common.Node;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LayerAssignation {
    private final Node[] nodes;
    private final List<Node[]> routing;

    public LayerAssignation(Node[] nodeArray) {
        this.nodes = nodeArray;
        this.routing = new ArrayList<Node[]>();
    }

    public void addDummyNodes(List<List<Node>> list, double d) {
        for (Node node : this.nodes) {
            node.edges = null;
            for (Edge edge : node.outgoing) {
                if (edge.b.mark <= edge.a.mark + 1) continue;
                this.addPathThroughDummies(edge, list, d);
            }
        }
    }

    private void addPathThroughDummies(Edge edge, List<List<Node>> list, double d) {
        Node node;
        Node[] nodeArray = new Node[edge.b.mark - edge.a.mark + 1];
        int n = edge.reversed ? nodeArray.length - 1 : 0;
        int n2 = edge.reversed ? -1 : 1;
        this.routing.add(nodeArray);
        edge.a.removeDirectedEdge(edge);
        nodeArray[n] = node = edge.a;
        n += n2;
        for (int i = edge.a.mark + 1; i < edge.b.mark; ++i) {
            Node node2 = new Node(d, d, -1);
            node2.mark = i;
            list.get(i).add(node2);
            node.addDirectedEdge(new Edge(node, node2, edge.weight, edge.reversed));
            nodeArray[n] = node2;
            n += n2;
            node = node2;
        }
        nodeArray[n] = edge.b;
        node.addDirectedEdge(new Edge(node, edge.b, edge.weight, edge.reversed));
    }

    public List<List<Node>> buildBasicLayering() {
        this.markByOrder();
        this.reverseEdges();
        return this.createRawLayers();
    }

    private List<List<Node>> createRawLayers() {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        Node[] nodeArray = new Node[this.nodes.length];
        Node[] nodeArray2 = this.nodes;
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            Node node;
            nodeArray[node.mark] = node = nodeArray2[i];
            node.mark = -1;
        }
        for (Node node : nodeArray) {
            if (node.mark < 0) {
                node.mark = 0;
            }
            for (Edge edge : node.outgoing) {
                edge.b.mark = Math.max(node.mark + 1, edge.b.mark);
            }
            if (arrayList.size() == node.mark) {
                arrayList.add(new ArrayList());
            }
            ((List)arrayList.get(node.mark)).add(node);
        }
        return arrayList;
    }

    public List<Node[]> getRouting() {
        return this.routing;
    }

    private void markByOrder() {
        int n;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(BasicFactory.asList(this.nodes));
        while (!linkedHashSet.isEmpty()) {
            Node node;
            while ((node = this.removeSource(linkedHashSet)) != null) {
                arrayList.add(node);
            }
            while ((node = this.removeSink(linkedHashSet)) != null) {
                arrayList2.add(0, node);
            }
            node = this.removeMostSourceLike(linkedHashSet);
            if (node == null) continue;
            arrayList.add(node);
        }
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            ((Node)arrayList.get((int)n)).mark = n;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            ((Node)arrayList2.get((int)n)).mark = n + n2;
        }
    }

    private Node removeMostSourceLike(Set<Node> set) {
        Node node = null;
        double d = -1000000.0;
        for (Node node2 : set) {
            double d2 = (double)(-node2.index) / 1000000.0;
            for (Edge edge : node2.edges) {
                if (edge.a.mark < 0 || edge.b.mark < 0) continue;
                if (edge.a == node2) {
                    d2 += 1.0;
                    continue;
                }
                d2 -= 1.0;
            }
            if (!(d2 > d)) continue;
            node = node2;
            d = d2;
        }
        if (node != null) {
            set.remove(node);
        }
        return node;
    }

    private Node removeSink(Set<Node> set) {
        for (Node node : set) {
            boolean bl = true;
            for (Edge edge : node.outgoing) {
                if (edge.b.mark >= 0) continue;
                bl = false;
            }
            if (!bl) continue;
            node.mark = 0;
            set.remove(node);
            return node;
        }
        return null;
    }

    private Node removeSource(Set<Node> set) {
        for (Node node : set) {
            boolean bl = true;
            for (Edge edge : node.edges) {
                if (edge.b != node || edge.a.mark >= 0) continue;
                bl = false;
            }
            if (!bl) continue;
            node.mark = 0;
            set.remove(node);
            return node;
        }
        return null;
    }

    private void reverseEdges() {
        for (Node node : this.nodes) {
            for (Edge edge : node.outgoing) {
                Node node2 = edge.b;
                if (node2.mark >= node.mark) continue;
                node.removeDirectedEdge(edge);
                node2.addDirectedEdge(edge.makeReversed());
            }
        }
    }

    public Node[][] toArrays(List<List<Node>> list) {
        Node[][] nodeArray = new Node[list.size()][];
        for (int i = 0; i < nodeArray.length; ++i) {
            List<Node> list2 = list.get(i);
            nodeArray[i] = list2.toArray(new Node[list2.size()]);
            for (Node node : list2) {
                node.mark = -1;
            }
        }
        return nodeArray;
    }
}

