/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.directed;

import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.internal.diagram.graph.common.Edge;
import com.ibm.vis.engine.internal.diagram.graph.common.GraphDiagram;
import com.ibm.vis.engine.internal.diagram.graph.common.Node;
import com.ibm.vis.engine.internal.diagram.graph.directed.LayerAssignation;
import com.ibm.vis.geom.Dim;
import java.util.List;

public class TreeDiagram
extends GraphDiagram {
    private Node root;
    private Boolean vertical;

    @Override
    public boolean connectsExistingShapes() {
        return false;
    }

    @Override
    public void build(Dim dim) {
        this.transposeWhenHorizontal();
        this.scaleNodes(dim, this.nodes, false);
        this.outputShapesAtNodeLocations();
    }

    @Override
    public Dim calculatePreferredSize() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        double d4 = 1.0;
        for (Node node : this.nodes) {
            d = Math.min(d, node.left());
            d2 = Math.max(d2, node.right());
            d3 = Math.max(d3, node.cy);
            d4 = Math.max(d4, node.height);
        }
        if (this.vertical.booleanValue()) {
            return new Dim((d2 - d) * 1.25, d4 * d3 * 2.5);
        }
        return new Dim(d4 * d3 * 2.5, (d2 - d) * 1.25);
    }

    private Node ensureTree(List<Node> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        Node node = new Node(0.0, 0.0, -1);
        node.outgoing = new Edge[list.size()];
        for (int i = 0; i < node.outgoing.length; ++i) {
            node.outgoing[i] = new Edge(node, list.get(i), 1.0, false);
        }
        return node;
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
        this.vertical = diagramConnector.booleanParameter("vertical", true);
        diagramConnector.putStoredItem("graph-layout-vertical", this.vertical);
        this.transposeWhenHorizontal();
        LayerAssignation layerAssignation = new LayerAssignation(this.nodes);
        List<List<Node>> list = layerAssignation.buildBasicLayering();
        this.root = this.ensureTree(list.get(0));
        for (Node node : this.nodes) {
            node.mark = -1;
        }
        this.invalidateNonTreeEdges(this.root);
        this.place(this.root, 0);
        this.moveForEdgeWeights(this.root, 0.0);
    }

    private void moveForEdgeWeights(Node node, double d) {
        for (Edge edge : node.outgoing) {
            Node node2 = edge.b;
            double d2 = node2.cy - node.cy;
            double d3 = d2 * (edge.weight - 1.0);
            this.moveForEdgeWeights(node2, d + d3);
        }
        node.cy += d;
    }

    private void invalidateNonTreeEdges(Node node) {
        node.mark = 0;
        for (Edge edge : node.outgoing) {
            if (edge.b.mark >= 0) {
                edge.weight = 0.0;
                continue;
            }
            edge.b.mark = 1;
        }
        for (Edge edge : node.outgoing) {
            if (edge.b.mark <= 0) continue;
            this.invalidateNonTreeEdges(edge.b);
        }
    }

    private void moveSubTree(Node node, double d) {
        node.placeAt(node.cx + d, node.cy);
        for (Edge edge : node.outgoing) {
            if (!(edge.weight > 0.0)) continue;
            this.moveSubTree(edge.b, d);
        }
    }

    private void moveToAvoid(Node node, int n, double[][] dArray) {
        double[][] dArrayArray = new double[this.N][];
        this.updateProfile(node, n, dArrayArray);
        double d = 0.0;
        for (int i = n; i < this.N; ++i) {
            if (dArrayArray[i] == null || dArray[i] == null) continue;
            d = Math.max(d, dArray[i][1] - dArrayArray[i][0]);
        }
        if (d > 0.1) {
            this.moveSubTree(node, d);
        }
    }

    private void place(Node node, int n) {
        node.cy = n;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        Object object = null;
        for (Edge edge : node.outgoing) {
            if (edge.weight <= 0.0) continue;
            Node node2 = edge.b;
            this.place(node2, n + 1);
            if (object != null) {
                this.moveToAvoid(node2, n + 1, (double[][])object);
            } else {
                object = new double[this.N][];
            }
            this.updateProfile(node2, n + 1, (double[][])object);
            d = Math.min(d, node2.cx);
            d2 = Math.max(d2, node2.cx);
        }
        if (d > d2) {
            node.cx = 0.0;
        } else {
            node.cx = (d + d2) / 2.0;
            this.moveSubTree(node, -node.cx);
        }
    }

    private void transposeWhenHorizontal() {
        if (this.vertical.booleanValue()) {
            return;
        }
        for (Node node : this.nodes) {
            double d = node.width;
            node.width = node.height;
            node.height = d;
            node.placeAt(node.cy, node.cx);
        }
    }

    private void updateProfile(Node node, int n, double[][] dArray) {
        if (dArray[n] == null) {
            dArray[n] = new double[]{node.left(), node.right()};
        } else {
            dArray[n][0] = Math.min(dArray[n][0], node.left());
            dArray[n][1] = Math.max(dArray[n][1], node.right());
        }
        for (Edge edge : node.outgoing) {
            if (!(edge.weight > 0.0)) continue;
            this.updateProfile(edge.b, n + 1, dArray);
        }
    }
}

