/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.link;

import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;

public abstract class EdgeDiagram
extends Diagram {
    protected double max;
    protected double pad;
    protected Boolean vertical;

    @Override
    public final Dim calculatePreferredSize() {
        return null;
    }

    @Override
    public final boolean connectsExistingShapes() {
        return true;
    }

    protected Point getBoundary(Geom geom, Point point) {
        Point point2 = geom.boundaryPoint(point.getX(), point.getY());
        if (geom.type() == 1002 || geom.type() == 1005) {
            Point point3;
            Rect rect = (Rect)geom;
            Point point4 = null;
            if (this.vertical == null || this.vertical.booleanValue()) {
                point3 = new Point(rect.getCenterX(), rect.getMinY());
                if (point4 == null || point2.distance(point3) < point2.distance(point4)) {
                    point4 = point3;
                }
                point3 = new Point(rect.getCenterX(), rect.getMaxY());
                if (point4 == null || point2.distance(point3) < point2.distance(point4)) {
                    point4 = point3;
                }
            }
            if (this.vertical == null || !this.vertical.booleanValue()) {
                point3 = new Point(rect.getMaxX(), rect.getCenterY());
                if (point4 == null || point2.distance(point3) < point2.distance(point4)) {
                    point4 = point3;
                }
                point3 = new Point(rect.getMinX(), rect.getCenterY());
                if (point4 == null || point2.distance(point3) < point2.distance(point4)) {
                    point4 = point3;
                }
            }
            return point4;
        }
        return point2;
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
        this.max = diagramConnector.numericParameter("max", 50.0).doubleValue();
        this.pad = diagramConnector.numericParameter("pad", 7.0).doubleValue();
        Boolean bl = (Boolean)diagramConnector.getStoredItem("graph-layout-vertical");
        this.vertical = diagramConnector.booleanParameter("vertical", bl);
    }
}

