/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.graph.link;

import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.internal.diagram.graph.link.EdgeDiagram;
import com.ibm.vis.engine.internal.diagram.graph.link.LinkItem;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class LinkDiagram
extends EdgeDiagram {
    private Geom[] shapes;
    double curvature;
    private double startD;
    private double endD;
    private boolean curveToCenter;

    private double asKey(Point point) {
        return point.getY() * 10000.0 + point.getX();
    }

    @Override
    public void build(Dim dim) {
        this.shapes = this.connector.getTargetShapes();
        LinkedHashMap<Double, ArrayList<LinkItem>> linkedHashMap = new LinkedHashMap<Double, ArrayList<LinkItem>>();
        for (int i = 0; i < this.connector.getRowCount(); ++i) {
            Object object = this.connector.row(i);
            if (object[0] == null || object[1] == null) continue;
            int n = object[0].intValue();
            int n2 = object[1].intValue();
            Geom geom = this.shapes[n];
            Geom geom2 = this.shapes[n2];
            if (geom == null || geom2 == null || geom.distanceToGeom(geom2) <= 0.0) continue;
            Point point = geom.getCenter();
            Point point2 = this.getBoundary(geom2, point);
            double d = this.asKey(geom.type() == 1002 || geom.type() == 1005 ? this.getBoundary(geom, point2) : geom.getCenter());
            LinkItem linkItem = new LinkItem(geom, geom2, i, d);
            ArrayList<LinkItem> arrayList = (ArrayList<LinkItem>)linkedHashMap.get(linkItem.key);
            if (arrayList == null) {
                arrayList = new ArrayList<LinkItem>();
                linkedHashMap.put(linkItem.key, arrayList);
            }
            arrayList.add(linkItem);
        }
        for (Object object : linkedHashMap.values()) {
            if (this.curveToCenter) {
                this.makeCenterEdges((List<LinkItem>)object, dim);
                continue;
            }
            this.makeEdges((List<LinkItem>)object);
        }
    }

    private double edgeDistanceFor(LinkItem linkItem) {
        double d = linkItem.start.distanceToGeom(linkItem.end);
        if (this.vertical != null) {
            double d2 = this.vertical != false ? Math.abs(linkItem.start.getCenter().getY() - linkItem.end.getCenter().getY()) : Math.abs(linkItem.start.getCenter().getX() - linkItem.end.getCenter().getX());
            d = Math.min(d, d2);
        }
        return d;
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
        this.curvature = diagramConnector.numericParameter("curvature", 0.5).doubleValue();
        this.startD = diagramConnector.numericParameter("start", 0.2).doubleValue();
        this.endD = diagramConnector.numericParameter("end", 0.4).doubleValue();
        this.curveToCenter = diagramConnector.booleanParameter("curveToCenter", false);
    }

    private void makeEdges(List<LinkItem> list) {
        double d;
        Double d2 = this.midAngle(list);
        if (d2 == null || this.curvature == 0.0) {
            this.makeSimpleEdges(list);
            return;
        }
        if (this.vertical != null) {
            d2 = this.vertical != false ? Double.valueOf(Math.sin(d2) > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Double.valueOf(Math.cos(d2) > 0.0 ? 0.0 : Math.PI);
        }
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = Double.POSITIVE_INFINITY;
        for (LinkItem linkItem : list) {
            d = this.edgeDistanceFor(linkItem);
            if (!(d > 0.0) || !(d < d5)) continue;
            d5 = d;
        }
        double d6 = Math.min(this.max, this.startD * d5);
        d = Math.min(this.max, this.endD * d5);
        double d7 = Math.max(0.0, 1.0 - this.startD - this.endD) * d5 / 2.0;
        d6 += this.curvature * d7;
        d += this.curvature * d7;
        Geom geom = list.get((int)0).start;
        Point point = geom.getCenter();
        Point point2 = new Point(point.getX() + d3 * 1000.0, point.getY() + d4 * 1000.0);
        point = this.getBoundary(geom, point2);
        for (LinkItem linkItem : list) {
            Geom geom2 = this.makeLinkCurve(point, linkItem, d3, d4, d6, d);
            this.connector.addElementShape(geom2, linkItem.row, null);
        }
    }

    private void makeCenterEdges(List<LinkItem> list, Dim dim) {
        double d;
        Point point = new Point(dim.getWidth() / 2.0, dim.getHeight() / 2.0);
        double d2 = Double.POSITIVE_INFINITY;
        for (LinkItem linkItem : list) {
            d = linkItem.start.distanceToPoint(point);
            double d3 = linkItem.start.distanceToPoint(point);
            if (d > 0.0 && d < d2) {
                d2 = d;
            }
            if (!(d3 > 0.0) || !(d3 < d2)) continue;
            d2 = d3;
        }
        double d4 = Math.min(this.max, this.startD * d2);
        d = Math.min(this.max, this.endD * d2);
        Point point2 = this.getBoundary(list.get((int)0).start, point);
        Point point3 = point2.interpolateTo(point, d4 / point2.distance(point));
        for (LinkItem linkItem : list) {
            Point point4 = this.getBoundary(linkItem.end, point);
            Point point5 = point4.interpolateTo(point, d / point4.distance(point));
            Point point6 = point3.interpolateTo(point5, 0.5);
            Point point7 = point6.interpolateTo(point, this.curvature);
            Geom geom = this.makeLink(point2, point3, point7, point5, point4);
            this.connector.addElementShape(geom, linkItem.row, null);
        }
    }

    private Geom makeLinkCurve(Point point, LinkItem linkItem, double d, double d2, double d3, double d4) {
        Point point2 = new Point(point.getX() + d * d3, point.getY() + d2 * d3);
        Point point3 = point2.interpolateTo(point, Math.min(1.0, this.curvature));
        Point point4 = linkItem.end.getCenter();
        Point point5 = new Point(point4.getX() - d * 1000.0, point4.getY() - d2 * 1000.0);
        point4 = this.getBoundary(linkItem.end, point5);
        point5 = new Point(point4.getX() - d * d4, point4.getY() - d2 * d4);
        Point point6 = point5.interpolateTo(point4, Math.min(1.0, this.curvature));
        double d5 = point2.distance(point5);
        Point point7 = point2.interpolateTo(point5, Math.min(0.5, d3 / d5));
        Point point8 = point5.interpolateTo(point2, Math.min(0.5, d4 / d5));
        return this.makeLinkCurveWithControls(point, point3, point2, point7, point8, point5, point6, point4);
    }

    private Geom makeLink(Point point, Point point2, Point point3, Point point4, Point point5) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        arrayList.add(point);
        arrayList2.add(false);
        if (point.distance(point2) > 1.0) {
            arrayList.add(point2);
            arrayList2.add(false);
        }
        arrayList.add(point3);
        arrayList2.add(true);
        if (point5.distance(point4) > 1.0) {
            arrayList.add(point4);
            arrayList2.add(false);
        }
        arrayList.add(point5);
        arrayList2.add(false);
        return this.makeCurve(arrayList, arrayList2);
    }

    private Geom makeCurve(List<Point> list, List<Boolean> list2) {
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[dArray.length];
        boolean[] blArray = new boolean[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i).getX();
            dArray2[i] = list.get(i).getY();
            blArray[i] = list2.get(i);
        }
        return new Curve(dArray, dArray2, blArray, false);
    }

    private Geom makeLinkCurveWithControls(Point point, Point point2, Point point3, Point point4, Point point5, Point point6, Point point7, Point point8) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        arrayList.add(point);
        arrayList2.add(false);
        if (point.distance(point2) > 1.0) {
            arrayList.add(point2);
            arrayList2.add(false);
        }
        if (point2.distance(point3) > 1.0 && point3.distance(point4) > 1.0) {
            arrayList.add(point3);
            arrayList2.add(true);
        }
        if (point.distance(point4) > 1.0) {
            arrayList.add(point4);
            arrayList2.add(false);
        }
        if (point8.distance(point5) > 1.0) {
            arrayList.add(point5);
            arrayList2.add(false);
        }
        if (point7.distance(point6) > 1.0 && point6.distance(point5) > 1.0) {
            arrayList.add(point6);
            arrayList2.add(true);
        }
        if (point8.distance(point7) > 1.0) {
            arrayList.add(point7);
            arrayList2.add(false);
        }
        arrayList.add(point8);
        arrayList2.add(false);
        return this.makeCurve(arrayList, arrayList2);
    }

    private void makeSimpleEdges(List<LinkItem> list) {
        for (LinkItem linkItem : list) {
            Point point = linkItem.start.getCenter();
            Point point2 = linkItem.end.getCenter();
            point2 = this.getBoundary(linkItem.end, point);
            point = this.getBoundary(linkItem.start, point2);
            Poly poly = new Poly(new double[]{point.getX(), point2.getX()}, new double[]{point.getY(), point2.getY()}, false);
            this.connector.addElementShape(poly, linkItem.row, null);
        }
    }

    private Double midAngle(List<LinkItem> list) {
        int n;
        double[] dArray = new double[list.size()];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = list.get(n).angle();
        }
        BasicFactory.sortArray(dArray);
        n = dArray.length - 1;
        if (dArray[n] - dArray[0] > Math.PI) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] < 0.0)) continue;
                int n2 = i;
                dArray[n2] = dArray[n2] + Math.PI * 2;
            }
        }
        BasicFactory.sortArray(dArray);
        if (dArray[n] - dArray[0] > Math.PI) {
            return null;
        }
        return (dArray[0] + dArray[n]) / 2.0;
    }
}

