/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.treemap;

import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.internal.diagram.treemap.TreemapDiagramNode;
import com.ibm.vis.engine.internal.diagram.treemap.TreemapDiagramNodeComparator;
import com.ibm.vis.engine.internal.diagram.treemap.TreemapDiagramNodeDetail;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreemapDiagram
extends Diagram {
    private TreemapDiagramNode root;
    private boolean hierarchical;
    private boolean sort;
    private int treeBranchCounter;

    @Override
    public boolean connectsExistingShapes() {
        return false;
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        String string;
        super.initialize(diagramConnector);
        this.hierarchical = this.connector.booleanParameter("hierarchical", false);
        if (this.hierarchical) {
            if (this.connector.columnCount() != 3) {
                throw new SpecException("Hierarchical treemaps must have exactly three 'data' columns: size, id, and parent", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            }
        } else if (this.connector.columnCount() < 2) {
            throw new SpecException("Non-hierarchical treemaps must have at least two 'data' columns: size, and at least one level", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        boolean bl = !"sliceAndDice".equals(string = this.connector.stringParameter("layout", "squarify")) && !"sliceAndDiceVertical".equals(string);
        this.sort = this.connector.booleanParameter("sort", this.hierarchical || bl);
        this.root = new TreemapDiagramNode(Double.NaN);
        if (this.hierarchical) {
            this.assembleTreeAsHierarchical();
        } else {
            this.assembleTreeForFields();
        }
        this.initializeTree(this.root, -1);
    }

    @Override
    public Dim calculatePreferredSize() {
        int n = this.root.containedLeafNodes();
        return new Dim(60.0 * Math.sqrt(n), 45.0 * Math.sqrt(n));
    }

    @Override
    public void build(Dim dim) {
        this.placeRecursively(this.root, Rect.makeRectFromDim(dim));
        this.treeBranchCounter = 0;
        this.outputShapes(this.root);
        this.outputNonElementLabels(this.root);
    }

    private void placeRecursively(TreemapDiagramNode treemapDiagramNode, Rect rect) {
        rect = this.connector.applyInsets(rect, treemapDiagramNode.isElement(), treemapDiagramNode.styleNames(""));
        Rect rect2 = this.connector.applyInsets(rect, false, treemapDiagramNode.styleNames("_inner"));
        Rect rect3 = this.makeLabelBox(rect, rect2);
        treemapDiagramNode.temp = new TreemapDiagramNodeDetail(rect, rect2, rect3);
        if (treemapDiagramNode.children.isEmpty()) {
            return;
        }
        String string = this.connector.stringParameter("layout", null);
        if ("sliceAndDiceVertical".equals(string)) {
            this.sliceAndDice(rect2, treemapDiagramNode, true);
        } else if ("sliceAndDice".equals(string)) {
            this.sliceAndDice(rect2, treemapDiagramNode, false);
        } else {
            this.squarify(rect2, treemapDiagramNode.totalWeight(), treemapDiagramNode.children, 0);
        }
    }

    private void sliceAndDice(Rect rect, TreemapDiagramNode treemapDiagramNode, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = treemapDiagramNode.level % 2 == 0;
        if (bl) {
            bl2 = !bl2;
        }
        double d = 0.0;
        for (TreemapDiagramNode treemapDiagramNode2 : treemapDiagramNode.children) {
            Rect rect2 = this.slice(rect, bl2, d, treemapDiagramNode2.totalWeight(), treemapDiagramNode.totalWeight());
            this.placeRecursively(treemapDiagramNode2, rect2);
            d += treemapDiagramNode2.totalWeight();
        }
    }

    private void squarify(Rect rect, double d, List<TreemapDiagramNode> list, int n) {
        Rect[] rectArray;
        double d2;
        boolean bl = rect.getWidth() >= rect.getHeight();
        Rect[] rectArray2 = null;
        double d3 = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= list.size() - n && (d2 = this.worstAspect(rectArray = this.placeStripe(rect, d, list, n, i, bl))) < d3; ++i) {
            rectArray2 = rectArray;
            d3 = d2;
        }
        double d4 = 0.0;
        for (int i = 0; i < rectArray2.length; ++i) {
            TreemapDiagramNode treemapDiagramNode = list.get(n + i);
            this.placeRecursively(treemapDiagramNode, rectArray2[i]);
            d4 += treemapDiagramNode.totalWeight();
        }
        if (n + rectArray2.length == list.size()) {
            return;
        }
        Rect rect2 = this.slice(rect, bl, d4, d - d4, d);
        this.squarify(rect2, d - d4, list, n + rectArray2.length);
    }

    private Rect[] placeStripe(Rect rect, double d, List<TreemapDiagramNode> list, int n, int n2, boolean bl) {
        d = Math.max(d, 1.0E-9);
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d2 += list.get(n + i).totalWeight();
        }
        d2 = Math.max(d2, 1.0E-9);
        Rect rect2 = this.slice(rect, bl, 0.0, d2, d);
        Rect[] rectArray = new Rect[n2];
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = list.get(n + i).totalWeight();
            rectArray[i] = this.slice(rect2, !bl, d3, d4, d2);
            d3 += d4;
        }
        return rectArray;
    }

    private double worstAspect(Rect[] rectArray) {
        double d = 1.0;
        for (Rect rect : rectArray) {
            if (!(rect.area() > 1.0)) continue;
            d = Math.max(d, rect.getHeight() / rect.getWidth());
            d = Math.max(d, rect.getWidth() / rect.getHeight());
        }
        return d;
    }

    private void outputShapes(TreemapDiagramNode treemapDiagramNode) {
        if (treemapDiagramNode != this.root) {
            TreemapDiagramNodeDetail treemapDiagramNodeDetail = (TreemapDiagramNodeDetail)treemapDiagramNode.temp;
            if (treemapDiagramNode.rows.isEmpty()) {
                ShapeInfo object = this.connector.addNonElementShape(treemapDiagramNodeDetail.outer, treemapDiagramNode.styleNames(""));
                if (!treemapDiagramNode.structuralRows.isEmpty()) {
                    ((Shape)object).setStructuralRows(treemapDiagramNode.structuralRows.toArray(new int[treemapDiagramNode.structuralRows.size()]));
                }
            } else {
                ShapeInfo shapeInfo = this.connector.addElementShape(treemapDiagramNodeDetail.outer, treemapDiagramNode.rows.get(0), treemapDiagramNode.styleNames(""));
                String string = Integer.toString(this.treeBranchCounter);
                shapeInfo.setKey(string);
                ((Shape)shapeInfo).setRows(treemapDiagramNode.rows.toArray(new int[treemapDiagramNode.rows.size()]));
                if (!treemapDiagramNode.structuralRows.isEmpty()) {
                    ((Shape)shapeInfo).setStructuralRows(treemapDiagramNode.structuralRows.toArray(new int[treemapDiagramNode.structuralRows.size()]));
                }
            }
        }
        for (TreemapDiagramNode treemapDiagramNode2 : treemapDiagramNode.children) {
            this.outputShapes(treemapDiagramNode2);
            if (treemapDiagramNode2.children.size() <= 0) continue;
            ++this.treeBranchCounter;
        }
    }

    private void outputNonElementLabels(TreemapDiagramNode treemapDiagramNode) {
        if (treemapDiagramNode != this.root) {
            String[] stringArray;
            TreemapDiagramNodeDetail treemapDiagramNodeDetail = (TreemapDiagramNodeDetail)treemapDiagramNode.temp;
            if (treemapDiagramNode.rows.isEmpty() && this.connector.targetStyleExists(stringArray = treemapDiagramNode.styleNames("_label"))) {
                int n = this.hierarchical ? 1 : 1 + treemapDiagramNode.level;
                String string = this.connector.getDataLabel(treemapDiagramNode.id, n);
                this.connector.addNonElementLabel(string, treemapDiagramNodeDetail.label, stringArray);
            }
        }
        for (TreemapDiagramNode treemapDiagramNode2 : treemapDiagramNode.children) {
            this.outputNonElementLabels(treemapDiagramNode2);
        }
    }

    private void assembleTreeForFields() {
        this.root.temp = new LinkedHashMap();
        for (int i = 0; i < this.connector.getRowCount(); ++i) {
            Double[] doubleArray = this.connector.row(i);
            TreemapDiagramNode treemapDiagramNode = this.addFieldsRow(doubleArray);
            this.setWeightAndRow(i, doubleArray, treemapDiagramNode);
        }
        this.setStructuralRows(this.root);
    }

    private void assembleTreeAsHierarchical() {
        TreemapDiagramNode treemapDiagramNode;
        LinkedHashMap<String, TreemapDiagramNode> linkedHashMap = new LinkedHashMap<String, TreemapDiagramNode>();
        for (int i = 0; i < this.connector.getRowCount(); ++i) {
            Double[] doubleArray = this.connector.row(i);
            if (doubleArray[1] == null) continue;
            treemapDiagramNode = new TreemapDiagramNode(doubleArray[1]);
            this.setWeightAndRow(i, doubleArray, treemapDiagramNode);
            treemapDiagramNode.temp = this.connector.getDataLabel(doubleArray[2], 2);
            linkedHashMap.put(this.connector.getDataLabel(doubleArray[1], 1), treemapDiagramNode);
        }
        for (Double[] doubleArray : linkedHashMap.values()) {
            treemapDiagramNode = (TreemapDiagramNode)linkedHashMap.get(doubleArray.temp);
            if (treemapDiagramNode == null) {
                treemapDiagramNode = this.root;
            }
            treemapDiagramNode.children.add((TreemapDiagramNode)doubleArray);
        }
        this.setStructuralRows(this.root);
    }

    private void setWeightAndRow(int n, Double[] doubleArray, TreemapDiagramNode treemapDiagramNode) {
        if (treemapDiagramNode != null) {
            treemapDiagramNode.rows.add(n);
            if (doubleArray[0] != null) {
                treemapDiagramNode.nodeOnlyWeight += doubleArray[0].doubleValue();
            }
        }
    }

    private void setStructuralRows(TreemapDiagramNode treemapDiagramNode) {
        for (TreemapDiagramNode treemapDiagramNode2 : treemapDiagramNode.children) {
            this.setStructuralRows(treemapDiagramNode2);
            treemapDiagramNode.structuralRows.addAll(treemapDiagramNode2.rows);
            treemapDiagramNode.structuralRows.addAll(treemapDiagramNode2.structuralRows);
        }
    }

    private double initializeTree(TreemapDiagramNode treemapDiagramNode, int n) {
        for (TreemapDiagramNode treemapDiagramNode2 : treemapDiagramNode.children) {
            treemapDiagramNode.childWeight += this.initializeTree(treemapDiagramNode2, n + 1);
        }
        BasicFactory.sortList(treemapDiagramNode.children, new TreemapDiagramNodeComparator(this.sort));
        treemapDiagramNode.level = n;
        treemapDiagramNode.temp = null;
        return treemapDiagramNode.totalWeight();
    }

    private TreemapDiagramNode addFieldsRow(Double[] doubleArray) {
        TreemapDiagramNode treemapDiagramNode = this.root;
        for (int i = 1; i < doubleArray.length; ++i) {
            Map map = (Map)treemapDiagramNode.temp;
            TreemapDiagramNode treemapDiagramNode2 = (TreemapDiagramNode)map.get(doubleArray[i]);
            if (treemapDiagramNode2 == null) {
                treemapDiagramNode2 = new TreemapDiagramNode(doubleArray[i]);
                treemapDiagramNode.children.add(treemapDiagramNode2);
                treemapDiagramNode2.temp = new LinkedHashMap();
                map.put(doubleArray[i], treemapDiagramNode2);
            }
            treemapDiagramNode = treemapDiagramNode2;
        }
        return treemapDiagramNode;
    }

    private Rect makeLabelBox(Rect rect, Rect rect2) {
        Rect rect3 = rect.copy();
        rect3.setHeight(rect2.getY() - rect.getY());
        Rect rect4 = rect.copy();
        rect4.setHeight(rect.getMaxY() - rect2.getMaxY());
        rect4.setY(rect2.getMaxY());
        Rect rect5 = rect.copy();
        rect5.setWidth(rect2.getX() - rect.getX());
        Rect rect6 = rect.copy();
        rect6.setWidth(rect.getMaxX() - rect2.getMaxX());
        rect6.setX(rect2.getMaxX());
        Rect rect7 = rect3;
        if (rect4.area() > rect7.area()) {
            rect7 = rect4;
        }
        if (rect5.area() > rect7.area()) {
            rect7 = rect5;
        }
        if (rect6.area() > rect7.area()) {
            rect7 = rect6;
        }
        if (rect7.getExtent().getMin() < 10.0) {
            return rect;
        }
        return rect7;
    }

    private Rect slice(Rect rect, boolean bl, double d, double d2, double d3) {
        double d4 = d / d3;
        double d5 = d2 / d3;
        if (bl) {
            return new Rect(rect.getX() + d4 * rect.getWidth(), rect.getY(), d5 * rect.getWidth(), rect.getHeight());
        }
        return new Rect(rect.getX(), rect.getY() + d4 * rect.getHeight(), rect.getWidth(), d5 * rect.getHeight());
    }
}

