/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.treemap;

import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import java.util.ArrayList;
import java.util.List;

public class TreemapDiagramNode {
    public final double id;
    public final List<TreemapDiagramNode> children;
    public final IntPrimitiveArrayList rows;
    public final IntPrimitiveArrayList structuralRows;
    public int level;
    public double nodeOnlyWeight;
    public double childWeight;
    public Object temp;

    public TreemapDiagramNode(double d) {
        this.id = d;
        this.children = new ArrayList<TreemapDiagramNode>();
        this.rows = new IntPrimitiveArrayList();
        this.structuralRows = new IntPrimitiveArrayList();
        this.nodeOnlyWeight = 0.0;
        this.childWeight = 0.0;
    }

    public String[] styleNames(String string) {
        if (this.children.isEmpty()) {
            return new String[]{"level_leaf" + string, "level_" + this.level + string};
        }
        return new String[]{"level_" + this.level + string, "level_inner" + string};
    }

    public double totalWeight() {
        return this.nodeOnlyWeight + this.childWeight;
    }

    public boolean isElement() {
        return !this.rows.isEmpty();
    }

    public int containedLeafNodes() {
        if (this.children.isEmpty()) {
            return 1;
        }
        int n = 0;
        for (TreemapDiagramNode treemapDiagramNode : this.children) {
            n += treemapDiagramNode.containedLeafNodes();
        }
        return n;
    }
}

