/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.wordcloud;

public class Base64Encoding {
    private static final char[] map64toChar;
    private static final byte[] mapCharTo64;

    public static final String encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = Math.round((n * 4 + 2) / 3);
        int n3 = Math.round((n + 2) / 3 * 4);
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0 + n;
        int n6 = 0;
        while (n4 < n5) {
            int n7 = byArray[n4++] & 0xFF;
            int n8 = n4 < n5 ? byArray[n4++] & 0xFF : 0;
            int n9 = n4 < n5 ? byArray[n4++] & 0xFF : 0;
            int n10 = n7 >>> 2;
            int n11 = (n7 & 3) << 4 | n8 >>> 4;
            int n12 = (n8 & 0xF) << 2 | n9 >>> 6;
            int n13 = n9 & 0x3F;
            cArray[n6++] = map64toChar[n10];
            cArray[n6++] = map64toChar[n11];
            cArray[n6] = n6 < n2 ? map64toChar[n12] : 61;
            int n14 = ++n6 < n2 ? map64toChar[n13] : 61;
            cArray[n6] = n14;
            ++n6;
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (n > 0 && cArray[0 + n - 1] == '=') {
            --n;
        }
        int n2 = Math.round(n * 3 / 4);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0 + n;
        int n5 = 0;
        while (n3 < n4) {
            int n6;
            char c = cArray[n3++];
            char c2 = cArray[n3++];
            int n7 = n3 < n4 ? cArray[n3++] : 65;
            int n8 = n6 = n3 < n4 ? cArray[n3++] : 65;
            if (c > '\u007f' || c2 > '\u007f' || n7 > 127 || n6 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte by = mapCharTo64[c];
            byte by2 = mapCharTo64[c2];
            byte by3 = mapCharTo64[n7];
            byte by4 = mapCharTo64[n6];
            if (by < 0 || by2 < 0 || by3 < 0 || by4 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int n9 = by << 2 | by2 >>> 4;
            int n10 = (by2 & 0xF) << 4 | by3 >>> 2;
            int n11 = (by3 & 3) << 6 | by4;
            byArray[n5++] = (byte)n9;
            if (n5 < n2) {
                byArray[n5++] = (byte)n10;
            }
            if (n5 >= n2) continue;
            byArray[n5++] = (byte)n11;
        }
        return byArray;
    }

    static {
        int n;
        map64toChar = new char[64];
        mapCharTo64 = new byte[128];
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            Base64Encoding.map64toChar[n2++] = n;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            Base64Encoding.map64toChar[n2++] = n;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            Base64Encoding.map64toChar[n2++] = n;
        }
        Base64Encoding.map64toChar[n2++] = 43;
        Base64Encoding.map64toChar[n2++] = 47;
        for (n = 0; n < mapCharTo64.length; ++n) {
            Base64Encoding.mapCharTo64[n] = -1;
        }
        for (n = 0; n < 64; ++n) {
            Base64Encoding.mapCharTo64[Base64Encoding.map64toChar[n]] = (byte)n;
        }
    }
}

