/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.wordcloud;

import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.diagramService.TextGeom;
import com.ibm.vis.engine.internal.diagram.wordcloud.WordCover;
import com.ibm.vis.engine.internal.diagram.wordcloud.WordMetricInfo;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;

public class WordCloudDiagram
extends Diagram {
    private WordCover[] wordCover;
    private int[] order;
    private double delta;
    private double quality;
    private WordMetricInfo metrics;
    private static final String MIXEDORTHOGONAL_90 = "mixedOrthogonal90";
    private static final String MIXEDORTHOGONAL_MINUS90 = "mixedOrthogonal-90";
    private Geom[] shapes;

    @Override
    public void build(Dim dim) {
        double d = dim.getWidth() / 2.0;
        double d2 = dim.getHeight() / 2.0;
        double d3 = Math.max(dim.getWidth(), dim.getHeight());
        double d4 = this.delta * dim.getWidth() / d3;
        double d5 = this.delta * dim.getHeight() / d3;
        double d6 = 0.0;
        double d7 = Double.POSITIVE_INFINITY;
        Rect rect = null;
        TextGeom[] textGeomArray = new TextGeom[this.order.length];
        for (int n : this.order) {
            WordCover wordCover = this.wordCover[n];
            if (wordCover == null) continue;
            if (wordCover.area() <= d7) {
                d7 = wordCover.area() * this.quality;
                d6 = 0.0;
            }
            d6 = this.place(wordCover, d, d2, d4, d5, d6);
            Rect rect2 = wordCover.getBounds();
            if (rect == null) {
                rect = rect2.copy();
            } else {
                rect.extendToRect(rect2);
            }
            textGeomArray[n] = wordCover.makeTextGeom();
        }
        if (textGeomArray.length > 0 && rect != null) {
            this.scaleToFit(textGeomArray, dim, rect);
        }
        for (int n : this.order) {
            this.connector.addElementShape(textGeomArray[n], n, null);
        }
    }

    private void scaleToFit(TextGeom[] textGeomArray, Dim dim, Rect rect) {
        double d = Math.min(dim.getWidth() / rect.getWidth(), dim.getHeight() / rect.getHeight());
        double d2 = -d * rect.getX() + (dim.getWidth() - rect.getWidth() * d) / 2.0;
        double d3 = -d * rect.getY() + (dim.getHeight() - rect.getHeight() * d) / 2.0;
        for (int n : this.order) {
            if (textGeomArray[n] == null) continue;
            textGeomArray[n].transform(d, d2, d, d3);
        }
    }

    @Override
    public Dim calculatePreferredSize() {
        if (this.wordCover.length <= 50) {
            this.build(new Dim(10000.0, 10000.0));
            Rect rect = new Rect(0.0, 0.0, 0.0, 0.0);
            boolean bl = true;
            for (WordCover wordCover : this.wordCover) {
                if (wordCover == null) continue;
                if (bl) {
                    rect.setHeight(wordCover.getBounds().getHeight());
                    rect.setWidth(wordCover.getBounds().getWidth());
                    rect.setX(wordCover.getBounds().getX());
                    rect.setY(wordCover.getBounds().getY());
                    bl = false;
                    continue;
                }
                rect.extendToRect(wordCover.getBounds());
            }
            double d = rect.getWidth() * 0.2;
            double d2 = rect.getHeight() * 0.2;
            double d3 = (rect.getWidth() + d) * (rect.getHeight() + d2);
            double d4 = Math.sqrt(d3);
            double d5 = d4 * 0.1;
            return new Dim(d4 + d5, d4);
        }
        double d = 0.0;
        for (WordCover wordCover : this.wordCover) {
            if (wordCover == null) continue;
            d += wordCover.area();
        }
        double d6 = Math.sqrt(1.8 * d);
        double d7 = d6 * 0.1;
        return new Dim(d6 + d7, d6);
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
        this.shapes = diagramConnector.makeUnplacedShapes();
        this.delta = diagramConnector.numericParameter("delta", 2.5).doubleValue();
        if (this.delta < 0.5) {
            this.delta = 0.5;
        }
        if (this.delta > 100.0) {
            this.delta = 100.0;
        }
        this.quality = diagramConnector.numericParameter("quality", 0.75).doubleValue();
        String string = diagramConnector.stringParameter("orientation", "horizontal");
        double d = diagramConnector.numericParameter("pad", 2.0).doubleValue();
        String string2 = diagramConnector.stringParameter("font", null);
        this.metrics = new WordMetricInfo(string2, d);
        this.wordCover = new WordCover[this.shapes.length];
        double[] dArray = new double[this.shapes.length];
        for (int i = 0; i < this.shapes.length; ++i) {
            TextGeom textGeom;
            String string3;
            this.wordCover[i] = null;
            dArray[i] = 0.0;
            if (!(this.shapes[i] instanceof TextGeom) || BasicFactory.isWhitespaceString(string3 = (textGeom = (TextGeom)this.shapes[i]).getText())) continue;
            this.wordCover[i] = this.metrics.makeCover(string3, textGeom.getX(), textGeom.getY(), textGeom.getWidth());
            dArray[i] = -this.wordCover[i].area();
        }
        this.order = BasicFactory.makeSortOrder(dArray);
        if (string.equals(MIXEDORTHOGONAL_90)) {
            for (int n : this.order) {
                if (this.wordCover[n] == null || n % 2 <= 0) continue;
                this.wordCover[n].rotate(90);
            }
        }
        if (string.equals(MIXEDORTHOGONAL_MINUS90)) {
            for (int n : this.order) {
                if (this.wordCover[n] == null || n % 2 <= 0) continue;
                this.wordCover[n].rotate(-90);
            }
        }
    }

    private WordCover intersectsPlaced(WordCover wordCover, WordCover wordCover2) {
        if (wordCover2 != null && wordCover.intersects(wordCover2)) {
            return wordCover2;
        }
        for (int n : this.order) {
            WordCover wordCover3 = this.wordCover[n];
            if (wordCover3 == null || wordCover3 == wordCover2) continue;
            if (wordCover == wordCover3) {
                return null;
            }
            if (!wordCover.intersects(wordCover3)) continue;
            return wordCover3;
        }
        return null;
    }

    private double place(WordCover wordCover, double d, double d2, double d3, double d4, double d5) {
        WordCover wordCover2 = null;
        do {
            double d6 = Math.cos(d5) * d5 * d3;
            double d7 = Math.sin(d5) * d5 * d4;
            wordCover.placeAt(d6 + d, d7 + d2);
            wordCover2 = this.intersectsPlaced(wordCover, wordCover2);
            d5 += this.delta / Math.max(this.delta, Math.sqrt(d6 * d6 + d7 * d7));
        } while (wordCover2 != null);
        return d5;
    }

    @Override
    public boolean connectsExistingShapes() {
        return false;
    }
}

