/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.wordcloud;

import com.ibm.vis.engine.diagramService.TextGeom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.List;

public class WordCover {
    private final Rect[] covers;
    private Rect bounds;
    private final double dy;
    private final String text;
    private int rotation = 0;

    WordCover(String string, List<Rect> list, double d) {
        this.text = string;
        this.dy = d;
        if (list.size() == 0) {
            this.covers = new Rect[]{new Rect(0.0, 0.0, 1.0, 1.0)};
        } else {
            this.covers = new Rect[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.covers[i] = list.get(i);
            }
        }
        this.calculateBounds();
    }

    private void calculateBounds() {
        this.bounds = this.covers[0].copy();
        for (Rect rect : this.covers) {
            this.bounds.extendToRect(rect);
        }
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public double area() {
        return this.bounds.area();
    }

    public Rect[] getCover() {
        return this.covers;
    }

    public boolean intersects(WordCover wordCover) {
        if (!this.bounds.intersectsRect(wordCover.bounds)) {
            return false;
        }
        for (Rect rect : this.covers) {
            if (!rect.intersectsRect(wordCover.bounds)) continue;
            for (Rect rect2 : wordCover.covers) {
                if (!rect.intersectsRect(rect2)) continue;
                return true;
            }
        }
        return false;
    }

    public TextGeom makeTextGeom() {
        return new TextGeom(this.bounds.getX(), this.bounds.getY() - this.dy / 2.0, this.bounds.getWidth(), this.bounds.getHeight() + this.dy / 2.0, this.text, this.rotation);
    }

    public void placeAt(double d, double d2) {
        Point point = this.bounds.getCenter();
        double d3 = d - point.getX();
        double d4 = d2 - point.getY();
        this.bounds.setX(this.bounds.getX() + d3);
        this.bounds.setY(this.bounds.getY() + d4);
        for (Rect rect : this.covers) {
            rect.setX(rect.getX() + d3);
            rect.setY(rect.getY() + d4);
        }
    }

    public void rotate(int n) {
        Point point = this.bounds.getCenter();
        for (Rect rect : this.covers) {
            double d = rect.getWidth();
            double d2 = rect.getHeight();
            double d3 = rect.getCenterX() - point.getX();
            double d4 = rect.getCenterY() - point.getY();
            this.rotation = n;
            if (this.rotation < 0) {
                rect.setX(point.getX() + d4 - d2 / 2.0);
                rect.setY(point.getY() - d3 - d / 2.0);
            } else {
                rect.setX(point.getX() - d4 - d2 / 2.0);
                rect.setY(point.getY() + d3 - d / 2.0);
            }
            rect.setWidth(d2);
            rect.setHeight(d);
        }
        this.calculateBounds();
    }
}

