/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.diagram.wordcloud;

import com.ibm.vis.engine.internal.diagram.wordcloud.Base64Encoding;
import com.ibm.vis.engine.internal.diagram.wordcloud.WordCover;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WordMetricInfo {
    public static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890,./;:'\"()!@#$%^&*()_-+=|\\[]{}";
    public static final int FONT_SIZE = 16;
    public final String fontName;
    public final int dx;
    public final int dy;
    public final Map<Character, Rect[]> cover;
    private final double pad;
    private final int spaceWidth;

    public WordMetricInfo(String string, double d) {
        this.pad = d;
        int n = string.indexOf("|");
        this.fontName = string.substring(0, n);
        byte[] byArray = Base64Encoding.decode(string.substring(n + 1));
        this.dx = byArray[0];
        this.dy = byArray[1];
        this.cover = new HashMap<Character, Rect[]>();
        int n2 = 2;
        for (char c : CHARACTERS.toCharArray()) {
            int n3 = byArray[n2++] & 0xFF;
            Rect[] rectArray = new Rect[n3];
            for (int i = 0; i < n3; ++i) {
                int n4 = byArray[n2++] & 0xFF;
                int n5 = byArray[n2++] & 0xFF;
                rectArray[i] = new Rect(n4 % 16, n4 / 16, n5 % 16, n5 / 16);
            }
            this.cover.put(Character.valueOf(c), rectArray);
        }
        this.spaceWidth = this.width(this.getCharacterCover('i'));
    }

    private Rect[] getCharacterCover(char c) {
        Rect[] rectArray = this.cover.get(Character.valueOf(c));
        if (rectArray == null) {
            rectArray = this.cover.get(Character.valueOf('-'));
        }
        return rectArray;
    }

    public final WordCover makeCover(String string, double d, double d2, double d3) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        int n = 0;
        for (char c : string.toCharArray()) {
            n += BasicFactory.isWhitespace(c) ? this.spaceWidth : this.width(this.getCharacterCover(c));
        }
        assert (n > 0);
        double d4 = d3 / (double)n;
        double d5 = d - (double)this.dx * d4;
        double d6 = d2 - (double)this.dy * d4;
        ArrayList<Rect> arrayList = new ArrayList<Rect>();
        for (char c : string.toCharArray()) {
            if (BasicFactory.isWhitespace(c)) {
                d5 += d4 * (double)this.spaceWidth;
                continue;
            }
            Rect[] rectArray = this.getCharacterCover(c);
            double d7 = this.width(rectArray);
            for (Rect rect : rectArray) {
                Rect rect2 = new Rect(rect.getX() * d4 + d5, rect.getY() * d4 + d6, rect.getWidth() * d4, rect.getHeight() * d4);
                arrayList.add((Rect)rect2.expand(this.pad));
            }
            d5 += d4 * d7;
        }
        double d8 = arrayList.size() == 0 ? 0.0 : this.maxY(arrayList) - d2;
        return new WordCover(string, arrayList, d8);
    }

    private double maxY(List<Rect> list) {
        double d = 0.0;
        for (Rect rect : list) {
            d = Math.max(d, rect.getMaxY());
        }
        return d;
    }

    public int width(Rect[] rectArray) {
        int n = 200;
        int n2 = -200;
        for (Rect rect : rectArray) {
            n = Math.min(n, (int)rect.getMinX());
            n2 = Math.max(n2, (int)rect.getMaxX());
        }
        return n2 - n;
    }
}

