/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.extension;

import com.ibm.vis.engine.internal.extension.RAVEExtension;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class RAVEExtensionFactory<T extends RAVEExtension> {
    public final List<String> getExtensionsSupported() {
        List<String> list = this.getExtensionNames();
        return new ArrayList<String>(list);
    }

    protected abstract List<String> getExtensionNames();

    public final boolean supportsExtension(String string) {
        List<String> list = this.getExtensionNames();
        return list.contains(string);
    }

    public final T createExtension(String string) {
        T t = this.makeExtension(string);
        if (t == null) {
            return this.nullIfExtensionSupported(string);
        }
        return t;
    }

    protected abstract T makeExtension(String var1);

    private T nullIfExtensionSupported(String string) {
        if (!this.supportsExtension(string)) {
            throw new EngineException("Extension Point '" + string + " not supported", ErrorCode.EXTENSION_NOT_SUPPORTED, null);
        }
        return null;
    }
}

