/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.extension;

import com.ibm.vis.engine.internal.extension.ExtensionFactory;
import com.ibm.vis.engine.internal.extension.ExtensionFactoryList;
import com.ibm.vis.engine.internal.extension.ExtensionManager;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RAVEExtensionManager
implements ExtensionManager,
ExtensionFactory {
    public static final RAVEExtensionManager INSTANCE = new RAVEExtensionManager();
    private final ExtensionFactoryList defaultExtensions;
    private final ExtensionFactoryList userExtensions = new ExtensionFactoryList();
    private final ExtensionFactoryList fallbackExtensions;

    RAVEExtensionManager() {
        this.defaultExtensions = new ExtensionFactoryList();
        this.fallbackExtensions = new ExtensionFactoryList();
    }

    public synchronized void registerDefaultFactory(ExtensionFactory extensionFactory) {
        assert (extensionFactory != null);
        this.defaultExtensions.add(extensionFactory);
    }

    @Override
    public synchronized void registerUserFactory(ExtensionFactory extensionFactory) {
        assert (extensionFactory != null);
        this.userExtensions.add(extensionFactory);
    }

    @Override
    public synchronized void registerFallbackFactory(ExtensionFactory extensionFactory) {
        assert (extensionFactory != null);
        this.fallbackExtensions.add(extensionFactory);
    }

    @Override
    public synchronized Object newInstance(String string, Object object) {
        assert (string != null);
        Object object2 = this.defaultExtensions.newInstance(string, object);
        if (object2 == null && string.indexOf(".") > 0 && (object2 = this.userExtensions.newInstance(string, object)) == null) {
            object2 = this.fallbackExtensions.newInstance(string, object);
        }
        return object2;
    }

    public void unregisterAllFactories() {
        this.userExtensions.removeAllFactories();
        this.defaultExtensions.removeAllFactories();
        this.fallbackExtensions.removeAllFactories();
    }
}

