/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.facet.CellElementContents;
import com.ibm.vis.engine.internal.facet.Compose;
import com.ibm.vis.engine.internal.facet.FacetAxisInfo;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.facet.Faceting;
import com.ibm.vis.engine.internal.facet.GenerateOuter;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.AbstractMappedJSONObject;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractFaceting
implements Faceting {
    private static final String FACET_META = "facet";
    private static final String KEY_SEPARATOR = "|";
    protected final FacetSpec facetSpec;
    protected FacetField[] facetFields;
    protected Set<Integer> facetElements;
    private Map<String, Rect> keyToBounds;
    private List<SceneNode> generatedScene;

    public AbstractFaceting(FacetSpec facetSpec, FacetField[] facetFieldArray) {
        this.facetSpec = facetSpec;
        this.facetFields = facetFieldArray;
        this.keyToBounds = null;
        this.generatedScene = null;
    }

    @Override
    public final FacetSpec getFacetSpec() {
        return this.facetSpec;
    }

    public final FacetField[] getFacetFields() {
        return this.facetFields;
    }

    protected final void setFacetLayout(Map<String, Rect> map) {
        this.keyToBounds = map;
    }

    protected Map<String, Rect> getFacetLayout() {
        return this.keyToBounds;
    }

    protected final void setGeneratedScene(List<SceneNode> list) {
        this.generatedScene = list;
    }

    private void addGeneratedScene(List<SceneNode> list) {
        if (this.generatedScene != null) {
            this.updateFacetRowNumbers(this.generatedScene, null);
            list.addAll(this.generatedScene);
        }
    }

    private DataSpec getFacetData(DataSpec[] dataSpecArray) {
        int n = dataSpecArray.length;
        if (n == 1) {
            return dataSpecArray[0];
        }
        String string = this.facetFields[0].getField().data.id;
        for (int i = 0; i < n; ++i) {
            DataSpec dataSpec = dataSpecArray[i];
            String string2 = dataSpec.id;
            if (string != null && string.equals(string2)) {
                return dataSpec;
            }
            if (string != null || string2 != null) continue;
            for (FieldSpec fieldSpec : dataSpec.fields) {
                if (!fieldSpec.id.equals(this.facetFields[0].getField().id)) continue;
                return dataSpec;
            }
        }
        throw new EngineException("Facet data source is invalid.", ErrorCode.ENGINE_FACET_INVALID_DATA_SOURCE, null);
    }

    private static DataSpec getSourceData(DataSpec dataSpec, DataSpec[] dataSpecArray) {
        String string = dataSpec.source.$ref;
        for (DataSpec dataSpec2 : dataSpecArray) {
            String string2 = dataSpec2.id;
            if (string == null || !string.equals(string2)) continue;
            return dataSpec2;
        }
        return dataSpec;
    }

    private static double[][] subset(double[][] dArray, IntPrimitiveArrayList intPrimitiveArrayList) {
        int n = intPrimitiveArrayList.size();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = dArray[intPrimitiveArrayList.get(i)];
        }
        return dArrayArray;
    }

    private void updateFacetRowNumbers(List<SceneNode> list, IntPrimitiveArrayList intPrimitiveArrayList) {
        for (int i = 0; i < list.size(); ++i) {
            SceneNode sceneNode = list.get(i);
            if (intPrimitiveArrayList != null) {
                Shape shape;
                int[] nArray;
                int n = intPrimitiveArrayList.size();
                if (this.isFacetData(sceneNode) && (nArray = (shape = (Shape)sceneNode.getShape()).getRows()) != null) {
                    int n2 = nArray.length;
                    for (int j = 0; j < n2; ++j) {
                        int n3 = nArray[j];
                        if (n3 >= n) continue;
                        nArray[j] = intPrimitiveArrayList.get(n3);
                    }
                }
            } else {
                Shape shape = (Shape)sceneNode.getShape();
                if (shape != null) {
                    shape.setRows(null);
                }
            }
            this.updateFacetRowNumbers(sceneNode.getChildren(), intPrimitiveArrayList);
        }
    }

    private void findFacetElements(Grammar grammar) {
        this.facetElements = new HashSet<Integer>();
        if (grammar.elements.length == 1) {
            this.facetElements.add(0);
        } else {
            for (int i = 0; i < grammar.elements.length; ++i) {
                for (int j = 0; j < this.facetFields.length; ++j) {
                    String string = this.facetFields[j].getField().data.id;
                    if (grammar.elements[i].data == null) continue;
                    if (string != null) {
                        if (!string.equals(grammar.elements[i].data.id)) continue;
                        this.facetElements.add(i);
                        continue;
                    }
                    if (this.facetFields[j].getField().data.rows.length != grammar.elements[j].data.rows.length) continue;
                    this.facetElements.add(i);
                }
            }
        }
    }

    private boolean isFacetData(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            int n;
            int n2;
            if (string.indexOf("V") != -1) {
                return false;
            }
            if (string.indexOf("F") == -1 && (n2 = string.indexOf("E")) > -1 && this.facetElements.contains(n = Integer.parseInt(string.substring(n2 + 1, n2 + 2)))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<SceneNode> makeUnsharedCellsScene(Grammar grammar, Dim dim, List<SceneNode> list, DataSpec[] dataSpecArray, VisContext visContext) {
        Object object;
        if (this.generatedScene != null) {
            this.addGeneratedScene(list);
        }
        LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap = null;
        Element[] elementArray = grammar.elements;
        for (int i = 0; linkedHashMap == null && i < elementArray.length; ++i) {
            linkedHashMap = this.getFacetKeyRowMap(elementArray[i]);
        }
        Compose compose = new Compose(list, this.getFacetLayout());
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        GrammarSpec grammarSpec = (GrammarSpec)grammar.gSpec.copy();
        grammarSpec.facet = null;
        if (this.isPanel()) {
            this.addEmptyStyle(grammarSpec);
        }
        ArrayList<GrammarSpec> arrayList = new ArrayList<GrammarSpec>();
        arrayList.add(grammarSpec);
        for (Grammar object22 : grammar.getFacetedGrammars()) {
            arrayList.add(object22.gSpec);
        }
        visJSONSpec.grammar = arrayList.toArray(new GrammarSpec[arrayList.size()]);
        visJSONSpec.size = new SizeSpec();
        visJSONSpec.size.width = dim.getWidth();
        visJSONSpec.size.height = dim.getHeight();
        Object object3 = this.getFacetData(dataSpecArray);
        if (((DataSpec)object3).source != null) {
            object3 = AbstractFaceting.getSourceData((DataSpec)object3, dataSpecArray);
            linkedHashMap = this.updateFacetRows(linkedHashMap);
        }
        double[][] dArray = ((DataSpec)object3).rows;
        ((DataSpec)object3).rows = null;
        DataSpec dataSpec = (DataSpec)((AbstractMappedJSONObject)object3).copy();
        dataSpec.provider = null;
        ((DataSpec)object3).rows = dArray;
        int n = dataSpecArray.length;
        visJSONSpec.data = new DataSpec[n];
        if (n == 1) {
            visJSONSpec.data[0] = dataSpec;
        } else {
            object = ((DataSpec)object3).id;
            for (int i = 0; i < n; ++i) {
                String string = dataSpecArray[i].id;
                if (object != null && ((String)object).equals(string)) {
                    visJSONSpec.data[i] = dataSpec;
                    continue;
                }
                if (object == null && string == null) {
                    String string2 = ((DataSpec)object3).fields[0].id;
                    boolean bl = false;
                    for (FieldSpec fieldSpec : dataSpecArray[i].fields) {
                        if (!fieldSpec.id.equals(string2)) continue;
                        bl = true;
                    }
                    visJSONSpec.data[i] = bl ? dataSpec : dataSpecArray[i];
                    continue;
                }
                visJSONSpec.data[i] = dataSpecArray[i];
            }
        }
        ArrayList<CellElementContents> arrayList2 = this.createContents(grammar, dim, linkedHashMap, visJSONSpec, grammarSpec, dArray, dataSpec, visContext, list, compose);
        object = compose.makeInnerScene(arrayList2, grammar.getId());
        this.removeExtraFrames((List<SceneNode>)object);
        return object;
    }

    private ArrayList<CellElementContents> createContents(Grammar grammar, Dim dim, LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap, VisJSONSpec visJSONSpec, GrammarSpec grammarSpec, double[][] dArray, DataSpec dataSpec, VisContext visContext, List<SceneNode> list, Compose compose) {
        ArrayList<CellElementContents> arrayList = new ArrayList<CellElementContents>();
        boolean[] blArray = null;
        DimensionSpec[] dimensionSpecArray = null;
        Dim dim2 = null;
        double[] dArray2 = null;
        if (!this.isChartInChart() && !grammar.coordinates.containsPolar() && this.facetSpec.sharedAxes != null && this.facetSpec.sharedAxes.length > 0 && grammarSpec.coordinates != null && (dimensionSpecArray = grammarSpec.coordinates.dimensions) != null) {
            blArray = this.getUpdateSharedAxisArray(dimensionSpecArray);
        }
        boolean bl = !this.isChartInChart();
        boolean bl2 = grammar.coordinates.containsTranspose();
        int n = bl ? 2 : 1;
        int n2 = visContext.getFacetIndex();
        this.findFacetElements(grammar);
        ArrayList<FacetAxisInfo> arrayList2 = bl ? new ArrayList<FacetAxisInfo>() : null;
        HashMap<String, Dim> hashMap = new HashMap<String, Dim>();
        for (int i = 0; i < n; ++i) {
            arrayList.clear();
            n2 = visContext.getFacetIndex();
            for (String string : linkedHashMap.keySet()) {
                Axis[] axisArray;
                Coordinates coordinates;
                Object object;
                IntPrimitiveArrayList intPrimitiveArrayList = linkedHashMap.get(string);
                if (!compose.isScenePart(string) || intPrimitiveArrayList.size() == 0 && this.isChartInChart()) continue;
                dataSpec.rows = AbstractFaceting.subset(dArray, intPrimitiveArrayList);
                Vis vis = Vis.createVisWithContext(visContext);
                vis.setSpecificationValidation(false);
                if (blArray != null) {
                    this.handleSharedAxis(grammar, blArray, dimensionSpecArray, dArray2, n2, dim);
                }
                Dim dim3 = grammar.getExtent();
                Dim dim4 = grammar.getOverallBounds();
                Dim dim5 = grammar.getSizeInfo(null, null).getPreferred().toDim(dim3, dim4);
                Dim dim6 = this.getSelectedPanelSize(blArray, dim5, string, dim, dim2, dArray2);
                if (dim6 != null) {
                    visJSONSpec.size.width = dim6.getWidth();
                    visJSONSpec.size.height = dim6.getHeight();
                    hashMap.put(string, dim6);
                }
                this.modifyFacetGrammar(visJSONSpec.grammar[0]);
                VisState visState = vis.setTypedSpecification(visJSONSpec);
                visState.isSpecSet();
                vis.replaceSharedScalesInGrammar(grammar, 0);
                Grammar[] grammarArray = vis.getGrammar();
                if (grammarArray.length > 0 && grammarArray[0] != null) {
                    grammarArray[0].setId(grammar.getId());
                    object = grammar.getFacetedGrammars();
                    if (object != null && object.size() > 0) {
                        for (int j = 1; j < grammarArray.length && j - 1 < object.size(); ++j) {
                            grammarArray[j].setId(((Grammar)object.get(j - 1)).getId());
                        }
                    }
                }
                object = vis.makeSceneTree(dim6, visState).getSceneTree();
                List<SceneNode> list2 = ((SceneTree)object).getRoot().getChildren();
                if (bl && grammarArray.length > 0 && grammarArray[0] != null && (coordinates = grammarArray[0].coordinates) != null && (axisArray = coordinates.axes).length != 0 && i == 0) {
                    for (int j = 0; j < axisArray.length; ++j) {
                        Axis axis = axisArray[j];
                        FacetAxisInfo facetAxisInfo = new FacetAxisInfo();
                        facetAxisInfo.facetIndex = n2;
                        facetAxisInfo.axisDrawPosition = axis.getDrawPosition();
                        facetAxisInfo.axisIndex = j;
                        facetAxisInfo.axisTickHeight = axis.getTickHeight();
                        if (axis.getScale().isCategorical()) {
                            facetAxisInfo.axisMethod = axis.getMethod();
                        }
                        arrayList2.add(facetAxisInfo);
                    }
                }
                this.updateFacetRowNumbers(list2, intPrimitiveArrayList);
                arrayList.add(CellElementContents.createContentsFromScene(string, n2++, list2));
                vis.dispose();
            }
            if (i != 0 || !bl) continue;
            ArrayList arrayList3 = new ArrayList();
            boolean bl3 = AbstractFaceting.setFacetAxisInfo(blArray, arrayList2, arrayList3);
            if (!bl3) break;
            dArray2 = new double[2];
            dim2 = new Dim(0.0, 0.0);
            this.processAxisForSecondPass(dim, visJSONSpec, blArray, dim2, dArray2, arrayList3, bl2);
        }
        visContext.setFacetIndex(n2);
        if (blArray != null) {
            this.modifyPanelSize(hashMap, list);
        }
        return arrayList;
    }

    public void modifyFacetGrammar(GrammarSpec grammarSpec) {
    }

    private static boolean setFacetAxisInfo(boolean[] blArray, ArrayList<FacetAxisInfo> arrayList, ArrayList<FacetAxisInfo> arrayList2) {
        boolean bl = blArray != null;
        for (FacetAxisInfo facetAxisInfo : arrayList) {
            FacetAxisInfo facetAxisInfo2;
            int n = facetAxisInfo.axisIndex;
            if (arrayList2.size() <= n) {
                for (int i = n - arrayList2.size() + 1; i != 0; --i) {
                    arrayList2.add(null);
                }
            }
            if ((facetAxisInfo2 = arrayList2.get(n)) == null) {
                arrayList2.set(n, facetAxisInfo);
                continue;
            }
            if (!(Math.abs(facetAxisInfo.axisTickHeight - facetAxisInfo2.axisTickHeight) > 1.0)) continue;
            bl = true;
            if (!(facetAxisInfo.axisTickHeight > facetAxisInfo2.axisTickHeight)) continue;
            arrayList2.set(n, facetAxisInfo);
        }
        return bl;
    }

    private boolean isPanel() {
        return "panel".equals(this.facetSpec.method);
    }

    private void addEmptyStyle(GrammarSpec grammarSpec) {
        grammarSpec.style = new StyleSpec();
    }

    private void removeExtraFrames(List<SceneNode> list) {
        if (!this.isPanel()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            List<SceneNode> list2 = list.get(i).getChildren();
            if (list2 == null) continue;
            GenerateOuter.removeExtraFrames(list2);
        }
    }

    private void processAxisForSecondPass(Dim dim, VisJSONSpec visJSONSpec, boolean[] blArray, Dim dim2, double[] dArray, ArrayList<FacetAxisInfo> arrayList, boolean bl) {
        int n = this.facetFields[0].getField().categories.length;
        int n2 = this.facetFields.length > 1 ? this.facetFields[1].getField().categories.length : 1;
        GrammarSpec grammarSpec = visJSONSpec.grammar[0];
        CoordinatesSpec coordinatesSpec = grammarSpec.coordinates;
        DimensionSpec[] dimensionSpecArray = coordinatesSpec.dimensions;
        for (int i = 0; i < arrayList.size(); ++i) {
            FacetAxisInfo facetAxisInfo = arrayList.get(i);
            if (facetAxisInfo == null) continue;
            int n3 = AbstractFaceting.getDimensionIndex(dimensionSpecArray, arrayList.size(), facetAxisInfo.axisDrawPosition);
            if (bl) {
                n3 = Math.abs(n3 - 1);
            }
            DimensionSpec dimensionSpec = dimensionSpecArray[n3];
            if (dimensionSpec.axis == null || dimensionSpec.axis.length == 0 || dimensionSpec.axis[0] == null) continue;
            AxisSpec axisSpec = dimensionSpec.axis[0];
            Object object = axisSpec.preferredSize == null || axisSpec.preferredSize.max != null && ((Number)axisSpec.preferredSize.max).doubleValue() == 0.0 ? null : axisSpec.preferredSize.max;
            axisSpec.preferredSize = new PreferredSizeSpec();
            axisSpec.preferredSize.min = facetAxisInfo.axisTickHeight;
            axisSpec.preferredSize.max = object;
            if (facetAxisInfo.axisMethod != null) {
                axisSpec.method = facetAxisInfo.axisMethod;
            }
            if (blArray == null || !blArray[n3]) continue;
            dArray[facetAxisInfo.axisDrawPosition] = facetAxisInfo.axisTickHeight;
            if (facetAxisInfo.axisDrawPosition == 0) {
                dim2.setWidth((dim.getWidth() * (double)n2 - dArray[0]) / (double)n2);
                continue;
            }
            dim2.setHeight((dim.getHeight() * (double)n - dArray[1]) / (double)n);
        }
    }

    private static int getDimensionIndex(DimensionSpec[] dimensionSpecArray, int n, int n2) {
        int n3 = dimensionSpecArray.length;
        if (n > n3) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                DimensionSpec dimensionSpec = dimensionSpecArray[i];
                if (dimensionSpec.axis != null) {
                    n4 += dimensionSpec.axis.length;
                }
                if (n2 > n4) continue;
                return i;
            }
        }
        return n2;
    }

    private void handleSharedAxis(Grammar grammar, boolean[] blArray, DimensionSpec[] dimensionSpecArray, double[] dArray, int n, Dim dim) {
        for (int i = 0; i < blArray.length; ++i) {
            AxisSpec[] axisSpecArray;
            if (!blArray[i] || (axisSpecArray = dimensionSpecArray[i].axis) == null || axisSpecArray.length == 0 || axisSpecArray[0] == null) continue;
            AxisSpec axisSpec = axisSpecArray[0];
            int n2 = this.facetFields[0].getField().categories.length;
            int n3 = this.facetFields.length > 1 ? this.facetFields[1].getField().categories.length : 1;
            boolean bl = grammar.coordinates.containsTranspose();
            boolean bl2 = AbstractFaceting.isAxisVisible(i, n2, n3, n, bl, dim);
            axisSpec.visible = bl2;
            Object object = axisSpec.preferredSize == null || axisSpec.preferredSize.max != null && ((Number)axisSpec.preferredSize.max).doubleValue() == 0.0 ? null : axisSpec.preferredSize.max;
            axisSpec.preferredSize = new PreferredSizeSpec();
            axisSpec.preferredSize.max = object;
            if (!bl2) {
                axisSpec.preferredSize.max = 0;
                continue;
            }
            double d = 0.0;
            if (dArray != null) {
                double d2 = d = bl ? dArray[Math.abs(1 - i)] : dArray[i];
                if (d == 0.0) {
                    axisSpec.preferredSize.max = d;
                } else {
                    axisSpec.preferredSize.preferred = d;
                }
            }
            axisSpec.preferredSize.min = d;
        }
    }

    private boolean[] getUpdateSharedAxisArray(DimensionSpec[] dimensionSpecArray) {
        boolean bl = true;
        int n = dimensionSpecArray.length;
        boolean[] blArray = new boolean[dimensionSpecArray.length];
        for (int i = 0; i < n; ++i) {
            if (!this.isSharedAxis(i)) continue;
            DimensionSpec dimensionSpec = dimensionSpecArray[i];
            AxisSpec[] axisSpecArray = dimensionSpec.axis;
            if (axisSpecArray == null || axisSpecArray.length == 0) {
                blArray[i] = false;
            } else {
                ScaleSpec scaleSpec;
                boolean bl2 = blArray[i] = axisSpecArray[0].visible == null || axisSpecArray[0].visible != false;
                if (blArray[i] && (scaleSpec = dimensionSpec.scale) != null) {
                    boolean bl3 = blArray[i] = scaleSpec.local == null || scaleSpec.local == false;
                }
            }
            if (!bl || !blArray[i]) continue;
            bl = false;
        }
        return bl ? null : blArray;
    }

    @Override
    public boolean isSharedAxis(int n) {
        if (this.facetSpec.sharedAxes != null) {
            for (int i = 0; i < this.facetSpec.sharedAxes.length; ++i) {
                if (this.facetSpec.sharedAxes[i].intValue() != n) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAxisVisible(int n, int n2, int n3, int n4, boolean bl, Dim dim) {
        if (bl) {
            return AbstractFaceting.isAxisVisible(Math.abs(n - 1), n2, n3, n4, false, dim);
        }
        switch (n) {
            case 0: {
                return dim.getHeight() > 40.0 && n4 % n3 == 0;
            }
            case 1: {
                return dim.getWidth() > 40.0 && (n4 - n4 % n3) / n3 == n2 - 1;
            }
        }
        return false;
    }

    private LinkedHashMap<String, IntPrimitiveArrayList> getFacetKeyRowMap(Element element) {
        LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap = new LinkedHashMap<String, IntPrimitiveArrayList>();
        List<String> list = AbstractFaceting.makeKeys(this.facetFields);
        for (String string : list) {
            linkedHashMap.put(string, new IntPrimitiveArrayList());
        }
        Row[] rowArray = element.data.rows;
        for (int i = 0; i < rowArray.length; ++i) {
            Row row = rowArray[i];
            String string = this.makeKey(row);
            IntPrimitiveArrayList intPrimitiveArrayList = linkedHashMap.get(string);
            if (intPrimitiveArrayList == null) continue;
            intPrimitiveArrayList.add(i);
        }
        return linkedHashMap;
    }

    protected void modifyPanelSize(Map<String, Dim> map, List<SceneNode> list) {
    }

    protected LinkedHashMap<String, IntPrimitiveArrayList> updateFacetRows(LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap) {
        LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap2 = new LinkedHashMap<String, IntPrimitiveArrayList>();
        for (String string : linkedHashMap.keySet()) {
            IntPrimitiveArrayList intPrimitiveArrayList = linkedHashMap.get(string);
            IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
            for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
                this.facetFields[0].getField().data.rows[intPrimitiveArrayList.get(i)].addOriginalRows(intPrimitiveArrayList2, true);
            }
            linkedHashMap2.put(string, intPrimitiveArrayList2);
        }
        return linkedHashMap2;
    }

    @Override
    public String updateKey(String string, Row row) {
        String string2 = string;
        for (FacetField facetField : this.facetFields) {
            string2 = string2 + KEY_SEPARATOR + facetField.getField().getUnformattedStringValue(row, false);
        }
        return string2;
    }

    @Override
    public void applyFacetingToShape(Shape shape, Row row, Element element) {
        if (this.isFacetedElement(element)) {
            shape.setMeta(FACET_META, this.makeKey(row));
        }
    }

    private String makeKey(Row row) {
        String string = this.facetFields[0].getField().getUnformattedStringValue(row, false);
        for (int i = 1; i < this.facetFields.length; ++i) {
            string = string + KEY_SEPARATOR + this.facetFields[i].getField().getUnformattedStringValue(row, false);
        }
        return string;
    }

    @Override
    public boolean isFacetedElement(Element element) {
        if (element.hasVariableRef()) {
            for (FacetField facetField : this.facetFields) {
                if (facetField.getField().data != element.data) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IntPrimitiveArrayList> makeDataGroups(Element element) {
        ArrayList<IntPrimitiveArrayList> arrayList = new ArrayList<IntPrimitiveArrayList>();
        LinkedHashMap<String, IntPrimitiveArrayList> linkedHashMap = this.getFacetKeyRowMap(element);
        for (String string : ((HashMap)linkedHashMap).keySet()) {
            arrayList.add((IntPrimitiveArrayList)((HashMap)linkedHashMap).get(string));
        }
        return arrayList;
    }

    @Override
    public void addFacetInfoToShapes(ShapeList shapeList, Element element) {
        for (Shape shape : shapeList.getAllShapes()) {
            if (shape.getRows() == null) continue;
            Row row = element.data.rows[shape.getRows()[0]];
            Field[] fieldArray = new Field[this.facetFields.length];
            for (int i = 0; i < this.facetFields.length; ++i) {
                fieldArray[i] = this.facetFields[i].getField();
            }
            double[] dArray = Field.getValuesAsZeroOne(row, fieldArray);
            if (shape.getPosition() == null) {
                shape.setPosition(new Position(0, 0, 0));
            }
            shape.setPosition(shape.getPosition().setFacet(dArray));
        }
    }

    public static List<String> makeKeys(FacetField[] facetFieldArray) {
        if (facetFieldArray.length > 2) {
            throw new EngineException("Cannot have more than 2 facet fields.", ErrorCode.ENGINE_FACET_TOO_MANY_FIELDS, null);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = facetFieldArray[0].getField().categories;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (facetFieldArray.length == 2) {
                object = facetFieldArray[1].getField().categories;
                for (int j = 0; j < ((String[])object).length; ++j) {
                    String string = i + KEY_SEPARATOR + j;
                    arrayList.add(string);
                }
                continue;
            }
            object = i + "";
            arrayList.add((String)object);
        }
        return arrayList;
    }

    @Override
    public void specificationDataUpdated() {
    }
}

