/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.facet.CellElementContents;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.MultiPartTextLine;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.util.SceneTreeUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Compose {
    private static final String BACK_ID = "Back";
    private static final String FACET_ID_PREFIX = "F";
    private final List<SceneNode> targetElements;
    private final Map<String, Rect> keyToBounds;
    private final Point offset;

    public Compose(List<SceneNode> list, Map<String, Rect> map) {
        SceneTreeUtil sceneTreeUtil = new SceneTreeUtil(list);
        this.targetElements = sceneTreeUtil.getElementGroups().get(0);
        this.keyToBounds = map;
        SceneNode[] sceneNodeArray = sceneTreeUtil.getGrammarInnerShapes();
        if (sceneNodeArray.length > 0) {
            SceneNode sceneNode = sceneNodeArray[0];
            this.offset = SceneTreeUtil.getTransformOffset(sceneNode);
        } else {
            this.offset = new Point(0.0, 0.0);
        }
    }

    public boolean isScenePart(String string) {
        if (this.keyToBounds != null) {
            return this.keyToBounds.containsKey(string);
        }
        return true;
    }

    public List<SceneNode> makeInnerScene(List<CellElementContents> list, String string) {
        String string2;
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        LinkedHashMap<String, SceneNode> linkedHashMap = new LinkedHashMap<String, SceneNode>();
        int n = this.targetElements.size();
        for (int i = 0; i < n; ++i) {
            SceneNode object = this.targetElements.get(i);
            string2 = object.getShape().getElementInfo().getKey();
            linkedHashMap.put(string2, object);
        }
        for (CellElementContents cellElementContents : list) {
            SceneNode sceneNode;
            string2 = cellElementContents.name;
            Rect rect = null;
            if (this.keyToBounds != null) {
                rect = this.keyToBounds.get(string2);
            } else {
                sceneNode = (SceneNode)linkedHashMap.get(string2);
                if (sceneNode != null) {
                    rect = SceneTreeUtil.getBounds(sceneNode);
                }
            }
            if (rect == null) continue;
            this.prefixIDs(cellElementContents.scene, FACET_ID_PREFIX + cellElementContents.index, string);
            sceneNode = this.makeSubGroup(rect, cellElementContents.scene, cellElementContents.name);
            arrayList.add(sceneNode);
        }
        return arrayList;
    }

    private SceneNode makeSubGroup(Rect rect, List<SceneNode> list, String string) {
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.FACET);
        groupSceneNode.getChildren().addAll(list);
        Rect rect2 = SceneTreeUtil.getBounds(list.get(0));
        AccessibleInfo accessibleInfo = new AccessibleInfo();
        accessibleInfo.setProperty("facet", string);
        groupSceneNode.setA11y(accessibleInfo);
        groupSceneNode.translate(rect.getCenterX() - rect2.getCenterX() + this.offset.getX(), rect.getCenterY() - rect2.getCenterY() + this.offset.getY());
        groupSceneNode.setClipBounds(new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight()));
        return groupSceneNode;
    }

    private void prefixIDs(List<SceneNode> list, String string, String string2) {
        for (SceneNode sceneNode : list) {
            ShapeInfo shapeInfo;
            String string3 = sceneNode.getId();
            if (string3 != null) {
                if (string2 != null && BACK_ID.equals(string3)) {
                    string3 = string2 + string3;
                }
                ((SceneNodeImpl)sceneNode).setId(string + string3);
            }
            if ((shapeInfo = sceneNode.getShape()) instanceof Schema || shapeInfo instanceof MultiPartText || shapeInfo instanceof MultiPartTextLine) continue;
            this.prefixIDs(sceneNode.getChildren(), string, string2);
        }
    }
}

