/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.facet.AbstractFaceting;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.FacetSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetMethodChartInChart
extends AbstractFaceting {
    protected Element targetElement;

    public FacetMethodChartInChart(FacetSpec facetSpec, FacetField[] facetFieldArray, Vis vis) {
        super(facetSpec, facetFieldArray);
        IdentifiableItem identifiableItem = null;
        if (facetSpec.targetElement != null) {
            identifiableItem = vis.getByID(facetSpec.targetElement.$ref);
        }
        if (identifiableItem == null || !(identifiableItem instanceof Element)) {
            throw new SpecException("Chart-in-Chart faceting requires a targetElement which references an element", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        this.targetElement = (Element)identifiableItem;
    }

    @Override
    public void initializeFaceting(String string, List<SceneNode> list, Dim dim) {
        HashMap<String, Rect> hashMap = new HashMap<String, Rect>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(AbstractFaceting.makeKeys(this.getFacetFields()));
        for (Shape shape : this.targetElement.cachedShapes) {
            Rect rect;
            if (!SceneIdUtil.identifiesElement(shape.getID()) || shape.getKey() == null || !hashSet.contains(shape.getKey()) || hashMap.get(shape.getKey()) != null || (rect = this.getFacetBounds(shape)) == null) continue;
            hashMap.put(shape.getKey(), rect);
        }
        this.setFacetLayout(hashMap);
    }

    @Override
    public Dim getPanelSize(List<SceneNode> list, Dim dim) {
        return dim;
    }

    @Override
    public Dim getSelectedPanelSize(boolean[] blArray, Dim dim, String string, Dim dim2, Dim dim3, double[] dArray) {
        Map<String, Rect> map = this.getFacetLayout();
        assert (map != null);
        Rect rect = map.get(string);
        if (rect == null) {
            return null;
        }
        return rect.getExtent();
    }

    @Override
    public boolean isChartInChart() {
        return true;
    }

    protected final Rect getFacetBounds(Shape shape) {
        if (shape == null) {
            return null;
        }
        FacetSpec facetSpec = this.getFacetSpec();
        if (facetSpec.targetPart == null) {
            return shape.getBounds();
        }
        Shape shape2 = shape.getPartByName(facetSpec.targetPart);
        if (shape2 == null) {
            return null;
        }
        return shape2.getBounds();
    }
}

