/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.facet.AbstractFaceting;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.facet.GenerateOuter;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.engine.internal.util.SceneTreeUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.ElementInfo;
import com.ibm.vis.scenetree.provisional.FieldInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetMethodPanel
extends AbstractFaceting {
    private static final String FIRST_GRAMMAR_ID_PREFIX = "G0";
    private static final String TRANSPARENT = "transparent";
    private static final String EMPTY = "";
    private static final String FACET_KEY_SEPARATOR = "|";
    private static final String XFACET = "facet2";
    private static final String YFACET = "facet1";
    private static final int DEFAULT_PADDING = 5;
    protected Dim panelSize;
    private final Vis vis;
    private double[] axisSize;
    private final Object facetPadding;
    int[] rowIndex;
    int[] columnIndex;

    public FacetMethodPanel(FacetSpec facetSpec, FacetField[] facetFieldArray, Vis vis, Object object) {
        super(facetSpec, facetFieldArray);
        int[] nArray;
        this.vis = vis;
        this.facetPadding = object == null ? Integer.valueOf(5) : object;
        int[] nArray2 = this.rowIndex = facetFieldArray == null ? null : this.facetFields[0].getField().getUsedCategories();
        if (facetFieldArray == null) {
            nArray = null;
        } else if (this.facetFields.length > 1) {
            nArray = this.facetFields[1].getField().getUsedCategories();
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        this.columnIndex = nArray;
        if (facetSpec.targetElement != null || facetSpec.targetPart != null) {
            throw new SpecException("Panel faceting may not have a targetElement or targetPart", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    @Override
    public void initializeFaceting(String string, List<SceneNode> list, Dim dim) {
        List<SceneNode> list2 = GenerateOuter.makeTableOuterScene(this.getFacetFields(), dim);
        if (string != null && !string.equals(FIRST_GRAMMAR_ID_PREFIX)) {
            this.replaceGrammarId(list2, string);
        }
        this.setGeneratedScene(list2);
        SceneTreeUtil sceneTreeUtil = new SceneTreeUtil(list2);
        List<List<SceneNode>> list3 = sceneTreeUtil.getElementGroups();
        if (list3.size() == 0 || list3.get(0).size() == 0) {
            this.panelSize = dim;
        } else {
            SceneNode sceneNode = list3.get(0).get(0);
            this.panelSize = SceneTreeUtil.getBounds(sceneNode).getExtent();
        }
    }

    private void replaceGrammarId(List<SceneNode> list, String string) {
        for (SceneNode sceneNode : list) {
            String string2 = sceneNode.getId();
            if (string2 != null) {
                string2 = SceneIdUtil.replaceGrammarIndex(string2, string);
                ((SceneNodeImpl)sceneNode).setId(string2);
            }
            this.replaceGrammarId(sceneNode.getChildren(), string);
        }
    }

    @Override
    public Dim getPanelSize(List<SceneNode> list, Dim dim) {
        assert (this.panelSize != null);
        return this.panelSize;
    }

    @Override
    public Dim getSelectedPanelSize(boolean[] blArray, Dim dim, String string, Dim dim2, Dim dim3, double[] dArray) {
        if (blArray == null) {
            return null;
        }
        if (dim3 == null && (string.equals(this.rowIndex[0] + FACET_KEY_SEPARATOR + this.columnIndex[0]) || string.equals(this.rowIndex[0] + EMPTY))) {
            return new Dim(dim.getWidth(), dim2.getHeight());
        }
        if (dim3 != null) {
            int n;
            this.axisSize = dArray;
            double d = dim2.getWidth();
            double d2 = dim2.getHeight();
            if (dim3.getWidth() > 0.0) {
                n = string.indexOf(FACET_KEY_SEPARATOR);
                boolean bl = n <= -1 || string.substring(n + 1, n + 2).equals(EMPTY + this.columnIndex[0]);
                double d3 = d = bl ? dim3.getWidth() + dArray[0] : dim3.getWidth();
            }
            if (dim3.getHeight() > 0.0) {
                n = string.indexOf(FACET_KEY_SEPARATOR);
                String string2 = n > -1 ? string.substring(0, n) : string;
                boolean bl = string2.equals(EMPTY + this.rowIndex[this.rowIndex.length - 1]);
                d2 = bl ? dim3.getHeight() + dArray[1] : dim3.getHeight();
            }
            return new Dim(d, d2);
        }
        return null;
    }

    @Override
    public boolean isChartInChart() {
        return false;
    }

    @Override
    public void modifyFacetGrammar(GrammarSpec grammarSpec) {
        if (this.facetSpec.sharedAxes != null) {
            grammarSpec.axisPadding = false;
        }
        grammarSpec.bounds = null;
        if (grammarSpec.style == null) {
            grammarSpec.style = new StyleSpec();
            grammarSpec.style.fill = TRANSPARENT;
        }
        grammarSpec.style.padding = this.facetPadding;
    }

    @Override
    protected void modifyPanelSize(Map<String, Dim> map, List<SceneNode> list) {
        Set<String> set = map.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        int n = (stringArray = this.sort(stringArray))[0].indexOf(FACET_KEY_SEPARATOR);
        String string = n > -1 ? stringArray[0].substring(0, n) : stringArray[0];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            Shape shape;
            String string3 = stringArray[i];
            if (string3 == null || (shape = FacetMethodPanel.findShapeRectFromKey(list, string3)) == null) continue;
            Dim dim = map.get(string3);
            shape.setWidth(dim.getWidth());
            shape.setHeight(dim.getHeight());
            n = string3.indexOf(FACET_KEY_SEPARATOR);
            String string4 = string2 = n > -1 ? string3.substring(0, n) : string3;
            if (!string2.equals(string)) {
                d = 0.0;
                d2 += map.get(stringArray[i - 1]).getHeight();
            }
            shape.setX(d);
            shape.setY(d2);
            d += dim.getWidth();
            string = string2;
        }
        this.rebuildFacetXAxisLabels(list);
        this.rebuildFacetYAxisLabels(list);
    }

    private String[] sort(String[] stringArray) {
        if (this.rowIndex[this.rowIndex.length - 1] < 10 && this.columnIndex[this.columnIndex.length - 1] < 10) {
            BasicFactory.sortArray(stringArray);
            return stringArray;
        }
        int n = this.rowIndex.length;
        int n2 = this.columnIndex.length;
        String[] stringArray2 = new String[stringArray.length];
        if (this.facetFields.length == 1) {
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = this.rowIndex[i] + EMPTY;
            }
        } else {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    stringArray2[n3] = this.rowIndex[i] + FACET_KEY_SEPARATOR + this.columnIndex[j];
                    ++n3;
                }
            }
        }
        return stringArray2;
    }

    private void rebuildFacetXAxisLabels(List<SceneNode> list) {
        List<SceneNode> list2 = FacetMethodPanel.getFacetAxisLabels(list, XFACET);
        if (list2 == null) {
            return;
        }
        int n = this.columnIndex.length;
        if (n == 1) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.rowIndex[0] + FACET_KEY_SEPARATOR + this.columnIndex[i];
            Shape shape = FacetMethodPanel.findShapeRectFromKey(list, string);
            SceneNode sceneNode = n == list2.size() ? list2.get(i) : this.findLabelObj(list2, i);
            if (sceneNode == null) continue;
            list2.set(n2, this.makeLabelsForXAxis(sceneNode, shape, i));
            ++n2;
        }
    }

    private SceneNode findLabelObj(List<SceneNode> list, int n) {
        for (SceneNode sceneNode : list) {
            if (n != (Integer)sceneNode.getShape().getFieldInfo().getValue()) continue;
            return sceneNode;
        }
        return null;
    }

    private SceneNode makeLabelsForXAxis(SceneNode sceneNode, Shape shape, int n) {
        assert (shape != null);
        double d = shape.getWidth();
        double d2 = shape.getX();
        Text text = (Text)sceneNode.getShape();
        String string = text.getTextInfo().getText();
        double d3 = text.getNodeBounds().getY();
        double d4 = text.getHeight();
        AxisSpec axisSpec = GenerateOuter.makeAxisSpec(this.facetFields[1]);
        LabelProducer labelProducer = LabelProducer.makeSimpleInside(this.vis, axisSpec.tickStyle, "middle", "start", null);
        double d5 = d2;
        double d6 = d;
        if (n == 0 && this.axisSize != null) {
            d5 = this.axisSize[0];
            d6 -= this.axisSize[0];
        }
        Text text2 = labelProducer.makeLabel(new String[]{string}, ShapeFactory2.CreateRect(d5, 0.0, d6, d4 + 1.0));
        SceneNode sceneNode2 = sceneNode;
        if (text2 != null) {
            text2.setID(text.getID());
            text2.copyInfoFrom(text);
            text2.setField(text.getField());
            text2.setValue(text.getValue());
            text2.affine(1.0, 0.0, 1.0, d3 - text2.getNodeBounds().getY(), true);
            sceneNode2 = text2.createSceneNode();
        }
        return sceneNode2;
    }

    private void rebuildFacetYAxisLabels(List<SceneNode> list) {
        List<SceneNode> list2 = FacetMethodPanel.getFacetAxisLabels(list, YFACET);
        if (list2 == null) {
            return;
        }
        int n = this.rowIndex.length;
        if (n == 1) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode;
            String string = this.facetFields.length == 1 ? this.rowIndex[i] + EMPTY : this.rowIndex[i] + FACET_KEY_SEPARATOR + this.columnIndex[0];
            Shape shape = FacetMethodPanel.findShapeRectFromKey(list, string);
            if (shape == null || (sceneNode = n == list2.size() ? list2.get(n - 1 - i) : this.findLabelObj(list2, n - 1 - i)) == null) continue;
            list2.set(list2.size() - 1 - n2, this.makeLabelsForYAxis(sceneNode, (Rect)shape.getGeom(), i, n));
            ++n2;
        }
    }

    private SceneNode makeLabelsForYAxis(SceneNode sceneNode, Rect rect, int n, int n2) {
        double d = rect.getHeight();
        double d2 = rect.getY();
        Text text = (Text)sceneNode.getShape();
        double d3 = text.getNodeBounds().getWidth();
        String string = text.getTextInfo().getText();
        double d4 = text.getNodeBounds().getX();
        AxisSpec axisSpec = GenerateOuter.makeAxisSpec(this.facetFields[0]);
        LabelProducer labelProducer = LabelProducer.makeSimpleInside(this.vis, axisSpec.tickStyle, "end", "middle", null);
        double d5 = d2;
        double d6 = d;
        if (n == n2 - 1 && this.axisSize != null) {
            d6 -= this.axisSize[1];
        }
        Object[] objectArray = new String[]{string};
        Shape shape = ShapeFactory2.CreateRect(0.0, d5, d3 + 1.0, d6);
        Text text2 = labelProducer.makeLabel(objectArray, shape);
        SceneNode sceneNode2 = sceneNode;
        if (text2 != null) {
            text2.setID(text.getID());
            text2.copyInfoFrom(text);
            text2.setField(text.getField());
            text2.setValue(text.getValue());
            text2.affine(1.0, d4 - text2.getNodeBounds().getX(), 1.0, 0.0, true);
            sceneNode2 = text2.createSceneNode();
        }
        return sceneNode2;
    }

    private static List<SceneNode> getFacetAxisLabels(List<SceneNode> list, String string) {
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            String string2;
            FieldInfo fieldInfo;
            List<SceneNode> list2;
            SceneNode sceneNode;
            ShapeInfo shapeInfo;
            List<SceneNode> list3;
            SceneNode sceneNode2;
            SceneNode sceneNode3 = list.get(i);
            SceneNodeType sceneNodeType = sceneNode3.getType();
            if (sceneNodeType != SceneNodeType.AXIS || (sceneNode2 = FacetMethodPanel.findNodeOfType(list3 = sceneNode3.getChildren(), SceneNodeType.AXIS_LABEL)) == null || (shapeInfo = (sceneNode = (list2 = sceneNode2.getChildren()).get(0)).getShape()) == null || (fieldInfo = shapeInfo.getFieldInfo()) == null || !string.equals(string2 = fieldInfo.getId())) continue;
            return list2;
        }
        return null;
    }

    private static Shape findShapeRectFromKey(List<SceneNode> list, String string) {
        ShapeInfo shapeInfo;
        List<SceneNode> list2;
        SceneNode sceneNode;
        SceneNode sceneNode2 = FacetMethodPanel.findNodeOfType(list, SceneNodeType.ELEMENT);
        if (sceneNode2 != null && (sceneNode = FacetMethodPanel.findNodeMatchingKey(list2 = sceneNode2.getChildren(), string)) != null && (shapeInfo = sceneNode.getShape()).getGeom() instanceof Rect) {
            return (Shape)shapeInfo;
        }
        return null;
    }

    private static SceneNode findNodeOfType(List<SceneNode> list, SceneNodeType sceneNodeType) {
        for (SceneNode sceneNode : list) {
            if (sceneNodeType != sceneNode.getType()) continue;
            return sceneNode;
        }
        return null;
    }

    private static SceneNode findNodeMatchingKey(List<SceneNode> list, String string) {
        for (SceneNode sceneNode : list) {
            ElementInfo elementInfo;
            ShapeInfo shapeInfo = sceneNode.getShape();
            if (shapeInfo == null || (elementInfo = shapeInfo.getElementInfo()) == null || !string.equals(elementInfo.getKey())) continue;
            return sceneNode;
        }
        return null;
    }

    public final Vis getVis() {
        return this.vis;
    }
}

