/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.facet.FacetMethodPanel;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FacetFieldSpec;
import com.ibm.vis.spec.internal.FacetSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetMethodPanelHorizontal
extends FacetMethodPanel {
    private static final String DUMMY_FIELD_CAT = "_cat";
    private static final String DUMMY_FIELD_PFX = "PanelHorizwlipwl_";
    private int dataIndex;

    private String nextDummyFieldId(Vis vis) {
        int n = 0;
        for (Data data : vis.getData()) {
            n += data.fields.length;
        }
        return DUMMY_FIELD_PFX + n;
    }

    public FacetMethodPanelHorizontal(FacetSpec facetSpec, FacetField[] facetFieldArray, Vis vis, Object object) {
        super(facetSpec, facetFieldArray, vis, object);
        Field[] fieldArray;
        if (this.facetFields.length != 1) {
            throw new SpecException("The panelHorizontal method requires that there be one and only one facet field.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        String string = this.nextDummyFieldId(vis);
        FacetFieldSpec facetFieldSpec = new FacetFieldSpec();
        facetFieldSpec.field = new FieldRefSpec();
        facetFieldSpec.field.$ref = string;
        Field field = facetFieldArray[0].getField();
        String[] stringArray = new String[]{string + DUMMY_FIELD_CAT};
        FieldSpec fieldSpec = new FieldSpec();
        fieldSpec.categories = stringArray;
        fieldSpec.id = string;
        this.dataIndex = 0;
        int n = vis.getData().length;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                fieldArray = vis.getData()[i].fields;
                if (field.getIndex() >= fieldArray.length || !field.id.equals(fieldArray[field.getIndex()].id)) continue;
                this.dataIndex = i;
            }
        }
        Field[] fieldArray2 = vis.getData()[this.dataIndex].fields;
        Field field2 = Field.createSimpleField(vis, fieldSpec, vis.getData()[this.dataIndex], fieldArray2.length, field.unit);
        FacetField facetField = new FacetField(facetFieldSpec, field2);
        FacetField[] facetFieldArray2 = new FacetField[]{facetField, this.facetFields[0]};
        this.facetFields = facetFieldArray2;
        ArrayList<Field> arrayList = new ArrayList<Field>();
        fieldArray = vis.getData()[this.dataIndex].fields;
        for (int i = 0; i < fieldArray.length; ++i) {
            arrayList.add(fieldArray[i]);
        }
        arrayList.add(field2);
        vis.getData()[this.dataIndex].fields = arrayList.toArray(fieldArray);
        ArrayList<FieldSpec> arrayList2 = new ArrayList<FieldSpec>();
        FieldSpec[] fieldSpecArray = vis.getCurrentSpec().data[this.dataIndex].fields;
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            arrayList2.add((FieldSpec)fieldSpecArray[i].copy());
        }
        arrayList2.add(fieldSpec);
        vis.getCurrentSpec().data[this.dataIndex].fields = arrayList2.toArray(fieldSpecArray);
        arrayList2.add(fieldSpec);
        this.specificationDataUpdated();
    }

    @Override
    public void specificationDataUpdated() {
        double[] dArray = null;
        ArrayList<Row> arrayList = new ArrayList<Row>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        Row[] rowArray = this.getVis().getData()[this.dataIndex].rows;
        int n = rowArray.length;
        for (int i = 0; i < n; ++i) {
            dArray = new double[rowArray[i].data.length + 1];
            for (int j = 0; j < rowArray[i].data.length; ++j) {
                dArray[j] = rowArray[i].data[j];
            }
            dArray[rowArray[i].data.length] = 0.0;
            Row row = Row.createRow(dArray, i);
            row.shareOriginalRows(rowArray[i]);
            arrayList.add(row);
            arrayList2.add(dArray);
            dArray = null;
        }
        this.getVis().getData()[this.dataIndex].rows = arrayList.toArray(new Row[n]);
        DataSpec dataSpec = this.getVis().getCurrentSpec().data[this.dataIndex];
        dataSpec.rows = (double[][])arrayList2.toArray((T[])new double[n][]);
        dataSpec.provider = null;
        dataSpec.source = null;
    }
}

