/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.facet.FacetMethodChartInChart;
import com.ibm.vis.engine.internal.facet.FacetMethodNone;
import com.ibm.vis.engine.internal.facet.FacetMethodOverlay;
import com.ibm.vis.engine.internal.facet.FacetMethodPanel;
import com.ibm.vis.engine.internal.facet.FacetMethodPanelHorizontal;
import com.ibm.vis.engine.internal.facet.Faceting;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.FacetFieldSpec;
import com.ibm.vis.spec.internal.FacetSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FacetingFactory {
    public static final Faceting FACETING_NONE = new FacetMethodNone();
    public static final String FACET_METHOD_CHART_IN_CHART = "chartInChart";
    public static final String FACET_METHOD_PANEL = "panel";
    public static final String FACET_METHOD_PANEL_HORIZONTAL = "panelHorizontal";
    public static final String FACET_METHOD_OVERLAY = "overlay";

    public static Faceting getFacetingInstance(FacetSpec facetSpec, Object object, Vis vis, Element[] elementArray) {
        FacetField[] facetFieldArray;
        if (facetSpec == null) {
            return FACETING_NONE;
        }
        for (FacetField facetField : facetFieldArray = FacetingFactory.extractFieldsFromSpecAndValidateElements(vis, facetSpec, elementArray)) {
            if (facetField.getField().isCategorical()) continue;
            throw new EngineException("Facet data is not categorical.", ErrorCode.ENGINE_FACET_INVALID_DATA, null);
        }
        if (FACET_METHOD_CHART_IN_CHART.equals(facetSpec.method)) {
            return new FacetMethodChartInChart(facetSpec, facetFieldArray, vis);
        }
        if (FACET_METHOD_PANEL.equals(facetSpec.method)) {
            return new FacetMethodPanel(facetSpec, facetFieldArray, vis, object);
        }
        if (FACET_METHOD_PANEL_HORIZONTAL.equals(facetSpec.method)) {
            return new FacetMethodPanelHorizontal(facetSpec, facetFieldArray, vis, object);
        }
        if (FACET_METHOD_OVERLAY.equals(facetSpec.method)) {
            return new FacetMethodOverlay(facetSpec, facetFieldArray);
        }
        throw new SpecException("Facet method '" + facetSpec.method + "' not supported", ErrorCode.SPEC_INVALID_VALUE, null);
    }

    private static FacetField[] extractFieldsFromSpecAndValidateElements(Vis vis, FacetSpec facetSpec, Element[] elementArray) {
        if (facetSpec.fields == null || facetSpec.fields.length == 0) {
            throw new EngineException("Facet does not have any fields (faceting requires one or two fields)", ErrorCode.ENGINE_FACET_NO_FIELDS, null);
        }
        if (facetSpec.fields.length > 2) {
            throw new EngineException("Facet has too many fields (faceting requires one or two fields)", ErrorCode.ENGINE_FACET_TOO_MANY_FIELDS, null);
        }
        FacetFieldSpec[] facetFieldSpecArray = facetSpec.fields;
        FacetField[] facetFieldArray = new FacetField[facetFieldSpecArray.length];
        for (int i = 0; i < facetFieldSpecArray.length; ++i) {
            FacetFieldSpec facetFieldSpec = facetFieldSpecArray[i];
            if (facetFieldSpec.field == null || facetFieldSpec.field.$ref == null) {
                throw new EngineException("Facet field is missing", ErrorCode.ENGINE_FACET_INVALID_DATA, null);
            }
            Field field = (Field)vis.getByID(facetFieldSpec.field.$ref);
            if (field == null) {
                throw new EngineException("Facet field data is invalid.", ErrorCode.ENGINE_FACET_INVALID_DATA, null);
            }
            if (elementArray.length > i && !FacetingFactory.matchedDataSource(field, elementArray[i].positions)) {
                throw new EngineException("All faceting fields must come from the same data source as the positions.", ErrorCode.ENGINE_FACET_INVALID_DATA_SOURCE, null);
            }
            facetFieldArray[i] = new FacetField(facetFieldSpec, field);
        }
        return facetFieldArray;
    }

    private static boolean matchedDataSource(Field field, ValueProvider[] valueProviderArray) {
        for (int i = 0; i < valueProviderArray.length; ++i) {
            Field field2 = valueProviderArray[i].getBaseField();
            if (field2 == null || field2.data == field.data) continue;
            return false;
        }
        return true;
    }
}

