/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.facet;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.facet.FacetField;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.List;

class GenerateOuter {
    private static final String FIELD_ID_BASE = "facet";
    private static final String DEFAULT_SIZE = "100%";
    private static final String FIELD_ID_FACET_DATA = "facetData";
    private static final String FILL_STYLE_TRANSPARENT = "transparent";
    private static final String FONT_BOLD = "bold";
    protected static String panelSize;

    private GenerateOuter() {
    }

    static List<SceneNode> makeTableOuterScene(FacetField[] facetFieldArray, Dim dim) {
        if (facetFieldArray.length < 1 || facetFieldArray.length > 2) {
            throw new EngineException("Faceting can only be performed using one or two fields", ErrorCode.ENGINE_FACET_NO_FIELDS, null);
        }
        Data data = facetFieldArray[0].getField().data;
        for (FacetField facetField : facetFieldArray) {
            if (facetField.getField().data == data) continue;
            throw new EngineException("All faceting fields must come from the same data source", ErrorCode.ENGINE_FACET_INVALID_DATA_SOURCE, null);
        }
        panelSize = DEFAULT_SIZE;
        VisJSONSpec visJSONSpec = GenerateOuter.makeFacetVisSpec(facetFieldArray);
        Vis vis = Vis.createVisWithContext(data.visContext);
        VisState visState = vis.setTypedSpecification(visJSONSpec);
        visState = vis.makeSceneTree(dim, visState);
        SceneTree sceneTree = visState.getSceneTree();
        CompositeSceneNode compositeSceneNode = sceneTree.getRoot();
        List<SceneNode> list = compositeSceneNode.getChildren();
        GenerateOuter.removeExtraFrames(list);
        vis.dispose();
        return list;
    }

    protected static void removeExtraFrames(List<SceneNode> list) {
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = list.get(i);
            String string = sceneNode.getId();
            if (!SceneIdUtil.isBackId(string) && !SceneIdUtil.isOutId(string)) continue;
            arrayList.add(sceneNode);
        }
        for (SceneNode sceneNode : arrayList) {
            list.remove(sceneNode);
        }
    }

    private static FieldSpec[] makeFacetFieldSpecs(FacetField[] facetFieldArray) {
        FieldSpec[] fieldSpecArray = new FieldSpec[facetFieldArray.length];
        for (int i = 0; i < facetFieldArray.length; ++i) {
            Field field = facetFieldArray[i].getField();
            FieldSpec fieldSpec = new FieldSpec();
            fieldSpec.id = FIELD_ID_BASE + (i + 1);
            fieldSpec.key = true;
            if (field.getSpecifiedFormatter() != null) {
                fieldSpec.format = RAVEFormatter.makeFormatSpecFromRAVEFormatter(field.getSpecifiedFormatter());
            }
            if (field.categories != null) {
                fieldSpec.categories = field.categories;
            }
            fieldSpecArray[i] = fieldSpec;
        }
        return fieldSpecArray;
    }

    private static VisJSONSpec makeFacetVisSpec(FacetField[] facetFieldArray) {
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        DataSpec dataSpec = GenerateOuter.makeFacetDataSpec(facetFieldArray);
        visJSONSpec.data = new DataSpec[]{dataSpec};
        int n = dataSpec.rows.length;
        visJSONSpec.grammar = new GrammarSpec[]{GenerateOuter.makeFacetGrammarSpec(facetFieldArray, GenerateOuter.anyNumeric(facetFieldArray), n)};
        return visJSONSpec;
    }

    private static DataSpec makeFacetDataSpec(FacetField[] facetFieldArray) {
        DataSpec dataSpec = new DataSpec();
        dataSpec.rows = GenerateOuter.makeFacetDataRows(facetFieldArray);
        dataSpec.id = FIELD_ID_FACET_DATA;
        dataSpec.fields = GenerateOuter.makeFacetFieldSpecs(facetFieldArray);
        return dataSpec;
    }

    protected static GrammarSpec makeFacetGrammarSpec(FacetField[] facetFieldArray, boolean bl, int n) {
        int n2 = facetFieldArray.length;
        GrammarSpec grammarSpec = new GrammarSpec();
        grammarSpec.coordinates = GenerateOuter.makeFacetCoordinatesSpec(facetFieldArray);
        ElementsSpec elementsSpec = GenerateOuter.makeFacetElementSpec(n2, bl, n);
        grammarSpec.elements = new ElementsSpec[]{elementsSpec};
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.padding = 0;
        styleSpec.fill = FILL_STYLE_TRANSPARENT;
        grammarSpec.style = styleSpec;
        return grammarSpec;
    }

    private static ElementsSpec makeFacetElementSpec(int n, boolean bl, int n2) {
        ElementsSpec elementsSpec = new ElementsSpec();
        elementsSpec.type = "point";
        elementsSpec.position = GenerateOuter.makeFacetPositionSpec(n);
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.fill = FILL_STYLE_TRANSPARENT;
        if (bl) {
            int n3 = n2 < 1 ? 1 : n2;
            int n4 = (int)(100.0 * Math.sqrt(-Math.log(0.5) / (double)n3));
            String string = n4 + "%%";
            styleSpec.width = string;
            styleSpec.height = string;
        }
        styleSpec.size = panelSize;
        styleSpec.symbol = "rect";
        elementsSpec.style = styleSpec;
        return elementsSpec;
    }

    private static PositionSpec[] makeFacetPositionSpec(int n) {
        PositionSpec[] positionSpecArray = new PositionSpec[n];
        for (int i = 0; i < n; ++i) {
            PositionSpec positionSpec = new PositionSpec();
            positionSpec.field = new FieldValueRefSpec();
            positionSpec.field.$ref = FIELD_ID_BASE + (i + 1);
            positionSpecArray[i] = positionSpec;
        }
        return positionSpecArray;
    }

    private static CoordinatesSpec makeFacetCoordinatesSpec(FacetField[] facetFieldArray) {
        int n = facetFieldArray.length;
        CoordinatesSpec coordinatesSpec = new CoordinatesSpec();
        DimensionSpec[] dimensionSpecArray = new DimensionSpec[n];
        coordinatesSpec.dimensions = dimensionSpecArray;
        for (int i = 0; i < n; ++i) {
            DimensionSpec dimensionSpec;
            dimensionSpecArray[i] = dimensionSpec = new DimensionSpec();
            AxisSpec axisSpec = GenerateOuter.makeAxisSpec(facetFieldArray[i]);
            if (axisSpec == null) continue;
            dimensionSpec.axis = new AxisSpec[1];
            dimensionSpec.axis[0] = axisSpec;
        }
        return coordinatesSpec;
    }

    public static AxisSpec makeAxisSpec(FacetField facetField) {
        AxisSpec axisSpec = facetField.getFacetFieldSpec().axis;
        if (axisSpec != null) {
            if (axisSpec.markStyle == null) {
                axisSpec.markStyle = new StyleSpec();
            }
            if (axisSpec.lineStyle == null) {
                axisSpec.lineStyle = new StyleSpec();
            }
            if (axisSpec.tickStyle == null) {
                axisSpec.tickStyle = new StyleSpec();
                FontSpec fontSpec = new FontSpec();
                fontSpec.weight = FONT_BOLD;
                fontSpec.size = 14;
                axisSpec.tickStyle.font = fontSpec;
            }
        }
        return axisSpec;
    }

    private static boolean anyNumeric(FacetField[] facetFieldArray) {
        for (FacetField facetField : facetFieldArray) {
            if (facetField.getField().isCategorical()) continue;
            return true;
        }
        return false;
    }

    private static double[][] makeFacetDataRows(FacetField[] facetFieldArray) {
        Field field = facetFieldArray[0].getField();
        int[] nArray = field.getUsedCategories();
        if (nArray == null) {
            return new double[0][];
        }
        if (facetFieldArray.length == 1) {
            double[][] dArrayArray = new double[nArray.length][];
            for (int i = 0; i < nArray.length; ++i) {
                dArrayArray[i] = new double[]{nArray[i]};
            }
            return dArrayArray;
        }
        if (facetFieldArray.length == 2) {
            field = facetFieldArray[1].getField();
            int[] nArray2 = field.getUsedCategories();
            int n = 0;
            double[][] dArrayArray = new double[nArray.length * nArray2.length][];
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    double[] dArray = new double[]{nArray[i], nArray2[j]};
                    dArrayArray[n] = dArray;
                    ++n;
                }
            }
            return dArrayArray;
        }
        throw new EngineException("Faceting can only be performed using one or two fields", ErrorCode.ENGINE_FACET_NO_FIELDS, null);
    }
}

