/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.format;

import com.ibm.vis.engine.DataFormatter;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.engine.internal.nativeImpl.FormatObject;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.FormatSpec;
import com.ibm.vis.spec.internal.NegativeFormatSpec;
import com.ibm.vis.spec.internal.NoSpaceFormatSpec;
import com.ibm.vis.spec.internal.ScientificSpec;
import com.ibm.vis.spec.internal.ZeroFormatSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RAVEFormatter
implements DataFormatter {
    private final String prefix;
    private final String suffix;
    private final String fitMethod;
    private final Object scientificSpec;
    private final double defaultMin = 1.0E-4;
    private final double defaultMax = 100000.0;
    private static final String ALWAYS = "always";
    private static final String NEVER = "never";
    private static final String CURRENCY_PATTERN = "0.00";
    private final List<FormatObject> formatObjects;
    private final String datePattern;
    private static Map<String, FormatObject> decimal = new ConcurrentHashMap<String, FormatObject>(16, 0.75f, 1);
    private static Map<String, FormatObject> scientific = new ConcurrentHashMap<String, FormatObject>(16, 0.75f, 1);
    private static RAVEFormatter DEFAULT_FORMATTER = new RAVEFormatter(null, null, "", "", null, null, false);

    public static RAVEFormatter makeFromSpec(FormatSpec formatSpec, String string) {
        if (formatSpec == null) {
            return DEFAULT_FORMATTER;
        }
        String string2 = "";
        String string3 = "";
        String string4 = null;
        String string5 = null;
        Object object = null;
        ArrayList<FormatObject> arrayList = new ArrayList<FormatObject>();
        if (formatSpec != null) {
            if (formatSpec.numericPattern != null) {
                arrayList.add(new FormatObject("custom_format", formatSpec.numericPattern, string, false));
            }
            if (formatSpec.scientificPattern != null) {
                RAVEFormatter.validateScientificPattern(formatSpec.scientificPattern);
                arrayList.add(new FormatObject("scientific_format", formatSpec.scientificPattern, string, false));
            }
            if (formatSpec.zeroFormat != null && formatSpec.zeroFormat.numericPattern != null) {
                arrayList.add(new FormatObject("zero_format", formatSpec.zeroFormat.numericPattern, string, false));
            }
            if (formatSpec.zeroFormat != null && formatSpec.zeroFormat.scientificPattern != null) {
                RAVEFormatter.validateScientificPattern(formatSpec.zeroFormat.scientificPattern);
                arrayList.add(new FormatObject("zero_scientific_format", formatSpec.zeroFormat.scientificPattern, string, false));
            }
            if (formatSpec.negativeFormat != null && formatSpec.negativeFormat.numericPattern != null) {
                arrayList.add(new FormatObject("negative_format", formatSpec.negativeFormat.numericPattern, string, false));
            }
            if (formatSpec.negativeFormat != null && formatSpec.negativeFormat.scientificPattern != null) {
                RAVEFormatter.validateScientificPattern(formatSpec.negativeFormat.scientificPattern);
                arrayList.add(new FormatObject("negative_scientific_format", formatSpec.negativeFormat.scientificPattern, string, false));
            }
            if (formatSpec.noSpaceFormat != null && formatSpec.noSpaceFormat.pattern != null) {
                arrayList.add(new FormatObject("no_space_format", formatSpec.noSpaceFormat.pattern, string, false));
            }
            string2 = formatSpec.prefix;
            string3 = formatSpec.suffix;
            string4 = formatSpec.fitMethod;
            object = formatSpec.scientific;
            string5 = formatSpec.datePattern;
        }
        return new RAVEFormatter(arrayList, string5, string2, string3, string4, object, false);
    }

    public static FormatSpec makeFormatSpecFromRAVEFormatter(RAVEFormatter rAVEFormatter) {
        FormatSpec formatSpec = null;
        FormatObject formatObject = null;
        if (rAVEFormatter != null) {
            formatSpec = new FormatSpec();
            if (rAVEFormatter.formatObjects != null && rAVEFormatter.formatObjects.size() > 0) {
                formatObject = rAVEFormatter.getFormatObject("custom_format");
                formatSpec.numericPattern = formatObject == null ? null : formatObject.getPattern();
                formatObject = rAVEFormatter.getFormatObject("scientific_format");
                String string = formatSpec.scientificPattern = formatObject == null ? null : formatObject.getPattern();
                if (formatSpec.scientificPattern != null && formatObject != null) {
                    RAVEFormatter.validateScientificPattern(formatSpec.scientificPattern);
                }
                formatObject = rAVEFormatter.getFormatObject("zero_format");
                ZeroFormatSpec zeroFormatSpec = new ZeroFormatSpec();
                zeroFormatSpec.numericPattern = formatObject == null ? null : formatObject.getPattern();
                formatSpec.zeroFormat = zeroFormatSpec;
                formatObject = rAVEFormatter.getFormatObject("zero_scientific_format");
                ZeroFormatSpec zeroFormatSpec2 = new ZeroFormatSpec();
                String string2 = zeroFormatSpec2.scientificPattern = formatObject == null ? null : formatObject.getPattern();
                if (zeroFormatSpec2.scientificPattern != null && formatObject != null) {
                    RAVEFormatter.validateScientificPattern(zeroFormatSpec2.scientificPattern);
                }
                formatSpec.zeroFormat = zeroFormatSpec2;
                formatObject = rAVEFormatter.getFormatObject("negative_format");
                NegativeFormatSpec negativeFormatSpec = new NegativeFormatSpec();
                negativeFormatSpec.numericPattern = formatObject == null ? null : formatObject.getPattern();
                formatSpec.negativeFormat = negativeFormatSpec;
                formatObject = rAVEFormatter.getFormatObject("negative_scientific_format");
                NegativeFormatSpec negativeFormatSpec2 = new NegativeFormatSpec();
                String string3 = negativeFormatSpec2.scientificPattern = formatObject == null ? null : formatObject.getPattern();
                if (negativeFormatSpec2.scientificPattern != null && formatObject != null) {
                    RAVEFormatter.validateScientificPattern(negativeFormatSpec2.scientificPattern);
                }
                formatSpec.negativeFormat = negativeFormatSpec2;
                formatObject = rAVEFormatter.getFormatObject("no_space_format");
                NoSpaceFormatSpec noSpaceFormatSpec = new NoSpaceFormatSpec();
                noSpaceFormatSpec.pattern = formatObject == null ? null : formatObject.getPattern();
                formatSpec.noSpaceFormat = noSpaceFormatSpec;
            }
            formatSpec.datePattern = rAVEFormatter.datePattern;
            formatSpec.prefix = rAVEFormatter.prefix;
            formatSpec.suffix = rAVEFormatter.suffix;
            formatSpec.fitMethod = rAVEFormatter.fitMethod;
        }
        return formatSpec;
    }

    public static RAVEFormatter make(String string, String string2, String string3, boolean bl, String string4) {
        ArrayList<FormatObject> arrayList = new ArrayList<FormatObject>();
        if (string != null) {
            arrayList.add(new FormatObject("custom_format", string, string4, false));
        }
        return new RAVEFormatter(arrayList, null, string2, string3, null, null, bl);
    }

    public RAVEFormatter(List<FormatObject> list, String string, String string2, String string3, String string4, Object object, boolean bl) {
        this.formatObjects = list;
        this.prefix = string2;
        this.suffix = string3;
        this.fitMethod = string4;
        this.scientificSpec = object;
        this.datePattern = string;
    }

    @Override
    public String formatDate(Object object, int n, String string, String string2, String string3) {
        return this.formatLocalizedDate(object, n, string, string2, string3, LocaleUtil.getDefaultLocale(), "GMT");
    }

    @Override
    public String formatLocalizedDate(Object object, int n, String string, String string2, String string3, String string4, String string5) {
        if (object == null) {
            return null;
        }
        Unit unit = Unit.get(string2, null);
        String string6 = DateUtil.INSTANCE.formatDate(object, unit, this.datePattern, string4, string5);
        return this.formatString(string6, n, string, string3);
    }

    @Override
    public String formatNumber(Number number, int n, String string, double d, double d2, String string2, String string3) {
        return this.formatLocalizedNumber(number, n, string, d, d2, string2, string3, LocaleUtil.getDefaultLocale());
    }

    @Override
    public String formatLocalizedNumber(Number number, int n, String string, double d, double d2, String string2, String string3, String string4) {
        String string5;
        if (number == null) {
            return null;
        }
        if (string4 == null) {
            string4 = LocaleUtil.getDefaultLocale();
        }
        Unit unit = Unit.get(string2, null);
        Range range = new Range(d, d2);
        FormatObject formatObject = this.getFormatObj(number, range);
        if (formatObject == null || formatObject.getPattern() == null) {
            string5 = this.defaultFormat(unit, number.doubleValue(), range, string4);
        } else {
            formatObject = new FormatObject(formatObject.getType(), formatObject.getPattern(), string4, formatObject.isUseSymbolsForJson());
            string5 = formatObject.format(number);
        }
        if (unit.isPrefixAbbrev()) {
            return this.formatString(unit.abbreviation + string5, n, string, string3);
        }
        return this.formatString(string5 + unit.abbreviation, n, string, string3);
    }

    private FormatObject getFormat(double d, double d2, Range range, FormatObject formatObject, FormatObject formatObject2) {
        FormatObject formatObject3 = null;
        if (this.scientificSpec == null) {
            if (formatObject != null && formatObject2 != null) {
                formatObject3 = RAVEFormatter.useScientific(d, d2, range) ? formatObject : formatObject2;
            } else if (formatObject2 != null) {
                formatObject3 = formatObject2;
            } else if (formatObject != null) {
                formatObject3 = formatObject;
            }
        } else {
            formatObject3 = RAVEFormatter.useScientific(d, d2, range) ? formatObject : formatObject2;
        }
        return formatObject3;
    }

    @Override
    public String formatString(String string, int n, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (this.prefix != null) {
            string = this.prefix + string;
        }
        if (this.suffix != null) {
            string = string + this.suffix;
        }
        return string;
    }

    private String secondsToTime(double d) {
        double d2;
        String string = d < 0.0 ? "-" : "";
        double d3 = d = Math.abs(d);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (d3 >= 86400.0) {
            d2 = Math.floor(d / 86400.0);
            d = MathUtil.r3(d % 86400.0).doubleValue();
            string2 = (int)d2 + ":";
        }
        if (d3 >= 3600.0) {
            d2 = Math.floor(d / 3600.0);
            d = MathUtil.r3(d % 3600.0).doubleValue();
            string3 = this.addZeroIfLessThanTen(d2, true) + ":";
        }
        if (d3 >= 60.0) {
            d2 = Math.floor(d / 60.0);
            d = MathUtil.r3(d % 60.0).doubleValue();
            string4 = this.addZeroIfLessThanTen(d2, true) + ":";
        }
        string5 = (string5 = this.addZeroIfLessThanTen(d, false)).endsWith(".0") ? string5.substring(0, string5.indexOf(".0")) : string5;
        String string6 = string + string2 + string3 + string4 + string5;
        return string6.equals("00") ? "0" : string6;
    }

    private String addZeroIfLessThanTen(double d, boolean bl) {
        if (d < 10.0) {
            return bl ? "0" + (int)d : "0" + d;
        }
        return bl ? "" + (int)d : "" + d;
    }

    protected String defaultFormat(Unit unit, double d, Range range, String string) {
        FormatObject formatObject;
        if (unit == Unit.TIME) {
            return this.secondsToTime(d);
        }
        boolean bl = unit.measure.type.toString().equals(Unit.DOLLARS.measure.type.toString());
        Range range2 = this.getRangeForScientificNotationSwitching();
        if (bl) {
            formatObject = this.getDefaultFormatObject(range, false, string, bl, d);
        } else {
            boolean bl2 = RAVEFormatter.useScientific(range.getMin(), range.getMax(), range2);
            formatObject = this.getDefaultFormatObject(range, bl2, string, bl, d);
        }
        if (formatObject != null) {
            return formatObject.format(d);
        }
        return null;
    }

    private static boolean useScientific(double d, double d2, Range range) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        return d3 != 0.0 && d3 <= range.getMin() || d3 > range.getMax() || d4 != 0.0 && d4 <= range.getMin() || d4 > range.getMax();
    }

    private Range getRangeForScientificNotationSwitching() {
        double d = 1.0E-4;
        double d2 = 100000.0;
        if (BasicFactory.isString(this.scientificSpec)) {
            if (NEVER.equals(this.scientificSpec)) {
                d = 0.0;
                d2 = Double.POSITIVE_INFINITY;
            }
            if (ALWAYS.equals(this.scientificSpec)) {
                d = 0.0;
                d2 = 0.0;
            }
        } else if (this.scientificSpec instanceof ScientificSpec) {
            ScientificSpec scientificSpec = (ScientificSpec)this.scientificSpec;
            this.validateScientificSpec(scientificSpec);
            if (scientificSpec.lower != null) {
                d = scientificSpec.lower.doubleValue();
            }
            if (scientificSpec.upper != null) {
                d2 = scientificSpec.upper.doubleValue();
            }
        }
        return new Range(d, d2);
    }

    private void validateScientificSpec(ScientificSpec scientificSpec) {
        if (scientificSpec.lower != null && scientificSpec.upper != null && scientificSpec.lower.doubleValue() > scientificSpec.upper.doubleValue()) {
            throw new EngineException("Scientific lower attribute value should be less then the upper attribute value. ", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (scientificSpec.lower != null && scientificSpec.lower.doubleValue() > this.defaultMax) {
            throw new EngineException("Only Scientific lower attribute value is present which is greater then RAVE default upper. Please consider providing a Scientific upper attribute value.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (scientificSpec.upper != null && scientificSpec.upper.doubleValue() < this.defaultMin) {
            throw new EngineException("Only Scientific upper attribute value is present which is less then RAVE default lower. Please consider providing a Scientific lower attribute value.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    private FormatObject getDefaultFormatObject(Range range, boolean bl, String string, boolean bl2, double d) {
        boolean bl3;
        FormatObject formatObject = null;
        int n = -1;
        n = range.getDelta() == -1.0 ? range.getFormattingPrecision() : range.getPrecision();
        boolean bl4 = bl3 = bl2 && range.getMax() < 100000.0 && (n > 0 || Math.floor(d) != d);
        if (bl3) {
            n = 2;
        } else if (bl2) {
            n = 0;
        }
        FormatObject formatObject2 = formatObject = bl ? scientific.get(string + ":" + n) : decimal.get(string + ":" + n);
        if (formatObject == null) {
            if (bl2) {
                String string2 = bl3 ? CURRENCY_PATTERN : "##";
                formatObject = new FormatObject("default_format", string2, string, false);
                decimal.put(string + ":" + n, formatObject);
            } else {
                String string3 = bl ? "0.000" : "#.###";
                String string4 = bl ? "0" : "#";
                for (int i = 3; i < n; ++i) {
                    string3 = string3 + string4;
                }
                if (bl) {
                    string3 = string3 + "E0";
                }
                formatObject = new FormatObject("default_format", string3, string, false);
                if (bl) {
                    scientific.put(string + ":" + n, formatObject);
                } else {
                    decimal.put(string + ":" + n, formatObject);
                }
            }
        }
        return formatObject;
    }

    private FormatObject getFormatObject(String string) {
        if (this.formatObjects == null || this.formatObjects.size() == 0) {
            return null;
        }
        for (FormatObject formatObject : this.formatObjects) {
            if (!string.equals(formatObject.getType())) continue;
            return formatObject;
        }
        return null;
    }

    public String formatToExponential(Number number, double d, double d2, String string) {
        FormatObject formatObject = this.getDefaultFormatObject(new Range(d, d2), true, string, false, number.doubleValue());
        if (formatObject != null) {
            return formatObject.format(number);
        }
        return null;
    }

    public String formatLocalizedNumberRange(Number number, int n, String string, Range range, String string2, String string3, String string4) {
        String string5;
        if (number == null) {
            return null;
        }
        if (string4 == null) {
            string4 = LocaleUtil.getDefaultLocale();
        }
        if (range.getDelta() == -1.0) {
            return this.formatLocalizedNumber(number, n, string, range.getMin(), range.getMax(), string2, string3, string4);
        }
        Unit unit = Unit.get(string2, null);
        FormatObject formatObject = this.getFormatObj(number, range);
        if (formatObject == null) {
            string5 = this.defaultFormat(unit, number.doubleValue(), range, string4);
        } else {
            formatObject = new FormatObject(formatObject.getType(), formatObject.getPattern(), string4, formatObject.isUseSymbolsForJson());
            string5 = formatObject.format(number);
        }
        if (unit.isPrefixAbbrev()) {
            return this.formatString(unit.abbreviation + string5, n, string, string3);
        }
        return this.formatString(string5 + unit.abbreviation, n, string, string3);
    }

    private FormatObject getFormatObj(Number number, Range range) {
        FormatObject formatObject = null;
        FormatObject formatObject2 = null;
        FormatObject formatObject3 = null;
        Range range2 = this.getRangeForScientificNotationSwitching();
        if (number.doubleValue() < 0.0) {
            formatObject2 = this.getFormatObject("negative_scientific_format");
            formatObject3 = this.getFormatObject("negative_format");
        } else if (number.doubleValue() == 0.0) {
            formatObject2 = this.getFormatObject("zero_scientific_format");
            formatObject3 = this.getFormatObject("zero_format");
        }
        formatObject = this.getFormat(range.getMin(), range.getMax(), range2, formatObject2, formatObject3);
        if (formatObject == null) {
            formatObject2 = this.getFormatObject("scientific_format");
            formatObject3 = this.getFormatObject("custom_format");
            formatObject = this.getFormat(range.getMin(), range.getMax(), range2, formatObject2, formatObject3);
        }
        return formatObject;
    }

    public final String getFitMethod() {
        return this.fitMethod;
    }

    private static void validateScientificPattern(String string) {
        if (!string.contains("E")) {
            throw new EngineException("Invalid scientific pattern. A pattern containig 'E' was expected. Example : 0.#E0", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
    }

    public boolean isRAVEFormatterEmpty() {
        return !(this.formatObjects != null && this.formatObjects.size() != 0 || this.datePattern != null && this.datePattern.length() != 0 || this.prefix != null && this.prefix.length() != 0 || this.suffix != null && this.suffix.length() != 0);
    }
}

