/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Poly;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CurveToPoly {
    private final DoublePrimitiveArrayList px;
    private final DoublePrimitiveArrayList py;
    private final Poly result;

    public static final Poly linearize(Curve curve) {
        for (int i = 0; i < curve.getX().length; ++i) {
            if (!curve.getControls()[i]) continue;
            CurveToPoly curveToPoly = new CurveToPoly(curve);
            return curveToPoly.result;
        }
        return new Poly(curve.getX(), curve.getY(), curve.filled());
    }

    private CurveToPoly(Curve curve) {
        int n = curve.getX().length;
        this.px = new DoublePrimitiveArrayList(n);
        this.py = new DoublePrimitiveArrayList(n);
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7 = curve.getX()[i];
            double d8 = curve.getY()[i];
            if (!curve.getControls()[i]) {
                this.px.add(d7);
                this.py.add(d8);
                continue;
            }
            if (!curve.getControls()[i + 1]) {
                d6 = curve.getX()[++i];
                d5 = curve.getY()[i];
                d4 = this.px.get(this.px.size() - 1);
                d3 = this.py.get(this.py.size() - 1);
                d2 = d4 / 3.0 + 2.0 * d7 / 3.0;
                d = d3 / 3.0 + 2.0 * d8 / 3.0;
                double d9 = d6 / 3.0 + 2.0 * d7 / 3.0;
                double d10 = d5 / 3.0 + 2.0 * d8 / 3.0;
                this.curveTo(d4, d3, d6, d5, d2, d, d9, d10);
                continue;
            }
            assert (!curve.getControls()[i + 2]);
            d6 = curve.getX()[++i];
            d5 = curve.getY()[i];
            d4 = curve.getX()[++i];
            d3 = curve.getY()[i];
            d2 = this.px.get(this.px.size() - 1);
            d = this.py.get(this.py.size() - 1);
            this.curveTo(d2, d, d4, d3, d7, d8, d6, d5);
        }
        this.result = new Poly(this.px.toArray(), this.py.toArray(), curve.filled());
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = Line.extendedLineDistanceToPoint(d, d2, d3, d4, d5, d6);
        double d11 = Math.max(d10, d9 = Line.extendedLineDistanceToPoint(d, d2, d3, d4, d7, d8));
        if (d11 <= 0.25 || Double.isNaN(d11)) {
            this.px.add(d3);
            this.py.add(d4);
        } else {
            double d12 = 0.125 * d + 0.375 * d5 + 0.375 * d7 + 0.125 * d3;
            double d13 = 0.125 * d2 + 0.375 * d6 + 0.375 * d8 + 0.125 * d4;
            double d14 = 0.5 * (d + d5);
            double d15 = 0.5 * (d2 + d6);
            double d16 = 0.5 * (d5 + d7);
            double d17 = 0.5 * (d6 + d8);
            double d18 = 0.5 * (d7 + d3);
            double d19 = 0.5 * (d8 + d4);
            double d20 = 0.5 * (d14 + d16);
            double d21 = 0.5 * (d15 + d17);
            double d22 = 0.5 * (d16 + d18);
            double d23 = 0.5 * (d17 + d19);
            this.curveTo(d, d2, d12, d13, d14, d15, d20, d21);
            this.curveTo(d12, d13, d3, d4, d22, d23, d18, d19);
        }
    }
}

